/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.runtime.gc.heap;

import java.lang.invoke.VarHandle;
import org.qbicc.runtime.Build;
import org.qbicc.runtime.CNative;
import org.qbicc.runtime.Inline;
import org.qbicc.runtime.posix.String;
import org.qbicc.runtime.posix.SysMman;
import org.qbicc.runtime.posix.SysTypes;
import org.qbicc.runtime.posix.Unistd;
import org.qbicc.runtime.stdc.Errno;
import org.qbicc.runtime.stdc.Stddef;
import org.qbicc.runtime.stdc.Stdint;
import org.qbicc.runtime.stdc.Stdio;
import org.qbicc.runtime.stdc.Stdlib;

public final class Heap {
    private static boolean initOk;
    private static int initErrno;
    private static // Could not load outer class - annotation placement on inner may be incorrect
    CNative.ptr<// Could not load outer class - annotation placement on inner may be incorrect
    @CNative.c_const CNative.c_char> errorMsgTemplate;
    private static // Could not load outer class - annotation placement on inner may be incorrect
    CNative.ptr<// Could not load outer class - annotation placement on inner may be incorrect
    @CNative.c_const CNative.c_char> errorExtraArg;
    private static long pageSize;
    private static CNative.void_ptr heap;
    private static long allocated;
    private static long committed;
    private static long limit;
    public static final OutOfMemoryError OOME;

    private Heap() {
    }

    public static native long getConfiguredMinHeapSize();

    public static native long getConfiguredMaxHeapSize();

    public static native long getConfiguredHeapAlignment();

    public static native int getConfiguredObjectAlignment();

    public static CNative.void_ptr pointerToOffset(long offset) {
        return (CNative.void_ptr)heap.plus(offset);
    }

    public static long getHeapUnallocated() {
        return limit - ((Stdint.int64_t)CNative.addr_of((long)allocated).loadSingleAcquire()).longValue();
    }

    public static long getPageSize() {
        return pageSize;
    }

    public static long getCurrentHeapOffset() {
        return allocated;
    }

    public static long allocateRegion(long expectedOffset, long size) throws IllegalArgumentException, OutOfMemoryError {
        long newOffset;
        long oldOffset;
        if (Build.isHost()) {
            throw new IllegalStateException();
        }
        if ((size & pageSize - 1L) != 0L) {
            throw new IllegalArgumentException();
        }
        Stdint.int64_t_ptr allocatedPtr = CNative.addr_of((long)allocated);
        long limit = Heap.limit;
        do {
            oldOffset = ((Stdint.int64_t)allocatedPtr.loadSingleAcquire()).longValue();
            if (expectedOffset != -1L && oldOffset != expectedOffset) {
                return oldOffset;
            }
            newOffset = oldOffset + size;
            if (newOffset > limit) {
                throw OOME;
            }
            Heap.commitUpTo(newOffset);
        } while (!allocatedPtr.compareAndSetRelease((Object)((Stdint.int64_t)CNative.word((long)oldOffset)), (Object)((Stdint.int64_t)CNative.word((long)newOffset))));
        return oldOffset;
    }

    public static void commitUpTo(long index) throws IllegalArgumentException, OutOfMemoryError {
        long committedOld;
        if (Build.isHost()) {
            throw new IllegalStateException();
        }
        if ((index & pageSize - 1L) != 0L) {
            throw new IllegalArgumentException();
        }
        if (index > limit) {
            throw OOME;
        }
        Stdint.int64_t_ptr committedPtr = CNative.addr_of((long)committed);
        do {
            if ((committedOld = ((Stdint.int64_t)committedPtr.loadSingleAcquire()).longValue()) >= index) {
                return;
            }
            CNative.c_int res = SysMman.mprotect((CNative.void_ptr)((CNative.void_ptr)heap.plus(committedOld)), (Stddef.size_t)((Stddef.size_t)CNative.word((long)(index - committedOld))), (CNative.c_int)((CNative.c_int)CNative.wordOr((CNative.word)SysMman.PROT_READ, (CNative.word)SysMman.PROT_WRITE)));
            if (res != CNative.word((int)-1)) continue;
            throw OOME;
        } while (!committedPtr.compareAndSetRelease((Object)((Stdint.int64_t)CNative.word((long)committedOld)), (Object)((Stdint.int64_t)CNative.word((long)index))));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static boolean checkInit(boolean printErrors) {
        if (!initOk) {
            if (printErrors) {
                int initErrno = Heap.initErrno;
                // Could not load outer class - annotation placement on inner may be incorrect
                @CNative.c_const CNative.ptr errorMsgTemplate = Heap.errorMsgTemplate;
                // Could not load outer class - annotation placement on inner may be incorrect
                @CNative.c_const CNative.ptr message = errorMsgTemplate.isZero() ? (CNative.ptr)CNative.utf8z((java.lang.String)"Heap initialization was not completed").cast() : errorMsgTemplate;
                int bufSize = 256;
                CNative.ptr buf = (CNative.ptr)CNative.alloca((Stddef.size_t)((Stddef.size_t)CNative.word((int)256))).cast();
                CNative.ptr arg = String.strerror_r((CNative.c_int)((CNative.c_int)CNative.word((int)initErrno)), (CNative.ptr)buf, (Stddef.size_t)((Stddef.size_t)CNative.word((int)256))).isNonZero() ? (CNative.ptr)CNative.utf8z((java.lang.String)"(too long)").cast() : buf;
                Stdio.fprintf((Stdio.FILE_ptr)Stdio.stderr, (CNative.const_char_ptr)((CNative.const_char_ptr)message.cast()), (CNative.object[])new CNative.object[]{arg, errorExtraArg});
                Stdio.fflush((CNative.ptr)Stdio.stderr);
            }
            return false;
        }
        return true;
    }

    public static boolean isHeapArgument(// Could not load outer class - annotation placement on inner may be incorrect
    CNative.ptr<// Could not load outer class - annotation placement on inner may be incorrect
    @CNative.c_const CNative.c_char> argPtr) {
        return org.qbicc.runtime.stdc.String.strncmp((CNative.const_char_ptr)((CNative.const_char_ptr)argPtr.cast()), (CNative.const_char_ptr)CNative.utf8z((java.lang.String)"-Xmx"), (Stddef.size_t)((Stddef.size_t)CNative.word((int)4))).isZero() || org.qbicc.runtime.stdc.String.strncmp((CNative.const_char_ptr)((CNative.const_char_ptr)argPtr.cast()), (CNative.const_char_ptr)CNative.utf8z((java.lang.String)"-Xms"), (Stddef.size_t)((Stddef.size_t)CNative.word((int)4))).isZero();
    }

    @CNative.export
    public static boolean initHeap(int argc, CNative.char_ptr_ptr argv) {
        CNative.c_int res;
        int pageSize;
        if (Build.isHost()) {
            throw new IllegalStateException();
        }
        if (initOk) {
            return true;
        }
        if (Build.Target.isPosix()) {
            pageSize = Unistd.sysconf((CNative.c_int)Unistd._SC_PAGE_SIZE).intValue();
            if (pageSize == -1) {
                errorMsgTemplate = (CNative.ptr)CNative.utf8z((java.lang.String)"Failed to determine page size: %s\n").cast();
                initErrno = Errno.errno;
                return false;
            }
            if (Integer.bitCount(pageSize) != 1) {
                return false;
            }
        } else {
            errorMsgTemplate = (CNative.ptr)CNative.utf8z((java.lang.String)"Platform not supported\n").cast();
            return false;
        }
        Heap.pageSize = pageSize;
        long pageMask = pageSize - 1;
        long maxHeap = -1L;
        long minHeap = -1L;
        for (int i = 1; i < argc; ++i) {
            CNative.const_char_ptr arg = (CNative.const_char_ptr)((CNative.char_ptr[])argv.asArray())[i].cast();
            if (org.qbicc.runtime.stdc.String.strncmp((CNative.const_char_ptr)arg, (CNative.const_char_ptr)CNative.utf8z((java.lang.String)"-Xmx"), (Stddef.size_t)((Stddef.size_t)CNative.word((int)4))) == CNative.zero()) {
                maxHeap = Heap.parseMemSize((CNative.char_ptr)arg.plus(4));
                if (maxHeap == -1L) {
                    return false;
                }
                if (maxHeap >= Heap.pageSize) continue;
                maxHeap = Heap.pageSize;
                continue;
            }
            if (org.qbicc.runtime.stdc.String.strncmp((CNative.const_char_ptr)arg, (CNative.const_char_ptr)CNative.utf8z((java.lang.String)"-Xms"), (Stddef.size_t)((Stddef.size_t)CNative.word((int)4))) == CNative.zero()) {
                minHeap = Heap.parseMemSize((CNative.char_ptr)arg.plus(4));
                if (minHeap == -1L) {
                    return false;
                }
                if (minHeap >= Heap.pageSize) continue;
                minHeap = Heap.pageSize;
                continue;
            }
            if (org.qbicc.runtime.stdc.String.strcmp((CNative.const_char_ptr)arg, (CNative.const_char_ptr)CNative.utf8z((java.lang.String)"--")) == CNative.zero()) break;
        }
        if (maxHeap == -1L && minHeap == -1L) {
            maxHeap = Heap.getConfiguredMaxHeapSize();
            minHeap = Heap.getConfiguredMinHeapSize();
            if ((maxHeap = maxHeap + pageMask & (pageMask ^ 0xFFFFFFFFFFFFFFFFL)) < (minHeap = minHeap + pageMask & (pageMask ^ 0xFFFFFFFFFFFFFFFFL))) {
                maxHeap = minHeap;
            }
        } else if (maxHeap == -1L) {
            maxHeap = Heap.getConfiguredMaxHeapSize();
            if ((maxHeap = maxHeap + pageMask & (pageMask ^ 0xFFFFFFFFFFFFFFFFL)) < (minHeap = minHeap + pageMask & (pageMask ^ 0xFFFFFFFFFFFFFFFFL))) {
                maxHeap = minHeap;
            }
        } else if (minHeap == -1L) {
            minHeap = Heap.getConfiguredMinHeapSize();
            if ((maxHeap = maxHeap + pageMask & (pageMask ^ 0xFFFFFFFFFFFFFFFFL)) < (minHeap = minHeap + pageMask & (pageMask ^ 0xFFFFFFFFFFFFFFFFL))) {
                minHeap = maxHeap;
            }
        } else if ((maxHeap = maxHeap + pageMask & (pageMask ^ 0xFFFFFFFFFFFFFFFFL)) < (minHeap = minHeap + pageMask & (pageMask ^ 0xFFFFFFFFFFFFFFFFL))) {
            maxHeap = minHeap;
        }
        long heapAlignment = Heap.getConfiguredHeapAlignment();
        CNative.void_ptr heap = SysMman.mmap((CNative.void_ptr)((CNative.void_ptr)CNative.zero()), (Stddef.size_t)((Stddef.size_t)CNative.word((long)(maxHeap + heapAlignment))), (CNative.c_int)SysMman.PROT_NONE, (CNative.c_int)((CNative.c_int)CNative.wordOr((CNative.word)SysMman.MAP_ANON, (CNative.word)SysMman.MAP_PRIVATE)), (CNative.c_int)((CNative.c_int)CNative.word((int)-1)), (SysTypes.off_t)((SysTypes.off_t)CNative.zero()));
        if (heap == SysMman.MAP_FAILED) {
            errorMsgTemplate = (CNative.ptr)CNative.utf8z((java.lang.String)"Failed to map initial heap: %s\n").cast();
            initErrno = Errno.errno;
            return false;
        }
        long misalignment = heap.longValue() & heapAlignment - 1L;
        long trimAtStart = heapAlignment - misalignment;
        if (trimAtStart > 0L) {
            SysMman.munmap((CNative.void_ptr)heap, (Stddef.size_t)((Stddef.size_t)CNative.word((long)trimAtStart)));
            heap = (CNative.void_ptr)heap.plus(trimAtStart);
        }
        if (misalignment > 0L) {
            SysMman.munmap((CNative.void_ptr)((CNative.void_ptr)heap.plus(maxHeap)), (Stddef.size_t)((Stddef.size_t)CNative.word((long)misalignment)));
        }
        if ((res = Heap.mprotect0(minHeap, heap)) == CNative.word((int)-1)) {
            errorMsgTemplate = (CNative.ptr)CNative.utf8z((java.lang.String)"Failed to commit minimum heap space: %s\n").cast();
            initErrno = Errno.errno;
            return false;
        }
        Heap.heap = heap;
        allocated = 0L;
        committed = minHeap;
        limit = maxHeap;
        initOk = true;
        VarHandle.releaseFence();
        return true;
    }

    @Inline
    private static CNative.c_int mprotect0(long minHeap, CNative.void_ptr heap) {
        if (Build.Target.isWasm()) {
            return (CNative.c_int)CNative.word((int)0);
        }
        return SysMman.mprotect((CNative.void_ptr)heap, (Stddef.size_t)((Stddef.size_t)CNative.word((long)minHeap)), (CNative.c_int)((CNative.c_int)CNative.wordOr((CNative.word)SysMman.PROT_READ, (CNative.word)SysMman.PROT_WRITE)));
    }

    @CNative.export(withScope=CNative.ExportScope.LOCAL)
    private static long parseMemSize(CNative.char_ptr arg) {
        CNative.char_ptr endPtr = (CNative.char_ptr)CNative.auto();
        long num = Stdlib.strtoll((CNative.const_char_ptr)((CNative.const_char_ptr)arg.cast()), (CNative.char_ptr_ptr)((CNative.char_ptr_ptr)CNative.addr_of((CNative.object)endPtr)), (CNative.c_int)((CNative.c_int)CNative.word((int)10))).longValue();
        char ch = ((CNative.unsigned_char)((CNative.c_char)endPtr.loadUnshared()).cast(CNative.unsigned_char.class)).charValue();
        if (ch != '\u0000') {
            if (ch == 'T' || ch == 't') {
                num *= 0x10000000000L;
                endPtr = (CNative.char_ptr)endPtr.plus(1);
            } else if (ch == 'G' || ch == 'g') {
                num *= 0x40000000L;
                endPtr = (CNative.char_ptr)endPtr.plus(1);
            } else if (ch == 'M' || ch == 'm') {
                num *= 0x100000L;
                endPtr = (CNative.char_ptr)endPtr.plus(1);
            } else if (ch == 'K' || ch == 'k') {
                num *= 1024L;
                endPtr = (CNative.char_ptr)endPtr.plus(1);
            }
        }
        if ((ch = ((CNative.unsigned_char)((CNative.c_char)endPtr.loadUnshared()).cast(CNative.unsigned_char.class)).charValue()) != '\u0000') {
            errorMsgTemplate = (CNative.ptr)CNative.utf8z((java.lang.String)"Invalid memory size: %2$s\n").cast();
            errorExtraArg = arg;
            return -1L;
        }
        return num;
    }

    @CNative.destructor(priority=0)
    @CNative.export
    static void destroyHeap() {
        VarHandle.acquireFence();
        CNative.void_ptr heap = Heap.heap;
        if (heap != null) {
            SysMman.munmap((CNative.void_ptr)heap, (Stddef.size_t)((Stddef.size_t)CNative.word((long)limit)));
        }
        Heap.heap = (CNative.void_ptr)CNative.zero();
        VarHandle.releaseFence();
    }

    static {
        OutOfMemoryError error = new OutOfMemoryError();
        error.setStackTrace(new StackTraceElement[0]);
        OOME = error;
    }
}

