/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.opt;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.collections.api.factory.Maps;
import org.qbicc.context.CompilationContext;
import org.qbicc.context.ProgramLocatable;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.BlockEarlyTermination;
import org.qbicc.graph.BlockLabel;
import org.qbicc.graph.Call;
import org.qbicc.graph.CallNoReturn;
import org.qbicc.graph.CallNoSideEffects;
import org.qbicc.graph.DelegatingBasicBlockBuilder;
import org.qbicc.graph.Invoke;
import org.qbicc.graph.InvokeNoReturn;
import org.qbicc.graph.Node;
import org.qbicc.graph.NodeVisitor;
import org.qbicc.graph.Return;
import org.qbicc.graph.Slot;
import org.qbicc.graph.TailCall;
import org.qbicc.graph.Terminator;
import org.qbicc.graph.Throw;
import org.qbicc.graph.Value;
import org.qbicc.graph.literal.ExecutableLiteral;
import org.qbicc.graph.literal.ProgramObjectLiteral;
import org.qbicc.object.DataDeclaration;
import org.qbicc.object.Declaration;
import org.qbicc.object.FunctionDeclaration;
import org.qbicc.object.ProgramObject;
import org.qbicc.type.ValueType;
import org.qbicc.type.VoidType;
import org.qbicc.type.definition.MethodBody;
import org.qbicc.type.definition.element.ExecutableElement;
import org.qbicc.type.definition.element.FunctionElement;
import org.qbicc.type.definition.element.MemberElement;
import org.qbicc.type.definition.element.MethodElement;

public class InliningBasicBlockBuilder
extends DelegatingBasicBlockBuilder {
    private final CompilationContext ctxt = this.getContext();
    private final float costThreshold = 50.0f;
    private final int depthThreshold = 10;
    private int depth = 0;

    private InliningBasicBlockBuilder(BasicBlockBuilder.FactoryContext ctxt, BasicBlockBuilder delegate) {
        super(delegate);
    }

    public static BasicBlockBuilder createIfNeeded(BasicBlockBuilder.FactoryContext ctxt, BasicBlockBuilder delegate) {
        if (delegate.getRootElement() instanceof FunctionElement) {
            return delegate;
        }
        return new InliningBasicBlockBuilder(ctxt, delegate);
    }

    public Value call(Value targetPtr, Value receiver, List<Value> arguments) {
        BlockLabel resumeLabel;
        BasicBlock inlined;
        ExecutableElement toInline = this.getInlinedElement(targetPtr);
        if (toInline != null && (inlined = this.doInline(receiver, toInline, arguments, null, arg_0 -> this.lambda$call$0(resumeLabel = new BlockLabel(), arg_0), Map.of())) != null) {
            this.begin(resumeLabel);
            ValueType returnType = toInline.getType().getReturnType();
            return returnType instanceof VoidType ? this.emptyVoid() : this.addParam(resumeLabel, Slot.result(), returnType);
        }
        return super.call(targetPtr, receiver, arguments);
    }

    public Value callNoSideEffects(Value targetPtr, Value receiver, List<Value> arguments) {
        BlockLabel resumeLabel;
        BasicBlock inlined;
        ExecutableElement toInline = this.getInlinedElement(targetPtr);
        if (toInline != null && (inlined = this.doInline(receiver, toInline, arguments, null, arg_0 -> this.lambda$callNoSideEffects$1(resumeLabel = new BlockLabel(), arg_0), Map.of())) != null) {
            this.begin(resumeLabel);
            ValueType returnType = toInline.getType().getReturnType();
            return returnType instanceof VoidType ? this.emptyVoid() : this.addParam(resumeLabel, Slot.result(), returnType);
        }
        return super.callNoSideEffects(targetPtr, receiver, arguments);
    }

    public BasicBlock callNoReturn(Value targetPtr, Value receiver, List<Value> arguments) {
        BasicBlock inlined;
        ExecutableElement toInline = this.getInlinedElement(targetPtr);
        if (toInline != null && (inlined = this.doInline(receiver, toInline, arguments, null, val -> {
            this.ctxt.error(this.getLocation(), "Invalid return from noreturn method", new Object[0]);
            throw new BlockEarlyTermination(this.unreachable());
        }, Map.of())) != null) {
            return inlined;
        }
        return super.callNoReturn(targetPtr, receiver, arguments);
    }

    public BasicBlock invokeNoReturn(Value targetPtr, Value receiver, List<Value> arguments, BlockLabel catchLabel, Map<Slot, Value> targetArguments) {
        BasicBlock inlined;
        ExecutableElement toInline = this.getInlinedElement(targetPtr);
        if (toInline != null && (inlined = this.doInline(receiver, toInline, arguments, catchLabel, val -> {
            this.ctxt.error(this.getLocation(), "Invalid return from noreturn method", new Object[0]);
            throw new BlockEarlyTermination(this.unreachable());
        }, targetArguments)) != null) {
            return inlined;
        }
        return super.invokeNoReturn(targetPtr, receiver, arguments, catchLabel, targetArguments);
    }

    public BasicBlock tailCall(Value targetPtr, Value receiver, List<Value> arguments) {
        BasicBlock inlined;
        ExecutableElement toInline = this.getInlinedElement(targetPtr);
        if (toInline != null && (inlined = this.doInline(receiver, toInline, arguments, null, arg_0 -> ((InliningBasicBlockBuilder)this).return_(arg_0), Map.of())) != null) {
            return inlined;
        }
        return super.tailCall(targetPtr, receiver, arguments);
    }

    public Value invoke(Value targetPtr, Value receiver, List<Value> arguments, BlockLabel catchLabel, BlockLabel resumeLabel, Map<Slot, Value> targetArguments) {
        BasicBlock inlined;
        ExecutableElement toInline = this.getInlinedElement(targetPtr);
        if (toInline != null && (inlined = this.doInline(receiver, toInline, arguments, catchLabel, val -> this.goto_(resumeLabel, val.getType() instanceof VoidType ? targetArguments : InliningBasicBlockBuilder.addArg(targetArguments, Slot.result(), val)), targetArguments)) != null) {
            ValueType returnType = toInline.getType().getReturnType();
            return returnType instanceof VoidType ? this.emptyVoid() : this.addParam(resumeLabel, Slot.result(), returnType);
        }
        return super.invoke(targetPtr, receiver, arguments, catchLabel, resumeLabel, targetArguments);
    }

    private ExecutableElement getInlinedElement(Value target) {
        ExecutableLiteral el;
        ExecutableElement element;
        if (target instanceof ExecutableLiteral && (element = (el = (ExecutableLiteral)target).getExecutable()) instanceof MethodElement && element.hasNoModifiersOf(0x200000)) {
            return element;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BasicBlock doInline(Value receiver, ExecutableElement element, List<Value> arguments, BlockLabel catchLabel, Function<Value, BasicBlock> onReturn, Map<Slot, Value> targetArguments) {
        MethodBody body = element.getPreviousMethodBody();
        if (body != null && this.depth < 10) {
            boolean inline = element.hasAllModifiersOf(0x100000);
            if (!inline) {
                boolean bl = inline = (float)this.estimateInlineCost(body) < 50.0f;
            }
            if (!inline) {
                return null;
            }
            ++this.depth;
            try {
                BlockLabel inlinedMethodEntry = new BlockLabel();
                BasicBlock inlinedBlock = this.goto_(inlinedMethodEntry, this.buildArguments(receiver, arguments));
                ProgramLocatable oldCallSite = this.setCallSite((ProgramLocatable)inlinedBlock.getTerminator());
                try {
                    Node.Copier copier = new Node.Copier(body.getEntryBlock(), this.getFirstBuilder(), this.ctxt, (ctxt, visitor) -> new Visitor((NodeVisitor<Node.Copier, Value, Node, BasicBlock>)visitor, onReturn, catchLabel, targetArguments));
                    copier.copyBlockAs(body.getEntryBlock(), inlinedMethodEntry);
                    copier.copyProgram();
                }
                finally {
                    this.setCallSite(oldCallSite);
                }
                BasicBlock basicBlock = inlinedBlock;
                return basicBlock;
            }
            finally {
                --this.depth;
            }
        }
        return null;
    }

    private Map<Slot, Value> buildArguments(Value receiver, List<Value> arguments) {
        HashMap<Slot, Value> map = new HashMap<Slot, Value>(arguments.size() + 1);
        if (!(receiver.getType() instanceof VoidType)) {
            map.put(Slot.this_(), receiver);
        }
        for (int i = 0; i < arguments.size(); ++i) {
            map.put(Slot.funcParam((int)i), arguments.get(i));
        }
        return Map.copyOf(map);
    }

    private int estimateInlineCost(MethodBody body) {
        BasicBlock entryBlock = body.getEntryBlock();
        HashSet<BasicBlock> visited = new HashSet<BasicBlock>();
        return this.estimateInlineCost(entryBlock, visited, 0);
    }

    private int estimateInlineCost(BasicBlock block, HashSet<BasicBlock> visited, int costSoFar) {
        if (visited.add(block)) {
            if ((float)(costSoFar += block.getInstructions().size()) >= 50.0f) {
                return Integer.MAX_VALUE;
            }
            Terminator t = block.getTerminator();
            int cnt = t.getSuccessorCount();
            for (int i = 0; i < cnt; ++i) {
                costSoFar = this.estimateInlineCost(t.getSuccessor(i), visited, costSoFar);
                if (!((float)costSoFar >= 50.0f)) continue;
                return Integer.MAX_VALUE;
            }
        }
        return costSoFar;
    }

    private static Map<Slot, Value> addArg(Map<Slot, Value> targetArguments, Slot slot, Value value) {
        return Maps.immutable.ofMap(targetArguments).newWithKeyValue((Object)slot, (Object)value).castToMap();
    }

    private /* synthetic */ BasicBlock lambda$callNoSideEffects$1(BlockLabel resumeLabel, Value val) {
        return this.goto_(resumeLabel, val.getType() instanceof VoidType ? Map.of() : Map.of(Slot.result(), val));
    }

    private /* synthetic */ BasicBlock lambda$call$0(BlockLabel resumeLabel, Value val) {
        return this.goto_(resumeLabel, val.getType() instanceof VoidType ? Map.of() : Map.of(Slot.result(), val));
    }

    final class Visitor
    implements NodeVisitor.Delegating<Node.Copier, Value, Node, BasicBlock> {
        private final NodeVisitor<Node.Copier, Value, Node, BasicBlock> delegate;
        private final Function<Value, BasicBlock> onReturn;
        private final BlockLabel catchLabel;
        private final Map<Slot, Value> catchArguments;

        Visitor(NodeVisitor<Node.Copier, Value, Node, BasicBlock> delegate, Function<Value, BasicBlock> onReturn, BlockLabel catchLabel, Map<Slot, Value> catchArguments) {
            this.delegate = delegate;
            this.onReturn = onReturn;
            this.catchLabel = catchLabel;
            this.catchArguments = catchArguments;
        }

        public NodeVisitor<Node.Copier, Value, Node, BasicBlock> getDelegateNodeVisitor() {
            return this.delegate;
        }

        public BasicBlock visit(Node.Copier param, Return node) {
            try {
                param.copyNode(node.getDependency());
                return this.onReturn.apply(param.copyValue(node.getReturnValue()));
            }
            catch (BlockEarlyTermination e) {
                return e.getTerminatedBlock();
            }
        }

        public Value visit(Node.Copier param, Call node) {
            if (this.catchLabel != null) {
                param.copyNode(node.getDependency());
                BlockLabel resume = new BlockLabel();
                InliningBasicBlockBuilder.this.invoke(param.copyValue(node.getTarget()), param.copyValue(node.getReceiver()), param.copyValues(node.getArguments()), this.catchLabel, resume, this.catchArguments);
                InliningBasicBlockBuilder.this.begin(resume);
                ValueType rt = node.getTarget().getReturnType();
                return rt instanceof VoidType ? InliningBasicBlockBuilder.this.emptyVoid() : InliningBasicBlockBuilder.this.addParam(resume, Slot.result(), rt);
            }
            return (Value)this.delegate.visit((Object)param, node);
        }

        public Value visit(Node.Copier param, CallNoSideEffects node) {
            if (this.catchLabel != null) {
                BlockLabel resume = new BlockLabel();
                InliningBasicBlockBuilder.this.invoke(param.copyValue(node.getTarget()), param.copyValue(node.getReceiver()), param.copyValues(node.getArguments()), this.catchLabel, resume, this.catchArguments);
                InliningBasicBlockBuilder.this.begin(resume);
                ValueType rt = node.getTarget().getReturnType();
                return rt instanceof VoidType ? InliningBasicBlockBuilder.this.emptyVoid() : InliningBasicBlockBuilder.this.addParam(resume, Slot.result(), rt);
            }
            return (Value)this.delegate.visit((Object)param, node);
        }

        public BasicBlock visit(Node.Copier param, CallNoReturn node) {
            if (this.catchLabel != null) {
                param.copyNode(node.getDependency());
                return InliningBasicBlockBuilder.this.invokeNoReturn(param.copyValue(node.getTarget()), param.copyValue(node.getReceiver()), param.copyValues(node.getArguments()), this.catchLabel, this.catchArguments);
            }
            return (BasicBlock)this.delegate.visit((Object)param, node);
        }

        public BasicBlock visit(Node.Copier param, TailCall node) {
            if (this.catchLabel != null) {
                param.copyNode(node.getDependency());
                BlockLabel resume = new BlockLabel();
                InliningBasicBlockBuilder.this.invoke(param.copyValue(node.getTarget()), param.copyValue(node.getReceiver()), param.copyValues(node.getArguments()), this.catchLabel, resume, this.catchArguments);
                InliningBasicBlockBuilder.this.begin(resume);
                ValueType rt = node.getTarget().getReturnType();
                return this.onReturn.apply((Value)(rt instanceof VoidType ? InliningBasicBlockBuilder.this.emptyVoid() : InliningBasicBlockBuilder.this.addParam(resume, Slot.result(), rt)));
            }
            return this.onReturn.apply(InliningBasicBlockBuilder.this.call(param.copyValue(node.getTarget()), param.copyValue(node.getReceiver()), param.copyValues(node.getArguments())));
        }

        public BasicBlock visit(Node.Copier copier, Throw node) {
            if (this.catchLabel != null) {
                copier.copyNode(node.getDependency());
                return InliningBasicBlockBuilder.this.goto_(this.catchLabel, InliningBasicBlockBuilder.addArg(this.catchArguments, Slot.thrown(), copier.copyValue(node.getThrownValue())));
            }
            return (BasicBlock)this.delegate.visit((Object)copier, node);
        }

        public BasicBlock visit(Node.Copier param, Invoke node) {
            return (BasicBlock)this.delegate.visit((Object)param, node);
        }

        public BasicBlock visit(Node.Copier param, InvokeNoReturn node) {
            return (BasicBlock)this.delegate.visit((Object)param, node);
        }

        public Value visit(Node.Copier copier, ProgramObjectLiteral literal) {
            Declaration declaration = literal.getProgramObject().getDeclaration();
            if (declaration instanceof DataDeclaration) {
                DataDeclaration dd = (DataDeclaration)declaration;
                return InliningBasicBlockBuilder.this.getLiteralFactory().literalOf((ProgramObject)InliningBasicBlockBuilder.this.ctxt.getOrAddProgramModule((MemberElement)InliningBasicBlockBuilder.this.getRootElement()).declareData(dd));
            }
            if (declaration instanceof FunctionDeclaration) {
                FunctionDeclaration fd = (FunctionDeclaration)declaration;
                return InliningBasicBlockBuilder.this.getLiteralFactory().literalOf((ProgramObject)InliningBasicBlockBuilder.this.ctxt.getOrAddProgramModule((MemberElement)InliningBasicBlockBuilder.this.getRootElement()).declareFunction(fd));
            }
            return literal;
        }
    }
}

