/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.opt;

import org.qbicc.context.CompilationContext;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.DelegatingBasicBlockBuilder;
import org.qbicc.graph.InstanceFieldOf;
import org.qbicc.graph.Value;
import org.qbicc.graph.atomic.AccessModes;
import org.qbicc.graph.atomic.ReadAccessMode;
import org.qbicc.graph.literal.Literal;
import org.qbicc.graph.literal.ObjectLiteral;
import org.qbicc.graph.literal.StaticFieldLiteral;
import org.qbicc.interpreter.Memory;
import org.qbicc.interpreter.VmClass;
import org.qbicc.interpreter.VmObject;
import org.qbicc.type.TypeIdType;
import org.qbicc.type.ValueType;
import org.qbicc.type.definition.element.FieldElement;
import org.qbicc.type.definition.element.StaticFieldElement;
import org.qbicc.type.descriptor.BaseTypeDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;

public class FinalFieldLoadOptimizer
extends DelegatingBasicBlockBuilder {
    final CompilationContext ctxt = this.getContext();

    public FinalFieldLoadOptimizer(BasicBlockBuilder.FactoryContext ctxt, BasicBlockBuilder delegate) {
        super(delegate);
    }

    public Value load(Value pointer, ReadAccessMode accessMode) {
        Value fieldElement2;
        InstanceFieldOf ifo;
        StaticFieldLiteral sfl;
        if (pointer instanceof StaticFieldLiteral && (sfl = (StaticFieldLiteral)pointer).getVariableElement().isReallyFinal()) {
            StaticFieldElement fieldElement2 = sfl.getVariableElement();
            Value contents = fieldElement2.getEnclosingType().load().getInitialValue((FieldElement)fieldElement2);
            if (contents instanceof Literal) {
                return contents;
            }
        } else if (pointer instanceof InstanceFieldOf && (ifo = (InstanceFieldOf)pointer).getVariableElement().isReallyFinal() && (fieldElement2 = ifo.getInstance()) instanceof ObjectLiteral) {
            Object contents;
            ObjectLiteral ol = (ObjectLiteral)fieldElement2;
            fieldElement2 = ifo.getVariableElement();
            VmClass vmClass = ol.getValue().getVmClass();
            int offset = vmClass.indexOf((FieldElement)fieldElement2);
            Memory mem = ol.getValue().getMemory();
            TypeDescriptor desc = fieldElement2.getTypeDescriptor();
            if (desc.equals((TypeDescriptor)BaseTypeDescriptor.Z)) {
                int val = mem.load8((long)offset, (ReadAccessMode)AccessModes.SinglePlain);
                contents = this.ctxt.getLiteralFactory().literalOf(val != 0);
            } else if (desc.equals((TypeDescriptor)BaseTypeDescriptor.B)) {
                contents = this.ctxt.getLiteralFactory().literalOf((byte)mem.load8((long)offset, (ReadAccessMode)AccessModes.SinglePlain));
            } else if (desc.equals((TypeDescriptor)BaseTypeDescriptor.S)) {
                contents = this.ctxt.getLiteralFactory().literalOf((short)mem.load16((long)offset, (ReadAccessMode)AccessModes.SinglePlain));
            } else if (desc.equals((TypeDescriptor)BaseTypeDescriptor.C)) {
                contents = this.ctxt.getLiteralFactory().literalOf((char)mem.load16((long)offset, (ReadAccessMode)AccessModes.SinglePlain));
            } else if (desc.equals((TypeDescriptor)BaseTypeDescriptor.I)) {
                contents = this.ctxt.getLiteralFactory().literalOf(mem.load32((long)offset, (ReadAccessMode)AccessModes.SinglePlain));
            } else if (desc.equals((TypeDescriptor)BaseTypeDescriptor.F)) {
                contents = this.ctxt.getLiteralFactory().literalOf(mem.loadFloat((long)offset, (ReadAccessMode)AccessModes.SinglePlain));
            } else if (desc.equals((TypeDescriptor)BaseTypeDescriptor.J)) {
                contents = this.ctxt.getLiteralFactory().literalOf(mem.load64((long)offset, (ReadAccessMode)AccessModes.SinglePlain));
            } else if (desc.equals((TypeDescriptor)BaseTypeDescriptor.D)) {
                contents = this.ctxt.getLiteralFactory().literalOf(mem.loadDouble((long)offset, (ReadAccessMode)AccessModes.SinglePlain));
            } else if (ifo.getPointeeType() instanceof TypeIdType) {
                ValueType tt = mem.loadType((long)offset, (ReadAccessMode)AccessModes.SinglePlain);
                contents = this.ctxt.getLiteralFactory().literalOfType(tt);
            } else {
                VmObject value = mem.loadRef((long)offset, (ReadAccessMode)AccessModes.SinglePlain);
                contents = value == null ? this.ctxt.getLiteralFactory().zeroInitializerLiteralOfType(fieldElement2.getType()) : this.ctxt.getLiteralFactory().literalOf(value);
            }
            return contents;
        }
        return this.getDelegate().load(pointer, accessMode);
    }
}

