/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.opt;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.qbicc.context.CompilationContext;
import org.qbicc.graph.And;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.BitCast;
import org.qbicc.graph.BlockLabel;
import org.qbicc.graph.Cmp;
import org.qbicc.graph.CmpAndSwap;
import org.qbicc.graph.Comp;
import org.qbicc.graph.DecodeReference;
import org.qbicc.graph.DelegatingBasicBlockBuilder;
import org.qbicc.graph.Extend;
import org.qbicc.graph.ExtractMember;
import org.qbicc.graph.InstanceFieldOf;
import org.qbicc.graph.Neg;
import org.qbicc.graph.NewArray;
import org.qbicc.graph.NewReferenceArray;
import org.qbicc.graph.OffsetPointer;
import org.qbicc.graph.Slot;
import org.qbicc.graph.Truncate;
import org.qbicc.graph.Value;
import org.qbicc.graph.WordCastValue;
import org.qbicc.graph.atomic.ReadAccessMode;
import org.qbicc.graph.literal.ArrayLiteral;
import org.qbicc.graph.literal.BooleanLiteral;
import org.qbicc.graph.literal.FloatLiteral;
import org.qbicc.graph.literal.IntegerLiteral;
import org.qbicc.graph.literal.Literal;
import org.qbicc.graph.literal.LiteralFactory;
import org.qbicc.graph.literal.NullLiteral;
import org.qbicc.graph.literal.StructLiteral;
import org.qbicc.plugin.coreclasses.CoreClasses;
import org.qbicc.type.ArrayType;
import org.qbicc.type.BooleanType;
import org.qbicc.type.FloatType;
import org.qbicc.type.IntegerType;
import org.qbicc.type.NullableType;
import org.qbicc.type.PointerType;
import org.qbicc.type.StructType;
import org.qbicc.type.ValueType;
import org.qbicc.type.WordType;
import org.qbicc.type.definition.element.InstanceFieldElement;

public class LocalOptBasicBlockBuilder
extends DelegatingBasicBlockBuilder {
    private final CompilationContext ctxt = this.getContext();

    public LocalOptBasicBlockBuilder(BasicBlockBuilder.FactoryContext ctxt, BasicBlockBuilder delegate) {
        super(delegate);
    }

    public Value offsetPointer(Value basePointer, Value offset) {
        if (this.isZero(offset)) {
            return basePointer;
        }
        if (basePointer instanceof OffsetPointer) {
            OffsetPointer op = (OffsetPointer)basePointer;
            return this.offsetPointer(op.getBasePointer(), this.add(op.getOffset(), offset));
        }
        return super.offsetPointer(basePointer, offset);
    }

    public Value extractElement(Value array, Value index) {
        Value value = array.extractElement(this.ctxt.getLiteralFactory(), index);
        if (value != null) {
            return value;
        }
        return super.extractElement(array, index);
    }

    public Value extractMember(Value compound, StructType.Member member) {
        Value value = compound.extractMember(this.ctxt.getLiteralFactory(), member);
        if (value != null) {
            return value;
        }
        return super.extractMember(compound, member);
    }

    public Value insertElement(Value array, Value index, Value value) {
        if (array instanceof ArrayLiteral) {
            ArrayLiteral al = (ArrayLiteral)array;
            if (index instanceof IntegerLiteral) {
                IntegerLiteral il = (IntegerLiteral)index;
                if (value instanceof Literal) {
                    Literal lit = (Literal)value;
                    LiteralFactory lf = this.ctxt.getLiteralFactory();
                    Literal[] values = (Literal[])al.getValues().toArray(Literal[]::new);
                    values[il.intValue()] = lit;
                    return lf.literalOf(al.getType(), List.of(values));
                }
            }
        }
        return super.insertElement(array, index, value);
    }

    public Value insertMember(Value compound, StructType.Member member, Value value) {
        if (compound instanceof StructLiteral) {
            StructLiteral cl = (StructLiteral)compound;
            if (value instanceof Literal) {
                Literal lit = (Literal)value;
                LiteralFactory lf = this.ctxt.getLiteralFactory();
                Map values = cl.getValues();
                HashMap<StructType.Member, Literal> copy = new HashMap<StructType.Member, Literal>(values);
                copy.put(member, lit);
                return lf.literalOf(cl.getType(), Map.copyOf(copy));
            }
        }
        return super.insertMember(compound, member, value);
    }

    private Value literalCast(Value value, WordType toType, boolean truncate) {
        if (value instanceof IntegerLiteral) {
            if (toType instanceof IntegerType) {
                return this.ctxt.getLiteralFactory().literalOf((IntegerType)toType, ((IntegerLiteral)value).longValue());
            }
            if (toType instanceof BooleanType) {
                long longValue = ((IntegerLiteral)value).longValue();
                return this.ctxt.getLiteralFactory().literalOf((truncate ? longValue & 1L : longValue) != 0L);
            }
            if (toType instanceof FloatType) {
                return this.ctxt.getLiteralFactory().literalOf((FloatType)toType, (double)((IntegerLiteral)value).longValue());
            }
        } else if (value instanceof FloatLiteral) {
            if (toType instanceof IntegerType) {
                return this.ctxt.getLiteralFactory().literalOf((IntegerType)toType, (long)((FloatLiteral)value).doubleValue());
            }
            if (toType instanceof FloatType) {
                return this.ctxt.getLiteralFactory().literalOf((FloatType)toType, ((FloatLiteral)value).doubleValue());
            }
            if (toType instanceof BooleanType) {
                assert (truncate);
                return this.ctxt.getLiteralFactory().literalOf(((long)((FloatLiteral)value).doubleValue() & 1L) != 0L);
            }
        } else if (value instanceof BooleanLiteral && toType instanceof IntegerType) {
            return this.ctxt.getLiteralFactory().literalOf((IntegerType)toType, ((BooleanLiteral)value).booleanValue() ? 1L : 0L);
        }
        return null;
    }

    public Value load(Value pointer, ReadAccessMode accessMode) {
        if (pointer instanceof InstanceFieldOf) {
            DecodeReference dr;
            Value value;
            Value nra;
            InstanceFieldOf ifo = (InstanceFieldOf)pointer;
            CoreClasses coreClasses = CoreClasses.get((CompilationContext)this.getContext());
            InstanceFieldElement ve = ifo.getVariableElement();
            if (ve == coreClasses.getArrayLengthField()) {
                Value value2 = ifo.getInstance();
                if (value2 instanceof DecodeReference) {
                    DecodeReference dr2 = (DecodeReference)value2;
                    Value value3 = dr2.getInput();
                    if (value3 instanceof NewReferenceArray) {
                        NewReferenceArray nra2 = (NewReferenceArray)value3;
                        return nra2.getSize();
                    }
                    value3 = dr2.getInput();
                    if (value3 instanceof NewArray) {
                        NewArray na = (NewArray)value3;
                        return na.getSize();
                    }
                }
            } else if (ve == coreClasses.getRefArrayDimensionsField()) {
                DecodeReference dr3;
                Value value4;
                Value nra2 = ifo.getInstance();
                if (nra2 instanceof DecodeReference && (value4 = (dr3 = (DecodeReference)nra2).getInput()) instanceof NewReferenceArray) {
                    nra2 = (NewReferenceArray)value4;
                    return nra2.getDimensions();
                }
            } else if (ve == coreClasses.getRefArrayElementTypeIdField() && (nra = ifo.getInstance()) instanceof DecodeReference && (value = (dr = (DecodeReference)nra).getInput()) instanceof NewReferenceArray) {
                nra = (NewReferenceArray)value;
                return nra.getElemTypeId();
            }
        }
        return super.load(pointer, accessMode);
    }

    public Value truncate(Value value, WordType toType) {
        Value result = this.literalCast(value, toType, true);
        if (result != null) {
            return result;
        }
        if (value instanceof Truncate) {
            Truncate trunc = (Truncate)value;
            return this.truncate(trunc.getInput(), toType);
        }
        return super.truncate(value, toType);
    }

    public Value extend(Value value, WordType toType) {
        Value result = this.literalCast(value, toType, false);
        return result != null ? result : super.extend(value, toType);
    }

    public Value complement(Value v) {
        if (v instanceof Comp) {
            Comp c = (Comp)v;
            return c.getInput();
        }
        LiteralFactory lf = this.ctxt.getLiteralFactory();
        if (v instanceof IntegerLiteral) {
            IntegerLiteral il = (IntegerLiteral)v;
            return lf.literalOf(il.getType(), il.longValue() ^ 0xFFFFFFFFFFFFFFFFL);
        }
        if (v.isDefEq((Value)lf.literalOf(true))) {
            return lf.literalOf(false);
        }
        if (v.isDefEq((Value)lf.literalOf(false))) {
            return lf.literalOf(true);
        }
        return this.getDelegate().complement(v);
    }

    public Value isEq(Value v1, Value v2) {
        ExtractMember em;
        ExtractMember em2;
        Value value;
        Cmp cmp;
        if (v1.isDefEq(v2)) {
            return this.ctxt.getLiteralFactory().literalOf(true);
        }
        if (!v1.isNullable() && LocalOptBasicBlockBuilder.isAlwaysNull(v2) || LocalOptBasicBlockBuilder.isAlwaysNull(v1) && !v2.isNullable() || v1.isDefNe(v2)) {
            return this.ctxt.getLiteralFactory().literalOf(false);
        }
        if (v2.isDefEq((Value)this.ctxt.getLiteralFactory().literalOf(false))) {
            return this.complement(v1);
        }
        if (v1.isDefEq((Value)this.ctxt.getLiteralFactory().literalOf(false))) {
            return this.complement(v2);
        }
        Value u1 = v1.unconstrained();
        Value u2 = v2.unconstrained();
        if ((u1 instanceof Extend || u1 instanceof BitCast && v1.getType() instanceof NullableType) && this.isZero(v2)) {
            Value input = ((WordCastValue)v1).getInput();
            return this.isEq(input, (Value)this.ctxt.getLiteralFactory().zeroInitializerLiteralOfType(input.getType()));
        }
        if ((u2 instanceof Extend || u2 instanceof BitCast && v2.getType() instanceof NullableType) && this.isZero(v1)) {
            Value input = ((WordCastValue)v2).getInput();
            return this.isEq((Value)this.ctxt.getLiteralFactory().zeroInitializerLiteralOfType(input.getType()), input);
        }
        if (v1 instanceof Cmp) {
            cmp = (Cmp)v1;
            if (this.isEqualToLiteral(v2, 0)) {
                return this.isEq(cmp.getLeftInput(), cmp.getRightInput());
            }
        }
        if (v2 instanceof Cmp) {
            cmp = (Cmp)v2;
            if (this.isEqualToLiteral(v1, 0)) {
                return this.isEq(cmp.getLeftInput(), cmp.getRightInput());
            }
        }
        if (v1 instanceof ExtractMember && (value = (em2 = (ExtractMember)v1).getStructValue()) instanceof CmpAndSwap) {
            CmpAndSwap cas = (CmpAndSwap)value;
            if (em2.getMember() == cas.getResultValueType() && v2.equals(cas.getExpectedValue())) {
                return this.extractMember((Value)cas, cas.getResultFlagType());
            }
        }
        if (v2 instanceof ExtractMember && (value = (em = (ExtractMember)v2).getStructValue()) instanceof CmpAndSwap) {
            CmpAndSwap cas = (CmpAndSwap)value;
            if (em.getMember() == cas.getResultValueType() && v1.equals(cas.getExpectedValue())) {
                return this.extractMember((Value)cas, cas.getResultFlagType());
            }
        }
        return super.isEq(v1, v2);
    }

    public Value isNe(Value v1, Value v2) {
        Cmp cmp;
        if (v1.isDefEq(v2)) {
            return this.ctxt.getLiteralFactory().literalOf(false);
        }
        if (!v1.isNullable() && LocalOptBasicBlockBuilder.isAlwaysNull(v2) || LocalOptBasicBlockBuilder.isAlwaysNull(v1) && !v2.isNullable() || v1.isDefNe(v2)) {
            return this.ctxt.getLiteralFactory().literalOf(true);
        }
        if (v2.isDefEq((Value)this.ctxt.getLiteralFactory().literalOf(true))) {
            return this.complement(v1);
        }
        if (v1.isDefEq((Value)this.ctxt.getLiteralFactory().literalOf(true))) {
            return this.complement(v2);
        }
        if ((v1 instanceof Extend || v1 instanceof BitCast && v1.getType() instanceof NullableType) && this.isZero(v2)) {
            Value input = ((WordCastValue)v1).getInput();
            if (input.getType() instanceof BooleanType) {
                return input;
            }
            return this.isNe(input, (Value)this.ctxt.getLiteralFactory().zeroInitializerLiteralOfType(input.getType()));
        }
        if ((v2 instanceof Extend || v2 instanceof BitCast && v2.getType() instanceof NullableType) && this.isZero(v1)) {
            Value input = ((WordCastValue)v2).getInput();
            if (input.getType() instanceof BooleanType) {
                return input;
            }
            return this.isNe((Value)this.ctxt.getLiteralFactory().zeroInitializerLiteralOfType(input.getType()), input);
        }
        if (v1 instanceof Cmp) {
            cmp = (Cmp)v1;
            if (this.isEqualToLiteral(v2, 0)) {
                return this.isNe(cmp.getLeftInput(), cmp.getRightInput());
            }
        }
        if (v2 instanceof Cmp) {
            cmp = (Cmp)v2;
            if (this.isEqualToLiteral(v1, 0)) {
                return this.isNe(cmp.getLeftInput(), cmp.getRightInput());
            }
        }
        return super.isNe(v1, v2);
    }

    public Value isLt(Value v1, Value v2) {
        Cmp cmp;
        LiteralFactory lf = this.ctxt.getLiteralFactory();
        if (v1.isDefLt(v2)) {
            return lf.literalOf(true);
        }
        if (v1.isDefGe(v2)) {
            return lf.literalOf(false);
        }
        if (v1 instanceof Cmp) {
            cmp = (Cmp)v1;
            if (this.isEqualToLiteral(v2, 1)) {
                return this.isLe(cmp.getLeftInput(), cmp.getRightInput());
            }
        }
        if (v2 instanceof Cmp) {
            cmp = (Cmp)v2;
            if (this.isEqualToLiteral(v1, -1)) {
                return this.isGe(cmp.getLeftInput(), cmp.getRightInput());
            }
        }
        if (v1 instanceof Cmp) {
            cmp = (Cmp)v1;
            if (this.isEqualToLiteral(v2, 0)) {
                return this.isLt(cmp.getLeftInput(), cmp.getRightInput());
            }
        }
        if (v2 instanceof Cmp) {
            cmp = (Cmp)v2;
            if (this.isEqualToLiteral(v1, 0)) {
                return this.isLt(cmp.getRightInput(), cmp.getLeftInput());
            }
        }
        return super.isLt(v1, v2);
    }

    public Value isGt(Value v1, Value v2) {
        Cmp cmp;
        LiteralFactory lf = this.ctxt.getLiteralFactory();
        if (v1.isDefGt(v2)) {
            return lf.literalOf(true);
        }
        if (v1.isDefLe(v2)) {
            return lf.literalOf(false);
        }
        if (v2 instanceof Cmp) {
            cmp = (Cmp)v2;
            if (this.isEqualToLiteral(v1, 1)) {
                return this.isLe(cmp.getLeftInput(), cmp.getRightInput());
            }
        }
        if (v1 instanceof Cmp) {
            cmp = (Cmp)v1;
            if (this.isEqualToLiteral(v2, -1)) {
                return this.isGe(cmp.getLeftInput(), cmp.getRightInput());
            }
        }
        if (v1 instanceof Cmp) {
            cmp = (Cmp)v1;
            if (this.isEqualToLiteral(v2, 0)) {
                return this.isGt(cmp.getLeftInput(), cmp.getRightInput());
            }
        }
        if (v2 instanceof Cmp) {
            cmp = (Cmp)v2;
            if (this.isEqualToLiteral(v1, 0)) {
                return this.isGt(cmp.getRightInput(), cmp.getLeftInput());
            }
        }
        return super.isGt(v1, v2);
    }

    public Value isLe(Value v1, Value v2) {
        Cmp cmp;
        LiteralFactory lf = this.ctxt.getLiteralFactory();
        if (v1.isDefLe(v2)) {
            return lf.literalOf(true);
        }
        if (v1.isDefGt(v2)) {
            return lf.literalOf(false);
        }
        if (v2 instanceof Cmp) {
            cmp = (Cmp)v2;
            if (this.isEqualToLiteral(v1, 1)) {
                return this.isGt(cmp.getLeftInput(), cmp.getRightInput());
            }
        }
        if (v1 instanceof Cmp) {
            cmp = (Cmp)v1;
            if (this.isEqualToLiteral(v2, -1)) {
                return this.isLt(cmp.getLeftInput(), cmp.getRightInput());
            }
        }
        if (v1 instanceof Cmp) {
            cmp = (Cmp)v1;
            if (this.isEqualToLiteral(v2, 0)) {
                return this.isLe(cmp.getLeftInput(), cmp.getRightInput());
            }
        }
        if (v2 instanceof Cmp) {
            cmp = (Cmp)v2;
            if (this.isEqualToLiteral(v1, 0)) {
                return this.isLe(cmp.getRightInput(), cmp.getLeftInput());
            }
        }
        return super.isLe(v1, v2);
    }

    public Value isGe(Value v1, Value v2) {
        Cmp cmp;
        LiteralFactory lf = this.ctxt.getLiteralFactory();
        if (v1.isDefGe(v2)) {
            return lf.literalOf(true);
        }
        if (v1.isDefLt(v2)) {
            return lf.literalOf(false);
        }
        if (v1 instanceof Cmp) {
            cmp = (Cmp)v1;
            if (this.isEqualToLiteral(v2, -1)) {
                return this.isGe(cmp.getLeftInput(), cmp.getRightInput());
            }
        }
        if (v2 instanceof Cmp) {
            cmp = (Cmp)v2;
            if (this.isEqualToLiteral(v1, -1)) {
                return this.isLt(cmp.getLeftInput(), cmp.getRightInput());
            }
        }
        if (v1 instanceof Cmp) {
            cmp = (Cmp)v1;
            if (this.isEqualToLiteral(v2, 0)) {
                return this.isGe(cmp.getLeftInput(), cmp.getRightInput());
            }
        }
        if (v2 instanceof Cmp) {
            cmp = (Cmp)v2;
            if (this.isEqualToLiteral(v1, 0)) {
                return this.isGe(cmp.getRightInput(), cmp.getLeftInput());
            }
        }
        return super.isGe(v1, v2);
    }

    public Value and(Value v1, Value v2) {
        LiteralFactory lf = this.ctxt.getLiteralFactory();
        if (v1.getType() instanceof BooleanType) {
            BooleanLiteral trueLit = lf.literalOf(true);
            BooleanLiteral falseLit = lf.literalOf(false);
            if (v1.isDefEq((Value)trueLit) || v1.isDefNe((Value)falseLit)) {
                return v2;
            }
            if (v2.isDefEq((Value)trueLit) || v2.isDefNe((Value)falseLit)) {
                return v1;
            }
            if (v1.isDefEq((Value)falseLit) || v1.isDefNe((Value)trueLit) || v2.isDefEq((Value)falseLit) || v2.isDefNe((Value)trueLit)) {
                return falseLit;
            }
            if (v1 instanceof Comp) {
                Comp c1 = (Comp)v1;
                if (v2 instanceof Comp) {
                    Comp c2 = (Comp)v2;
                    return this.complement(this.or(c1.getInput(), c2.getInput()));
                }
            }
        } else {
            ValueType trueLit = v1.getType();
            if (trueLit instanceof IntegerType) {
                IntegerLiteral zero;
                IntegerType it = (IntegerType)trueLit;
                if (v1 instanceof IntegerLiteral) {
                    IntegerLiteral l1 = (IntegerLiteral)v1;
                    if (v2 instanceof IntegerLiteral) {
                        IntegerLiteral l2 = (IntegerLiteral)v2;
                        return lf.literalOf(it, l1.longValue() & l2.longValue());
                    }
                }
                if (v1.isDefEq((Value)(zero = lf.literalOf(it, 0L))) || v2.isDefEq((Value)zero)) {
                    return zero;
                }
                IntegerLiteral allOnes = lf.literalOf(it, -1L);
                if (v1.isDefEq((Value)allOnes)) {
                    return v2;
                }
                if (v2.isDefEq((Value)allOnes)) {
                    return v1;
                }
            }
        }
        return this.getDelegate().and(v1, v2);
    }

    public Value or(Value v1, Value v2) {
        LiteralFactory lf = this.ctxt.getLiteralFactory();
        if (v1.getType() instanceof BooleanType) {
            trueLit = lf.literalOf(true);
            BooleanLiteral falseLit = lf.literalOf(false);
            if (v1.isDefNe((Value)trueLit) || v1.isDefEq((Value)falseLit)) {
                return v2;
            }
            if (v2.isDefNe((Value)trueLit) || v2.isDefEq((Value)falseLit)) {
                return v1;
            }
            if (v1.isDefNe((Value)falseLit) || v1.isDefEq((Value)trueLit) || v2.isDefNe((Value)falseLit) || v2.isDefEq((Value)trueLit)) {
                return trueLit;
            }
            if (v1 instanceof Comp) {
                Comp c1 = (Comp)v1;
                if (v2 instanceof Comp) {
                    Comp c2 = (Comp)v2;
                    return this.complement(this.and(c1.getInput(), c2.getInput()));
                }
            }
        } else {
            trueLit = v1.getType();
            if (trueLit instanceof IntegerType) {
                IntegerLiteral allOnes;
                IntegerType it = (IntegerType)trueLit;
                if (v1 instanceof IntegerLiteral) {
                    IntegerLiteral l1 = (IntegerLiteral)v1;
                    if (v2 instanceof IntegerLiteral) {
                        IntegerLiteral l2 = (IntegerLiteral)v2;
                        return lf.literalOf(it, l1.longValue() | l2.longValue());
                    }
                }
                if (v1.isDefEq((Value)(allOnes = lf.literalOf(it, -1L))) || v2.isDefEq((Value)allOnes)) {
                    return allOnes;
                }
                IntegerLiteral zero = lf.literalOf(it, 0L);
                if (v1.isDefEq((Value)zero)) {
                    return v2;
                }
                if (v2.isDefEq((Value)zero)) {
                    return v1;
                }
            }
        }
        if (v1 instanceof And) {
            And a1 = (And)v1;
            if (v2 instanceof And) {
                And a2 = (And)v2;
                Value a1Left = a1.getLeftInput();
                Value a2Left = a2.getLeftInput();
                Value a1Right = a1.getRightInput();
                Value a2Right = a2.getRightInput();
                if (a1Left.isDefEq(a2Left) || a2Left.isDefEq(a1Left)) {
                    return this.and(a1Left, this.or(a1Right, a2Right));
                }
                if (a1Left.isDefEq(a2Right) || a2Right.isDefEq(a1Left)) {
                    return this.and(a1Left, this.or(a1Right, a2Left));
                }
                if (a1Right.isDefEq(a2Left) || a2Left.isDefEq(a1Right)) {
                    return this.and(a1Right, this.or(a1Left, a2Right));
                }
                if (a1Right.isDefEq(a2Right) || a2Right.isDefEq(a1Right)) {
                    return this.and(a1Right, this.or(a1Left, a2Left));
                }
            }
        }
        return this.getDelegate().or(v1, v2);
    }

    public Value xor(Value v1, Value v2) {
        IntegerLiteral allOnes;
        if (v1.getType() instanceof BooleanType) {
            return this.isNe(v1, v2);
        }
        LiteralFactory lf = this.ctxt.getLiteralFactory();
        IntegerType it = (IntegerType)v1.getType();
        if (v1 instanceof IntegerLiteral) {
            IntegerLiteral l1 = (IntegerLiteral)v1;
            if (v2 instanceof IntegerLiteral) {
                IntegerLiteral l2 = (IntegerLiteral)v2;
                return lf.literalOf(it, l1.longValue() ^ l2.longValue());
            }
        }
        if (v1.isDefEq((Value)(allOnes = lf.literalOf(it, -1L)))) {
            return this.complement(v2);
        }
        if (v2.isDefEq((Value)allOnes)) {
            return this.complement(v1);
        }
        IntegerLiteral zero = lf.literalOf(it, 0L);
        if (v1.isDefEq((Value)zero)) {
            return v2;
        }
        if (v2.isDefEq((Value)zero)) {
            return v1;
        }
        return this.getDelegate().xor(v1, v2);
    }

    public Value bitCast(Value input, WordType toType) {
        if (input.getType().equals((ValueType)toType)) {
            return input;
        }
        if (input.isDefEq((Value)this.ctxt.getLiteralFactory().zeroInitializerLiteralOfType(input.getType()))) {
            return this.ctxt.getLiteralFactory().zeroInitializerLiteralOfType((ValueType)toType);
        }
        if (input instanceof BitCast) {
            BitCast inputNode = (BitCast)input;
            if (inputNode.getInput().getType().equals((ValueType)toType)) {
                return inputNode.getInput();
            }
            return this.bitCast(inputNode.getInput(), toType);
        }
        ValueType valueType = input.getType();
        if (valueType instanceof PointerType) {
            PointerType inPtrType = (PointerType)valueType;
            if (toType instanceof PointerType) {
                IntegerLiteral z;
                Value outVal;
                PointerType outPtrType = (PointerType)toType;
                if (inPtrType.getPointeeType() instanceof StructType && (outVal = this.addressOfFirst(this.offsetPointer(input, (Value)(z = this.ctxt.getLiteralFactory().literalOf(0))), outPtrType.getPointeeType())) != null) {
                    return outVal;
                }
            }
        }
        return super.bitCast(input, toType);
    }

    private Value addressOfFirst(Value input, ValueType outputType) {
        StructType st;
        ValueType valueType = input.getPointeeType();
        if (valueType instanceof StructType && (st = (StructType)valueType).getMemberCount() > 0) {
            memberZero = st.getMember(0);
            if (memberZero.getOffset() == 0) {
                Value nextHandle = this.memberOf(input, (StructType.Member)memberZero);
                if (outputType.equals(memberZero.getType())) {
                    return nextHandle;
                }
                return this.addressOfFirst(nextHandle, outputType);
            }
        } else {
            ArrayType at;
            memberZero = input.getPointeeType();
            if (memberZero instanceof ArrayType && (at = (ArrayType)memberZero).getElementCount() > 0L) {
                Value nextHandle = this.elementOf(input, (Value)this.ctxt.getLiteralFactory().literalOf(0));
                if (outputType.equals(at.getElementType())) {
                    return nextHandle;
                }
                return this.addressOfFirst(nextHandle, outputType);
            }
        }
        return null;
    }

    public Value select(Value condition, Value trueValue, Value falseValue) {
        if (condition instanceof Comp) {
            Comp comp = (Comp)condition;
            return this.select(comp.getInput(), falseValue, trueValue);
        }
        if (this.isEqualToLiteral(trueValue, 1) && this.isEqualToLiteral(falseValue, 0)) {
            return this.extend(condition, (WordType)trueValue.getType());
        }
        if (this.isEqualToLiteral(trueValue, 0) && this.isEqualToLiteral(falseValue, 1)) {
            return this.extend(this.xor(condition, (Value)this.ctxt.getLiteralFactory().literalOf(true)), (WordType)trueValue.getType());
        }
        BooleanLiteral trueLit = this.ctxt.getLiteralFactory().literalOf(true);
        BooleanLiteral falseLit = this.ctxt.getLiteralFactory().literalOf(false);
        if (condition.isDefEq((Value)trueLit) || condition.isDefNe((Value)falseLit)) {
            return trueValue;
        }
        if (condition.isDefEq((Value)falseLit) || condition.isDefNe((Value)trueLit)) {
            return falseValue;
        }
        if (trueValue.equals(falseValue)) {
            return trueValue;
        }
        if (trueValue.isDefEq((Value)trueLit) && falseValue.isDefEq((Value)falseLit)) {
            return condition;
        }
        if (trueValue.isDefEq((Value)falseLit) && falseValue.isDefEq((Value)trueLit)) {
            return this.complement(condition);
        }
        return this.getDelegate().select(condition, trueValue, falseValue);
    }

    public BasicBlock if_(Value condition, BlockLabel trueTarget, BlockLabel falseTarget, Map<Slot, Value> targetArguments) {
        if (condition instanceof Comp) {
            Comp comp = (Comp)condition;
            return this.if_(comp.getInput(), falseTarget, trueTarget, targetArguments);
        }
        BooleanLiteral trueLit = this.ctxt.getLiteralFactory().literalOf(true);
        BooleanLiteral falseLit = this.ctxt.getLiteralFactory().literalOf(false);
        if (condition.isDefEq((Value)trueLit) || condition.isDefNe((Value)falseLit)) {
            return this.goto_(trueTarget, targetArguments);
        }
        if (condition.isDefEq((Value)falseLit) || condition.isDefNe((Value)trueLit)) {
            return this.goto_(falseTarget, targetArguments);
        }
        if (trueTarget == falseTarget) {
            return this.goto_(trueTarget, targetArguments);
        }
        return this.getDelegate().if_(condition, trueTarget, falseTarget, targetArguments);
    }

    public BasicBlock switch_(Value value, int[] checkValues, BlockLabel[] targets, BlockLabel defaultTarget, Map<Slot, Value> targetArguments) {
        ValueType valueType = value.getType();
        if (valueType instanceof IntegerType) {
            IntegerType it = (IntegerType)valueType;
            LiteralFactory lf = this.ctxt.getLiteralFactory();
            boolean defaultMatches = true;
            for (int i = 0; i < checkValues.length; ++i) {
                IntegerLiteral checkValueLit = lf.literalOf(it, (long)checkValues[i]);
                if (value.isDefEq((Value)checkValueLit)) {
                    return this.goto_(targets[i], targetArguments);
                }
                if (!defaultMatches || value.isDefNe((Value)checkValueLit)) continue;
                defaultMatches = false;
            }
            if (defaultMatches) {
                return this.goto_(defaultTarget, targetArguments);
            }
        }
        return this.getDelegate().switch_(value, checkValues, targets, defaultTarget, targetArguments);
    }

    public Value add(Value v1, Value v2) {
        ValueType valueType = v1.getType();
        if (valueType instanceof IntegerType) {
            IntegerType it = (IntegerType)valueType;
            assert (v2.getType() instanceof IntegerType);
            if (this.isZero(v1)) {
                return v2;
            }
            if (this.isZero(v2)) {
                return v1;
            }
            if (v1 instanceof Neg) {
                Neg n1 = (Neg)v1;
                return this.sub(v2, n1.getInput());
            }
            if (v2 instanceof Neg) {
                Neg n2 = (Neg)v2;
                return this.sub(v1, n2.getInput());
            }
            if (v1 instanceof IntegerLiteral) {
                IntegerLiteral i1 = (IntegerLiteral)v1;
                if (v2 instanceof IntegerLiteral) {
                    IntegerLiteral i2 = (IntegerLiteral)v2;
                    return this.getLiteralFactory().literalOf(it, i1.longValue() + i2.longValue());
                }
            }
        }
        return super.add(v1, v2);
    }

    public Value sub(Value v1, Value v2) {
        ValueType valueType = v1.getType();
        if (valueType instanceof IntegerType) {
            IntegerType it = (IntegerType)valueType;
            assert (v2.getType() instanceof IntegerType);
            if (this.isZero(v1)) {
                return this.negate(v2);
            }
            if (this.isZero(v2)) {
                return v1;
            }
            if (v2 instanceof Neg) {
                Neg n2 = (Neg)v2;
                return this.add(v1, n2.getInput());
            }
            if (v1.isDefEq(v2) || v2.isDefEq(v1)) {
                return this.getLiteralFactory().literalOf(it, 0L);
            }
            if (v1 instanceof IntegerLiteral) {
                IntegerLiteral i1 = (IntegerLiteral)v1;
                if (v2 instanceof IntegerLiteral) {
                    IntegerLiteral i2 = (IntegerLiteral)v2;
                    return this.getLiteralFactory().literalOf(it, i1.longValue() - i2.longValue());
                }
            }
        }
        return super.sub(v1, v2);
    }

    public Value negate(Value v) {
        if (v instanceof Neg) {
            Neg neg = (Neg)v;
            return neg.getInput();
        }
        if (v instanceof Cmp) {
            Cmp cmp = (Cmp)v;
            return this.cmp(cmp.getRightInput(), cmp.getLeftInput());
        }
        return super.negate(v);
    }

    private static boolean isAlwaysNull(Value value) {
        return value instanceof NullLiteral;
    }

    private boolean isZero(Value value) {
        return value.isDefEq((Value)this.ctxt.getLiteralFactory().zeroInitializerLiteralOfType(value.getType()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isEqualToLiteral(Value value, int literal) {
        ValueType valueType = value.getType();
        if (!(valueType instanceof IntegerType)) return false;
        IntegerType it = (IntegerType)valueType;
        if (!value.isDefEq((Value)this.ctxt.getLiteralFactory().literalOf(it, (long)literal))) return false;
        return true;
    }
}

