/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.opt.ea;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.graph.Action;
import org.qbicc.graph.ActionVisitor;
import org.qbicc.graph.Add;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.BitCast;
import org.qbicc.graph.BlockEntry;
import org.qbicc.graph.BlockParameter;
import org.qbicc.graph.Call;
import org.qbicc.graph.CheckCast;
import org.qbicc.graph.DecodeReference;
import org.qbicc.graph.Extend;
import org.qbicc.graph.Goto;
import org.qbicc.graph.If;
import org.qbicc.graph.InstanceFieldOf;
import org.qbicc.graph.Invoke;
import org.qbicc.graph.IsEq;
import org.qbicc.graph.IsGe;
import org.qbicc.graph.IsGt;
import org.qbicc.graph.IsLe;
import org.qbicc.graph.IsLt;
import org.qbicc.graph.IsNe;
import org.qbicc.graph.Load;
import org.qbicc.graph.New;
import org.qbicc.graph.Node;
import org.qbicc.graph.NodeVisitor;
import org.qbicc.graph.NotNull;
import org.qbicc.graph.OrderedNode;
import org.qbicc.graph.Return;
import org.qbicc.graph.Select;
import org.qbicc.graph.Slot;
import org.qbicc.graph.Store;
import org.qbicc.graph.Sub;
import org.qbicc.graph.Terminator;
import org.qbicc.graph.TerminatorVisitor;
import org.qbicc.graph.Throw;
import org.qbicc.graph.Truncate;
import org.qbicc.graph.Value;
import org.qbicc.graph.ValueVisitor;
import org.qbicc.graph.literal.Literal;
import org.qbicc.graph.literal.StaticFieldLiteral;
import org.qbicc.plugin.opt.ea.ConnectionGraph;
import org.qbicc.plugin.opt.ea.EscapeAnalysisState;
import org.qbicc.plugin.opt.ea.EscapeValue;
import org.qbicc.type.BooleanType;
import org.qbicc.type.ClassObjectType;
import org.qbicc.type.NumericType;
import org.qbicc.type.ValueType;
import org.qbicc.type.VoidType;
import org.qbicc.type.definition.MethodBody;
import org.qbicc.type.definition.element.BasicElement;
import org.qbicc.type.definition.element.ElementVisitor;
import org.qbicc.type.definition.element.ExecutableElement;

public class EscapeAnalysisIntraMethodAnalysis
implements ElementVisitor<CompilationContext, Void> {
    public Void visitUnknown(CompilationContext param, BasicElement basicElement) {
        ExecutableElement element;
        if (basicElement instanceof ExecutableElement && (element = (ExecutableElement)basicElement).hasMethodBody()) {
            MethodBody methodBody = element.getMethodBody();
            this.process(element, methodBody, param);
        }
        return null;
    }

    private void process(ExecutableElement element, MethodBody methodBody, CompilationContext ctxt) {
        ConnectionGraph connectionGraph = new ConnectionGraph(element);
        EscapeAnalysisState escapeAnalysisState = EscapeAnalysisState.get(ctxt);
        escapeAnalysisState.addMethod(element, connectionGraph);
        AnalysisContext analysisContext = new AnalysisContext(escapeAnalysisState, connectionGraph, ctxt.getBootstrapClassContext());
        analysisContext.process(element, methodBody.getEntryBlock());
    }

    static final class AnalysisContext {
        final Set<Node> visited = new HashSet<Node>();
        final Map<Node, Boolean> supported = new HashMap<Node, Boolean>();
        final Set<Class<?>> knownTypes = new HashSet();
        final EscapeAnalysisState escapeAnalysisState;
        final ConnectionGraph connectionGraph;
        final ClassContext bootstrapClassContext;

        AnalysisContext(EscapeAnalysisState escapeAnalysisState, ConnectionGraph connectionGraph, ClassContext bootstrapClassContext) {
            this.escapeAnalysisState = escapeAnalysisState;
            this.connectionGraph = connectionGraph;
            this.bootstrapClassContext = bootstrapClassContext;
            this.knownTypes.add(BlockEntry.class);
            this.knownTypes.add(BlockParameter.class);
        }

        void addKnownType(Class<?> type) {
            this.knownTypes.add(type);
        }

        void setSupported(Node node, boolean value) {
            this.supported.put(node, value);
        }

        boolean switchToUnsupported(Node node) {
            return this.supported.replace(node, true, false);
        }

        boolean addUnsupported(Node node) {
            return this.supported.putIfAbsent(node, false) == null;
        }

        private boolean isSubtypeOfClass(String name, ClassObjectType type) {
            return type.isSubtypeOf(this.bootstrapClassContext.findDefinedType(name).load().getObjectType());
        }

        public void process(ExecutableElement element, BasicBlock entryBlock) {
            entryBlock.getTerminator().accept((TerminatorVisitor)new AnalysisVisitor(element), (Object)this);
            this.connectionGraph.resolveReturnedPhiValues();
            List<New> notGlobalEscapeNewNodes = this.supported.entrySet().stream().filter(e -> e.getKey() instanceof New && (Boolean)e.getValue() != false).filter(e -> this.connectionGraph.getEscapeValue((Node)e.getKey()).notGlobalEscape()).map(e -> (New)e.getKey()).toList();
            this.connectionGraph.validateNewNodes(notGlobalEscapeNewNodes);
        }
    }

    static final class AnalysisVisitor
    implements NodeVisitor<AnalysisContext, Void, Void, Void> {
        private final ExecutableElement element;

        public AnalysisVisitor(ExecutableElement element) {
            this.element = element;
        }

        public Void visit(AnalysisContext param, New node) {
            if (this.visitKnown(param, (Node)node)) {
                param.connectionGraph.setNewEscapeValue(node, this.defaultEscapeValue(param, node.getClassObjectType()));
            }
            return null;
        }

        public Void visit(AnalysisContext param, Store node) {
            if (this.visitKnown(param, (Node)node)) {
                InstanceFieldOf fieldOf;
                Value value;
                Value pointer = node.getPointer();
                Value value2 = node.getValue();
                if (pointer instanceof InstanceFieldOf && (value = (fieldOf = (InstanceFieldOf)pointer).getInstance()) instanceof DecodeReference) {
                    BlockParameter bp;
                    DecodeReference dr = (DecodeReference)value;
                    Value ref = dr.getInput();
                    if (value2 instanceof New && ref instanceof BlockParameter && (bp = (BlockParameter)ref).isEntryParameter()) {
                        if (bp.getSlot() == Slot.this_()) {
                            param.connectionGraph.setArgEscape((Node)value2);
                        } else {
                            param.connectionGraph.addFieldEdge(bp, fieldOf);
                            param.connectionGraph.addPointsToEdge((Node)fieldOf, value2);
                        }
                    }
                } else if (pointer instanceof StaticFieldLiteral) {
                    param.connectionGraph.setGlobalEscape((Node)pointer);
                    if (value2 instanceof NotNull) {
                        NotNull nn = (NotNull)value2;
                        param.connectionGraph.addPointsToEdge((Node)pointer, nn.getInput());
                    } else {
                        param.connectionGraph.addPointsToEdge((Node)pointer, value2);
                    }
                }
            }
            return null;
        }

        public Void visit(AnalysisContext param, Call node) {
            if (this.visitKnown(param, (Node)node)) {
                param.escapeAnalysisState.addCall(this.element, node);
            }
            return null;
        }

        public Void visit(AnalysisContext param, Return node) {
            block2: {
                Invoke.ReturnValue ret;
                Value value;
                block4: {
                    Call call;
                    block3: {
                        if (!this.visitKnown(param, (Node)node)) break block2;
                        value = node.getReturnValue();
                        if (!(value instanceof New) && !(value instanceof BlockParameter)) break block3;
                        param.connectionGraph.setArgEscape((Node)value);
                        break block2;
                    }
                    if (!(value instanceof Call) || AnalysisVisitor.isPrimitive((call = (Call)value).getType())) break block4;
                    for (Value argument : call.getArguments()) {
                        param.connectionGraph.setArgEscape((Node)argument);
                    }
                    break block2;
                }
                if (!(value instanceof Invoke.ReturnValue) || AnalysisVisitor.isPrimitive((ret = (Invoke.ReturnValue)value).getType())) break block2;
                for (Value argument : ret.getInvoke().getArguments()) {
                    param.connectionGraph.setArgEscape((Node)argument);
                }
            }
            return null;
        }

        public Void visit(AnalysisContext param, Throw node) {
            Value value;
            if (this.visitKnown(param, (Node)node) && (value = node.getThrownValue()) instanceof New) {
                param.connectionGraph.setArgEscape((Node)value);
            }
            return null;
        }

        public Void visit(AnalysisContext param, CheckCast node) {
            if (this.visitKnown(param, (Node)node)) {
                param.connectionGraph.addPointsToEdge((Node)node, node.getInput());
            }
            return null;
        }

        public Void visit(AnalysisContext param, BitCast node) {
            if (this.visitKnown(param, (Node)node)) {
                param.connectionGraph.addPointsToEdge((Node)node, node.getInput());
            }
            return null;
        }

        public Void visit(AnalysisContext param, BlockParameter node) {
            boolean known = this.visitKnown(param, (Node)node);
            if (known) {
                if (node.isEntryParameter() && Slot.this_() != node.getSlot()) {
                    param.connectionGraph.addParameter(node);
                    param.connectionGraph.setArgEscape((Node)node);
                } else {
                    param.connectionGraph.setNoEscape((Node)node);
                }
            }
            return null;
        }

        public Void visit(AnalysisContext param, Load node) {
            this.visitKnown(param, (Node)node);
            return null;
        }

        public Void visit(AnalysisContext param, IsEq node) {
            this.visitKnown(param, (Node)node);
            return null;
        }

        public Void visit(AnalysisContext param, IsGe node) {
            this.visitKnown(param, (Node)node);
            return null;
        }

        public Void visit(AnalysisContext param, IsGt node) {
            this.visitKnown(param, (Node)node);
            return null;
        }

        public Void visit(AnalysisContext param, IsLe node) {
            this.visitKnown(param, (Node)node);
            return null;
        }

        public Void visit(AnalysisContext param, IsLt node) {
            this.visitKnown(param, (Node)node);
            return null;
        }

        public Void visit(AnalysisContext param, IsNe node) {
            this.visitKnown(param, (Node)node);
            return null;
        }

        public Void visit(AnalysisContext param, InstanceFieldOf node) {
            this.visitKnown(param, (Node)node);
            return null;
        }

        public Void visit(AnalysisContext param, Truncate node) {
            this.visitKnown(param, (Node)node);
            return null;
        }

        public Void visit(AnalysisContext param, Extend node) {
            this.visitKnown(param, (Node)node);
            return null;
        }

        public Void visit(AnalysisContext param, Add node) {
            this.visitKnown(param, (Node)node);
            return null;
        }

        public Void visit(AnalysisContext param, Sub node) {
            this.visitKnown(param, (Node)node);
            return null;
        }

        public Void visit(AnalysisContext param, Select node) {
            this.visitKnown(param, (Node)node);
            return null;
        }

        public Void visit(AnalysisContext param, If node) {
            if (this.visitKnown(param, (Node)node)) {
                node.getTrueBranch().getTerminator().accept((TerminatorVisitor)this, (Object)param);
                node.getFalseBranch().getTerminator().accept((TerminatorVisitor)this, (Object)param);
            }
            return null;
        }

        public Void visit(AnalysisContext param, Goto node) {
            if (this.visitKnown(param, (Node)node)) {
                node.getResumeTarget().getTerminator().accept((TerminatorVisitor)this, (Object)param);
            }
            return null;
        }

        private EscapeValue defaultEscapeValue(AnalysisContext param, ClassObjectType type) {
            if (param.isSubtypeOfClass("java/lang/Thread", type) || param.isSubtypeOfClass("java/lang/ThreadGroup", type)) {
                return EscapeValue.GLOBAL_ESCAPE;
            }
            return EscapeValue.NO_ESCAPE;
        }

        public Void visitUnknown(AnalysisContext param, Action node) {
            this.visitUnknown(param, (Node)node);
            return null;
        }

        public Void visitUnknown(AnalysisContext param, Terminator node) {
            if (this.visitUnknown(param, (Node)node)) {
                int cnt = node.getSuccessorCount();
                for (int i = 0; i < cnt; ++i) {
                    node.getSuccessor(i).getTerminator().accept((TerminatorVisitor)this, (Object)param);
                }
            }
            return null;
        }

        public Void visitUnknown(AnalysisContext param, Value node) {
            this.visitUnknown(param, (Node)node);
            return null;
        }

        boolean visitKnown(AnalysisContext param, Node node) {
            param.addKnownType(node.getClass());
            return this.visitUnknown(param, node);
        }

        boolean visitUnknown(AnalysisContext param, Node node) {
            if (param.visited.add(node)) {
                boolean isNodeSupported = this.isSupported(param, node);
                int cnt = node.getValueDependencyCount();
                for (int i = 0; i < cnt; ++i) {
                    Value dependency = node.getValueDependency(i);
                    this.checkSupport(isNodeSupported, (Node)dependency, param);
                    dependency.accept((ValueVisitor)this, (Object)param);
                }
                if (node instanceof OrderedNode) {
                    Node dependency = ((OrderedNode)node).getDependency();
                    this.checkSupport(isNodeSupported, dependency, param);
                    if (dependency instanceof Action) {
                        ((Action)dependency).accept((ActionVisitor)this, (Object)param);
                    } else if (dependency instanceof Value) {
                        ((Value)dependency).accept((ValueVisitor)this, (Object)param);
                    } else if (dependency instanceof Terminator) {
                        ((Terminator)dependency).accept((TerminatorVisitor)this, (Object)param);
                    }
                }
                return true;
            }
            return false;
        }

        private void checkSupport(boolean isSupported, Node node, AnalysisContext param) {
            if (!isSupported) {
                if (Boolean.TRUE.equals(param.supported.get(node))) {
                    param.switchToUnsupported(node);
                    param.visited.remove(node);
                } else {
                    param.addUnsupported(node);
                }
            }
        }

        private boolean isSupported(AnalysisContext param, Node node) {
            if (node instanceof Literal) {
                return true;
            }
            Boolean prev = param.supported.get(node);
            if (prev == null) {
                boolean supported = param.knownTypes.contains(node.getClass());
                param.setSupported(node, supported);
                return supported;
            }
            return prev;
        }

        private static boolean isPrimitive(ValueType type) {
            return type instanceof VoidType || type instanceof BooleanType || type instanceof NumericType;
        }
    }
}

