/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.opt;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.collections.api.factory.Maps;
import org.qbicc.context.CompilationContext;
import org.qbicc.graph.Add;
import org.qbicc.graph.And;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.BitCast;
import org.qbicc.graph.BlockEarlyTermination;
import org.qbicc.graph.BlockEntry;
import org.qbicc.graph.BlockLabel;
import org.qbicc.graph.BlockParameter;
import org.qbicc.graph.Call;
import org.qbicc.graph.CallNoReturn;
import org.qbicc.graph.CallNoSideEffects;
import org.qbicc.graph.Convert;
import org.qbicc.graph.DecodeReference;
import org.qbicc.graph.DelegatingBasicBlockBuilder;
import org.qbicc.graph.Div;
import org.qbicc.graph.Extend;
import org.qbicc.graph.If;
import org.qbicc.graph.Invoke;
import org.qbicc.graph.InvokeNoReturn;
import org.qbicc.graph.IsEq;
import org.qbicc.graph.IsGe;
import org.qbicc.graph.IsGt;
import org.qbicc.graph.IsLe;
import org.qbicc.graph.IsLt;
import org.qbicc.graph.IsNe;
import org.qbicc.graph.Mod;
import org.qbicc.graph.Multiply;
import org.qbicc.graph.Neg;
import org.qbicc.graph.Node;
import org.qbicc.graph.NodeVisitor;
import org.qbicc.graph.Or;
import org.qbicc.graph.Return;
import org.qbicc.graph.Rol;
import org.qbicc.graph.Ror;
import org.qbicc.graph.Shl;
import org.qbicc.graph.Shr;
import org.qbicc.graph.Slot;
import org.qbicc.graph.Sub;
import org.qbicc.graph.Switch;
import org.qbicc.graph.TailCall;
import org.qbicc.graph.Throw;
import org.qbicc.graph.Truncate;
import org.qbicc.graph.Value;
import org.qbicc.graph.Xor;
import org.qbicc.graph.literal.ExecutableLiteral;
import org.qbicc.object.DataDeclaration;
import org.qbicc.object.Declaration;
import org.qbicc.object.FunctionDeclaration;
import org.qbicc.object.ProgramModule;
import org.qbicc.type.definition.MethodBody;
import org.qbicc.type.definition.element.ExecutableElement;

public class InliningBasicBlockBuilder
extends DelegatingBasicBlockBuilder {
    private final CompilationContext ctxt = this.getContext();
    private final float costThreshold = 80.0f;
    private float cost;

    public InliningBasicBlockBuilder(BasicBlockBuilder.FactoryContext ctxt, BasicBlockBuilder delegate) {
        super(delegate);
    }

    public Value call(Value targetPtr, Value receiver, List<Value> arguments) {
        BlockLabel resumeLabel;
        BasicBlock inlined;
        ExecutableElement toInline = this.getInlinedElement(targetPtr);
        if (toInline != null && (inlined = this.doInline(receiver, toInline, arguments, null, arg_0 -> this.lambda$call$0(resumeLabel = new BlockLabel(), arg_0), Map.of())) != null) {
            this.begin(resumeLabel);
            return this.addParam(resumeLabel, Slot.result(), toInline.getType().getReturnType());
        }
        return super.call(targetPtr, receiver, arguments);
    }

    public Value callNoSideEffects(Value targetPtr, Value receiver, List<Value> arguments) {
        BlockLabel resumeLabel;
        BasicBlock inlined;
        ExecutableElement toInline = this.getInlinedElement(targetPtr);
        if (toInline != null && (inlined = this.doInline(receiver, toInline, arguments, null, arg_0 -> this.lambda$callNoSideEffects$1(resumeLabel = new BlockLabel(), arg_0), Map.of())) != null) {
            this.begin(resumeLabel);
            return this.addParam(resumeLabel, Slot.result(), toInline.getType().getReturnType());
        }
        return super.callNoSideEffects(targetPtr, receiver, arguments);
    }

    public BasicBlock callNoReturn(Value targetPtr, Value receiver, List<Value> arguments) {
        BasicBlock inlined;
        ExecutableElement toInline = this.getInlinedElement(targetPtr);
        if (toInline != null && (inlined = this.doInline(receiver, toInline, arguments, null, val -> {
            this.ctxt.error(this.getLocation(), "Invalid return from noreturn method", new Object[0]);
            throw new BlockEarlyTermination(this.unreachable());
        }, Map.of())) != null) {
            return inlined;
        }
        return super.callNoReturn(targetPtr, receiver, arguments);
    }

    public BasicBlock invokeNoReturn(Value targetPtr, Value receiver, List<Value> arguments, BlockLabel catchLabel, Map<Slot, Value> targetArguments) {
        BasicBlock inlined;
        ExecutableElement toInline = this.getInlinedElement(targetPtr);
        if (toInline != null && (inlined = this.doInline(receiver, toInline, arguments, catchLabel, val -> {
            this.ctxt.error(this.getLocation(), "Invalid return from noreturn method", new Object[0]);
            throw new BlockEarlyTermination(this.unreachable());
        }, targetArguments)) != null) {
            return inlined;
        }
        return super.invokeNoReturn(targetPtr, receiver, arguments, catchLabel, targetArguments);
    }

    public BasicBlock tailCall(Value targetPtr, Value receiver, List<Value> arguments) {
        BasicBlock inlined;
        ExecutableElement toInline = this.getInlinedElement(targetPtr);
        if (toInline != null && (inlined = this.doInline(receiver, toInline, arguments, null, arg_0 -> ((InliningBasicBlockBuilder)this).return_(arg_0), Map.of())) != null) {
            return inlined;
        }
        return super.tailCall(targetPtr, receiver, arguments);
    }

    public Value invoke(Value targetPtr, Value receiver, List<Value> arguments, BlockLabel catchLabel, BlockLabel resumeLabel, Map<Slot, Value> targetArguments) {
        BasicBlock inlined;
        ExecutableElement toInline = this.getInlinedElement(targetPtr);
        if (toInline != null && (inlined = this.doInline(receiver, toInline, arguments, catchLabel, val -> this.goto_(resumeLabel, InliningBasicBlockBuilder.addArg(targetArguments, Slot.result(), val)), targetArguments)) != null) {
            return this.addParam(resumeLabel, Slot.result(), toInline.getType().getReturnType());
        }
        return super.invoke(targetPtr, receiver, arguments, catchLabel, resumeLabel, targetArguments);
    }

    private ExecutableElement getInlinedElement(Value target) {
        ExecutableLiteral el;
        ExecutableElement element;
        if (target instanceof ExecutableLiteral && (element = (el = (ExecutableLiteral)target).getExecutable()) != null && element.hasNoModifiersOf(0x200000)) {
            return element;
        }
        return null;
    }

    private BasicBlock doInline(Value receiver, ExecutableElement element, List<Value> arguments, BlockLabel catchLabel, Function<Value, BasicBlock> onReturn, Map<Slot, Value> targetArguments) {
        MethodBody body = element.getPreviousMethodBody();
        if (body != null) {
            float savedCost = this.cost;
            boolean alwaysInline = element.hasAllModifiersOf(0x100000);
            BlockLabel inlined = new BlockLabel();
            try {
                this.begin(inlined, bbb -> {
                    try {
                        BlockEntry blockEntry = bbb.getBlockEntry();
                        this.setCallSite((Node)blockEntry);
                        BasicBlock origEntryBlock = body.getEntryBlock();
                        Node.Copier copier = new Node.Copier(origEntryBlock, this.getFirstBuilder(), this.ctxt, (ctxt, visitor) -> new Visitor((NodeVisitor<Node.Copier, Value, Node, BasicBlock>)visitor, arguments, receiver, onReturn, catchLabel, inlined, alwaysInline, targetArguments));
                        copier.copyBlockAs(origEntryBlock, inlined);
                        copier.copyScheduledNodes(origEntryBlock);
                    }
                    catch (BlockEarlyTermination blockEarlyTermination) {
                        // empty catch block
                    }
                    this.copyDeclarations(element);
                });
            }
            catch (Cancel ignored) {
                this.cost = savedCost;
                return null;
            }
            return this.goto_(inlined, Map.of());
        }
        return null;
    }

    private void copyDeclarations(ExecutableElement target) {
        ProgramModule ourModule = this.ctxt.getOrAddProgramModule(this.getRootElement().getEnclosingType());
        ProgramModule module = this.ctxt.getOrAddProgramModule(target.getEnclosingType());
        for (Declaration decl : module.declarations()) {
            if (decl instanceof FunctionDeclaration) {
                FunctionDeclaration declaration = (FunctionDeclaration)decl;
                ourModule.declareFunction(declaration);
                continue;
            }
            if (!(decl instanceof DataDeclaration)) continue;
            DataDeclaration declaration = (DataDeclaration)decl;
            ourModule.declareData(declaration);
        }
    }

    private static Map<Slot, Value> addArg(Map<Slot, Value> targetArguments, Slot slot, Value value) {
        return Maps.immutable.ofMap(targetArguments).newWithKeyValue((Object)slot, (Object)value).castToMap();
    }

    private /* synthetic */ BasicBlock lambda$callNoSideEffects$1(BlockLabel resumeLabel, Value val) {
        return this.goto_(resumeLabel, Map.of(Slot.result(), val));
    }

    private /* synthetic */ BasicBlock lambda$call$0(BlockLabel resumeLabel, Value val) {
        return this.goto_(resumeLabel, Slot.result(), val);
    }

    static final class Cancel
    extends RuntimeException {
        Cancel() {
            super(null, null, false, false);
        }
    }

    final class Visitor
    implements NodeVisitor.Delegating<Node.Copier, Value, Node, BasicBlock> {
        private final NodeVisitor<Node.Copier, Value, Node, BasicBlock> delegate;
        private final List<Value> arguments;
        private final Value this_;
        private final Function<Value, BasicBlock> onReturn;
        private final BlockLabel catchLabel;
        private final BlockLabel entryBlock;
        private final boolean alwaysInline;
        private final Map<Slot, Value> targetArguments;

        Visitor(NodeVisitor<Node.Copier, Value, Node, BasicBlock> delegate, List<Value> arguments, Value this_, Function<Value, BasicBlock> onReturn, BlockLabel catchLabel, BlockLabel entryBlock, boolean alwaysInline, Map<Slot, Value> targetArguments) {
            this.delegate = delegate;
            this.arguments = arguments;
            this.this_ = this_;
            this.onReturn = onReturn;
            this.catchLabel = catchLabel;
            this.entryBlock = entryBlock;
            this.alwaysInline = alwaysInline;
            this.targetArguments = targetArguments;
        }

        public NodeVisitor<Node.Copier, Value, Node, BasicBlock> getDelegateNodeVisitor() {
            return this.delegate;
        }

        public BasicBlock visit(Node.Copier param, Return node) {
            try {
                param.copyNode(node.getDependency());
                return this.onReturn.apply(param.copyValue(node.getReturnValue()));
            }
            catch (BlockEarlyTermination e) {
                return e.getTerminatedBlock();
            }
        }

        public Value visit(Node.Copier copier, BlockParameter node) {
            if (node.getPinnedBlockLabel().equals(this.entryBlock)) {
                Slot slot = node.getSlot();
                if (slot == Slot.this_()) {
                    return this.this_;
                }
                if (slot.getName().equals("p")) {
                    return this.arguments.get(slot.getIndex());
                }
            }
            return (Value)this.delegate.visit((Object)copier, node);
        }

        public Value visit(Node.Copier param, Add node) {
            this.addCost(param, 1);
            return (Value)this.delegate.visit((Object)param, node);
        }

        public Value visit(Node.Copier param, And node) {
            this.addCost(param, 1);
            return (Value)this.delegate.visit((Object)param, node);
        }

        public Value visit(Node.Copier param, Div node) {
            this.addCost(param, 1);
            return (Value)this.delegate.visit((Object)param, node);
        }

        public Value visit(Node.Copier param, Mod node) {
            this.addCost(param, 1);
            return (Value)this.delegate.visit((Object)param, node);
        }

        public Value visit(Node.Copier param, Multiply node) {
            this.addCost(param, 1);
            return (Value)this.delegate.visit((Object)param, node);
        }

        public Value visit(Node.Copier param, Neg node) {
            this.addCost(param, 1);
            return (Value)this.delegate.visit((Object)param, node);
        }

        public Value visit(Node.Copier param, Or node) {
            this.addCost(param, 1);
            return (Value)this.delegate.visit((Object)param, node);
        }

        public Value visit(Node.Copier param, Sub node) {
            this.addCost(param, 1);
            return (Value)this.delegate.visit((Object)param, node);
        }

        public Value visit(Node.Copier param, Xor node) {
            this.addCost(param, 1);
            return (Value)this.delegate.visit((Object)param, node);
        }

        public Value visit(Node.Copier param, IsEq node) {
            this.addCost(param, 1);
            return (Value)this.delegate.visit((Object)param, node);
        }

        public Value visit(Node.Copier param, IsGe node) {
            this.addCost(param, 1);
            return (Value)this.delegate.visit((Object)param, node);
        }

        public Value visit(Node.Copier param, IsGt node) {
            this.addCost(param, 1);
            return (Value)this.delegate.visit((Object)param, node);
        }

        public Value visit(Node.Copier param, IsLe node) {
            this.addCost(param, 1);
            return (Value)this.delegate.visit((Object)param, node);
        }

        public Value visit(Node.Copier param, IsLt node) {
            this.addCost(param, 1);
            return (Value)this.delegate.visit((Object)param, node);
        }

        public Value visit(Node.Copier param, IsNe node) {
            this.addCost(param, 1);
            return (Value)this.delegate.visit((Object)param, node);
        }

        public Value visit(Node.Copier param, BitCast node) {
            this.addCost(param, 1);
            return (Value)this.delegate.visit((Object)param, node);
        }

        public Value visit(Node.Copier param, Convert node) {
            this.addCost(param, 1);
            return (Value)this.delegate.visit((Object)param, node);
        }

        public Value visit(Node.Copier param, DecodeReference node) {
            this.addCost(param, 1);
            return (Value)this.delegate.visit((Object)param, node);
        }

        public Value visit(Node.Copier param, Extend node) {
            this.addCost(param, 1);
            return (Value)this.delegate.visit((Object)param, node);
        }

        public Value visit(Node.Copier param, Truncate node) {
            this.addCost(param, 1);
            return (Value)this.delegate.visit((Object)param, node);
        }

        public Value visit(Node.Copier param, Rol node) {
            this.addCost(param, 1);
            return (Value)this.delegate.visit((Object)param, node);
        }

        public Value visit(Node.Copier param, Ror node) {
            this.addCost(param, 1);
            return (Value)this.delegate.visit((Object)param, node);
        }

        public Value visit(Node.Copier param, Shl node) {
            this.addCost(param, 1);
            return (Value)this.delegate.visit((Object)param, node);
        }

        public Value visit(Node.Copier param, Shr node) {
            this.addCost(param, 1);
            return (Value)this.delegate.visit((Object)param, node);
        }

        public BasicBlock visit(Node.Copier param, If node) {
            this.addCost(param, 4);
            return (BasicBlock)this.delegate.visit((Object)param, node);
        }

        public BasicBlock visit(Node.Copier param, Switch node) {
            this.addCost(param, 2 * (node.getNumberOfValues() + 1));
            return (BasicBlock)this.delegate.visit((Object)param, node);
        }

        public Value visit(Node.Copier param, Call node) {
            this.addCost(param, 10);
            if (this.catchLabel != null) {
                param.copyNode(node.getDependency());
                BlockLabel resume = new BlockLabel();
                Value result = InliningBasicBlockBuilder.this.invoke(param.copyValue(node.getTarget()), param.copyValue(node.getReceiver()), param.copyValues(node.getArguments()), this.catchLabel, resume, this.targetArguments);
                InliningBasicBlockBuilder.this.begin(resume);
                return result;
            }
            return (Value)this.delegate.visit((Object)param, node);
        }

        public Value visit(Node.Copier param, CallNoSideEffects node) {
            this.addCost(param, 10);
            if (this.catchLabel != null) {
                BlockLabel resume = new BlockLabel();
                Value result = InliningBasicBlockBuilder.this.invoke(param.copyValue(node.getTarget()), param.copyValue(node.getReceiver()), param.copyValues(node.getArguments()), this.catchLabel, resume, this.targetArguments);
                InliningBasicBlockBuilder.this.begin(resume);
                return result;
            }
            return (Value)this.delegate.visit((Object)param, node);
        }

        public BasicBlock visit(Node.Copier param, CallNoReturn node) {
            this.addCost(param, 10);
            if (this.catchLabel != null) {
                param.copyNode(node.getDependency());
                return InliningBasicBlockBuilder.this.invokeNoReturn(param.copyValue(node.getTarget()), param.copyValue(node.getReceiver()), param.copyValues(node.getArguments()), this.catchLabel, this.targetArguments);
            }
            return (BasicBlock)this.delegate.visit((Object)param, node);
        }

        public BasicBlock visit(Node.Copier param, TailCall node) {
            this.addCost(param, 10);
            if (this.catchLabel != null) {
                param.copyNode(node.getDependency());
                BlockLabel resume = new BlockLabel();
                Value result = InliningBasicBlockBuilder.this.invoke(param.copyValue(node.getTarget()), param.copyValue(node.getReceiver()), param.copyValues(node.getArguments()), this.catchLabel, resume, this.targetArguments);
                InliningBasicBlockBuilder.this.begin(resume);
                return InliningBasicBlockBuilder.this.return_(result);
            }
            return (BasicBlock)this.delegate.visit((Object)param, node);
        }

        public BasicBlock visit(Node.Copier copier, Throw node) {
            if (this.catchLabel != null) {
                copier.copyNode(node.getDependency());
                return InliningBasicBlockBuilder.this.goto_(this.catchLabel, InliningBasicBlockBuilder.addArg(this.targetArguments, Slot.thrown(), copier.copyValue(node.getThrownValue())));
            }
            return (BasicBlock)this.delegate.visit((Object)copier, node);
        }

        public BasicBlock visit(Node.Copier param, Invoke node) {
            this.addCost(param, 10);
            return (BasicBlock)this.delegate.visit((Object)param, node);
        }

        public BasicBlock visit(Node.Copier param, InvokeNoReturn node) {
            this.addCost(param, 10);
            return (BasicBlock)this.delegate.visit((Object)param, node);
        }

        void addCost(Node.Copier copier, int amount) {
            if (!this.alwaysInline) {
                float cost = InliningBasicBlockBuilder.this.cost + (float)amount;
                if (cost >= 80.0f) {
                    try {
                        copier.getBlockBuilder().unreachable();
                    }
                    catch (IllegalStateException | BlockEarlyTermination throwable) {
                        // empty catch block
                    }
                    throw new Cancel();
                }
                InliningBasicBlockBuilder.this.cost = cost;
            }
        }
    }
}

