/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.opt.ea;

import java.util.List;
import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.BlockEntry;
import org.qbicc.graph.BlockLabel;
import org.qbicc.graph.New;
import org.qbicc.graph.Node;
import org.qbicc.graph.NodeVisitor;
import org.qbicc.graph.OrderedNode;
import org.qbicc.graph.Value;
import org.qbicc.graph.literal.IntegerLiteral;
import org.qbicc.graph.literal.LiteralFactory;
import org.qbicc.plugin.coreclasses.BasicHeaderInitializer;
import org.qbicc.plugin.layout.Layout;
import org.qbicc.plugin.layout.LayoutInfo;
import org.qbicc.plugin.opt.ea.EscapeAnalysisState;
import org.qbicc.type.ClassObjectType;
import org.qbicc.type.CompoundType;
import org.qbicc.type.ValueType;
import org.qbicc.type.WordType;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.LoadedTypeDefinition;
import org.qbicc.type.definition.element.MethodElement;

public final class EscapeAnalysisOptimizeVisitor
implements NodeVisitor.Delegating<Node.Copier, Value, Node, BasicBlock> {
    private final CompilationContext ctxt;
    private final NodeVisitor<Node.Copier, Value, Node, BasicBlock> delegate;
    private final EscapeAnalysisState escapeAnalysisState;
    private final MethodElement zeroMethod;

    public EscapeAnalysisOptimizeVisitor(CompilationContext ctxt, NodeVisitor<Node.Copier, Value, Node, BasicBlock> delegate) {
        this.ctxt = ctxt;
        this.delegate = delegate;
        this.escapeAnalysisState = EscapeAnalysisState.getPrevious(ctxt);
        ClassContext classContext = ctxt.getBootstrapClassContext();
        DefinedTypeDefinition defined = classContext.findDefinedType("org/qbicc/runtime/gc/nogc/NoGcHelpers");
        if (defined == null) {
            throw EscapeAnalysisOptimizeVisitor.runtimeMissing();
        }
        LoadedTypeDefinition loaded = defined.load();
        int index = loaded.findMethodIndex(e -> e.getName().equals("clear"));
        if (index == -1) {
            throw EscapeAnalysisOptimizeVisitor.methodMissing();
        }
        this.zeroMethod = loaded.getMethod(index);
    }

    private static IllegalStateException runtimeMissing() {
        return new IllegalStateException("The NoGC helpers runtime classes are not present in the bootstrap class path");
    }

    private static IllegalStateException methodMissing() {
        return new IllegalStateException("Required method is missing from the NoGC helpers");
    }

    public NodeVisitor<Node.Copier, Value, Node, BasicBlock> getDelegateNodeVisitor() {
        return this.delegate;
    }

    public Value visit(Node.Copier param, New original) {
        BasicBlockBuilder bbb = param.getBlockBuilder();
        if (this.isStackAllocate(original, bbb)) {
            param.copyNode(original.getDependency());
            return this.stackAllocate(original, bbb);
        }
        return (Value)super.visit((Object)param, original);
    }

    private boolean isStackAllocate(New new_, BasicBlockBuilder bbb) {
        return this.escapeAnalysisState.isNotEscapingMethod(new_, bbb.getCurrentElement()) && this.notInLoop((Node)new_);
    }

    private boolean notInLoop(Node node) {
        if (node instanceof OrderedNode) {
            OrderedNode on = (OrderedNode)node;
            Node dependency = on.getDependency();
            if (dependency instanceof BlockEntry) {
                BlockEntry be = (BlockEntry)dependency;
                return BlockLabel.getTargetOf((BlockLabel)be.getPinnedBlockLabel()).getLoops().size() == 0;
            }
            return this.notInLoop(on.getDependency());
        }
        return false;
    }

    private Value stackAllocate(New new_, BasicBlockBuilder bbb) {
        ClassObjectType type = new_.getClassObjectType();
        Layout layout = Layout.get((CompilationContext)this.ctxt);
        LayoutInfo info = layout.getInstanceLayoutInfo(type.getDefinition());
        CompoundType compoundType = info.getCompoundType();
        LiteralFactory lf = this.ctxt.getLiteralFactory();
        IntegerLiteral align = lf.literalOf(compoundType.getAlign());
        Value ptrVal = bbb.stackAllocate((ValueType)compoundType, (Value)lf.literalOf(1), (Value)align);
        Value oop = bbb.valueConvert(ptrVal, (WordType)type.getReference());
        this.initializeObjectFieldsToZero(info, lf, oop, bbb);
        BasicHeaderInitializer.initializeObjectHeader((CompilationContext)this.ctxt, (BasicBlockBuilder)bbb, (Value)bbb.decodeReference(oop), (Value)this.ctxt.getLiteralFactory().literalOfType((ValueType)type));
        return oop;
    }

    private void initializeObjectFieldsToZero(LayoutInfo info, LiteralFactory lf, Value oop, BasicBlockBuilder bbb) {
        bbb.call((Value)lf.literalOf(this.zeroMethod), List.of(oop, lf.literalOf(info.getCompoundType().getSize())));
    }
}

