/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.opt;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.qbicc.context.CompilationContext;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.BlockEntry;
import org.qbicc.graph.BlockParameter;
import org.qbicc.graph.Goto;
import org.qbicc.graph.If;
import org.qbicc.graph.Node;
import org.qbicc.graph.NodeVisitor;
import org.qbicc.graph.Slot;
import org.qbicc.graph.Value;

public class GotoRemovingVisitor
implements NodeVisitor.Delegating<Node.Copier, Value, Node, BasicBlock> {
    private final NodeVisitor<Node.Copier, Value, Node, BasicBlock> delegate;
    private final Set<BasicBlock> deleted = new HashSet<BasicBlock>();

    public GotoRemovingVisitor(CompilationContext context, NodeVisitor<Node.Copier, Value, Node, BasicBlock> delegate) {
        this.delegate = delegate;
    }

    public NodeVisitor<Node.Copier, Value, Node, BasicBlock> getDelegateNodeVisitor() {
        return this.delegate;
    }

    public BasicBlock visit(Node.Copier param, Goto node) {
        BasicBlock target = node.getResumeTarget();
        if (target.getIncoming().size() == 1 && Objects.equals(node.getCallSite(), target.getTerminator().getCallSite())) {
            this.deleted.add(target);
            param.copyNode(node.getDependency());
            return param.copyTerminator(target.getTerminator());
        }
        return (BasicBlock)this.getDelegateTerminatorVisitor().visit((Object)param, node);
    }

    public BasicBlock visit(Node.Copier param, If node) {
        return (BasicBlock)this.getDelegateTerminatorVisitor().visit((Object)param, node);
    }

    public Value visit(Node.Copier copier, BlockParameter node) {
        BasicBlock block = node.getPinnedBlock();
        if (this.deleted.contains(block)) {
            Slot slot = node.getSlot();
            Set incoming = block.getIncoming();
            if (incoming.size() == 1) {
                BasicBlock gotoBlock = (BasicBlock)incoming.iterator().next();
                Goto goto_ = (Goto)gotoBlock.getTerminator();
                return copier.copyValue(goto_.getOutboundArgument(slot));
            }
            if (incoming.size() == 2) {
                BasicBlock ifBlock = (BasicBlock)((BasicBlock)incoming.iterator().next()).getIncoming().iterator().next();
                If if_ = (If)ifBlock.getTerminator();
                Value copiedCond = copier.copyValue(if_.getCondition());
                BasicBlock tb = if_.getTrueBranch();
                BasicBlock fb = if_.getFalseBranch();
                return copier.getBlockBuilder().select(copiedCond, copier.copyValue(tb.getTerminator().getOutboundArgument(slot)), copier.copyValue(fb.getTerminator().getOutboundArgument(slot)));
            }
            throw new IllegalStateException();
        }
        return (Value)this.getDelegateValueVisitor().visit((Object)copier, node);
    }

    public Node visit(Node.Copier param, BlockEntry node) {
        BasicBlock block = node.getPinnedBlock();
        if (this.deleted.contains(block)) {
            if (block.getIncoming().size() == 2) {
                return param.copyNode(((BasicBlock)((BasicBlock)block.getIncoming().iterator().next()).getIncoming().iterator().next()).getTerminator().getDependency());
            }
            return param.copyNode(((BasicBlock)block.getIncoming().iterator().next()).getTerminator().getDependency());
        }
        return (Node)this.getDelegateActionVisitor().visit((Object)param, node);
    }
}

