/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.opt;

import org.qbicc.context.CompilationContext;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.DelegatingBasicBlockBuilder;
import org.qbicc.graph.Field;
import org.qbicc.graph.ReferenceHandle;
import org.qbicc.graph.Value;
import org.qbicc.graph.ValueHandle;
import org.qbicc.graph.atomic.AccessModes;
import org.qbicc.graph.atomic.ReadAccessMode;
import org.qbicc.graph.literal.Literal;
import org.qbicc.graph.literal.ObjectLiteral;
import org.qbicc.interpreter.Memory;
import org.qbicc.interpreter.VmClass;
import org.qbicc.interpreter.VmObject;
import org.qbicc.type.TypeType;
import org.qbicc.type.ValueType;
import org.qbicc.type.definition.element.FieldElement;
import org.qbicc.type.descriptor.BaseTypeDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;

public class FinalFieldLoadOptimizer
extends DelegatingBasicBlockBuilder {
    final CompilationContext ctxt;

    public FinalFieldLoadOptimizer(CompilationContext ctxt, BasicBlockBuilder delegate) {
        super(delegate);
        this.ctxt = ctxt;
    }

    public Value load(ValueHandle handle, ReadAccessMode accessMode) {
        Field fh;
        if (handle instanceof Field && (fh = (Field)handle).getVariableElement().isReallyFinal()) {
            FieldElement fieldElement = fh.getVariableElement();
            if (fieldElement.isStatic()) {
                Value contents = fieldElement.getEnclosingType().load().getInitialValue(fieldElement);
                if (contents instanceof Literal) {
                    return contents;
                }
            } else {
                ReferenceHandle rh;
                ValueHandle contents = fh.getValueHandle();
                if (contents instanceof ReferenceHandle && (contents = (rh = (ReferenceHandle)contents).getReferenceValue()) instanceof ObjectLiteral) {
                    Object contents2;
                    ObjectLiteral ol = (ObjectLiteral)contents;
                    VmClass vmClass = ol.getValue().getVmClass();
                    int offset = vmClass.indexOf(fieldElement);
                    Memory mem = ol.getValue().getMemory();
                    TypeDescriptor desc = fieldElement.getTypeDescriptor();
                    if (desc.equals((TypeDescriptor)BaseTypeDescriptor.Z)) {
                        int val = mem.load8((long)offset, (ReadAccessMode)AccessModes.SinglePlain);
                        contents2 = this.ctxt.getLiteralFactory().literalOf(val != 0);
                    } else if (desc.equals((TypeDescriptor)BaseTypeDescriptor.B)) {
                        contents2 = this.ctxt.getLiteralFactory().literalOf((byte)mem.load8((long)offset, (ReadAccessMode)AccessModes.SinglePlain));
                    } else if (desc.equals((TypeDescriptor)BaseTypeDescriptor.S)) {
                        contents2 = this.ctxt.getLiteralFactory().literalOf((short)mem.load16((long)offset, (ReadAccessMode)AccessModes.SinglePlain));
                    } else if (desc.equals((TypeDescriptor)BaseTypeDescriptor.C)) {
                        contents2 = this.ctxt.getLiteralFactory().literalOf((char)mem.load16((long)offset, (ReadAccessMode)AccessModes.SinglePlain));
                    } else if (desc.equals((TypeDescriptor)BaseTypeDescriptor.I)) {
                        contents2 = this.ctxt.getLiteralFactory().literalOf(mem.load32((long)offset, (ReadAccessMode)AccessModes.SinglePlain));
                    } else if (desc.equals((TypeDescriptor)BaseTypeDescriptor.F)) {
                        contents2 = this.ctxt.getLiteralFactory().literalOf(mem.loadFloat((long)offset, (ReadAccessMode)AccessModes.SinglePlain));
                    } else if (desc.equals((TypeDescriptor)BaseTypeDescriptor.J)) {
                        contents2 = this.ctxt.getLiteralFactory().literalOf(mem.load64((long)offset, (ReadAccessMode)AccessModes.SinglePlain));
                    } else if (desc.equals((TypeDescriptor)BaseTypeDescriptor.D)) {
                        contents2 = this.ctxt.getLiteralFactory().literalOf(mem.loadDouble((long)offset, (ReadAccessMode)AccessModes.SinglePlain));
                    } else if (fh.getPointeeType() instanceof TypeType) {
                        ValueType tt = mem.loadType((long)offset, (ReadAccessMode)AccessModes.SinglePlain);
                        contents2 = this.ctxt.getLiteralFactory().literalOfType(tt);
                    } else {
                        VmObject value = mem.loadRef((long)offset, (ReadAccessMode)AccessModes.SinglePlain);
                        contents2 = value == null ? this.ctxt.getLiteralFactory().zeroInitializerLiteralOfType(fieldElement.getType()) : this.ctxt.getLiteralFactory().literalOf(value);
                    }
                    return contents2;
                }
            }
        }
        return this.getDelegate().load(handle, accessMode);
    }
}

