/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.opt.ea;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.qbicc.graph.Call;
import org.qbicc.graph.InstanceFieldOf;
import org.qbicc.graph.New;
import org.qbicc.graph.Node;
import org.qbicc.graph.ParameterValue;
import org.qbicc.graph.PhiValue;
import org.qbicc.graph.Value;
import org.qbicc.plugin.opt.ea.EscapeValue;
import org.qbicc.type.definition.element.ExecutableElement;

final class ConnectionGraph {
    private final Map<Node, Value> pointsToEdges = new HashMap<Node, Value>();
    private final Map<ParameterValue, Collection<InstanceFieldOf>> fieldEdges = new HashMap<ParameterValue, Collection<InstanceFieldOf>>();
    private final Map<Node, EscapeValue> escapeValues = new HashMap<Node, EscapeValue>();
    private final ParameterArray parameters;
    private final String name;

    ConnectionGraph(ExecutableElement element) {
        this.name = element.toString();
        this.parameters = new ParameterArray(element.getSignature().getParameterTypes().size());
    }

    public String toString() {
        return "ConnectionGraph{name='" + this.name + "'}";
    }

    void addPointsToEdge(Node from, Value to) {
        this.addPointsToEdgeIfAbsent(from, to);
    }

    Value getPointsToEdge(Node from) {
        return this.pointsToEdges.get(from);
    }

    void addFieldEdge(ParameterValue node, InstanceFieldOf instanceField) {
        this.addFieldEdgeIfAbsent(node, instanceField);
    }

    Collection<InstanceFieldOf> getFieldEdges(Node node) {
        if (node instanceof ParameterValue) {
            ParameterValue pv = (ParameterValue)node;
            Collection<InstanceFieldOf> found = this.fieldEdges.get(pv);
            return found == null ? Collections.emptyList() : found;
        }
        return Collections.emptyList();
    }

    void setNoEscape(Node node) {
        this.setEscapeValue(node, EscapeValue.NO_ESCAPE);
    }

    void setArgEscape(Node node) {
        this.setEscapeValue(node, EscapeValue.ARG_ESCAPE);
    }

    void setGlobalEscape(Node node) {
        this.setEscapeValue(node, EscapeValue.GLOBAL_ESCAPE);
    }

    void setNewEscapeValue(New new_, EscapeValue escapeValue) {
        this.setEscapeValue((Node)new_, escapeValue);
    }

    boolean addParameter(ParameterValue param) {
        return this.parameters.addIfAbsent(param);
    }

    EscapeValue getEscapeValue(Node node) {
        return EscapeValue.of(this.escapeValues.get(node));
    }

    void updateAfterInvokingMethod(Call callee, ConnectionGraph calleeCG) {
        if (callee.getArguments().size() > calleeCG.parameters.size()) {
            return;
        }
        List arguments = callee.getArguments();
        for (int i = 0; i < arguments.size(); ++i) {
            Value outsideArg = (Value)arguments.get(i);
            ParameterValue insideArg = calleeCG.parameters.get(i);
            ArrayList<Node> mapsToObj = new ArrayList<Node>();
            this.updateCallerNode((Node)insideArg, calleeCG, mapsToObj, (Node)outsideArg);
            this.updatePointsToCallerNodes((Node)insideArg, List.of(outsideArg), calleeCG, mapsToObj);
        }
    }

    private void updatePointsToCallerNodes(Node calleeNode, Collection<Node> mapsToField, ConnectionGraph calleeCG, Collection<Node> mapsToObj) {
        Value calleePointed = calleeCG.getPointsToEdge(calleeNode);
        if (Objects.nonNull(calleePointed)) {
            for (Node callerNode : mapsToField) {
                Value callerPointed = this.getPointsToEdge(callerNode);
                if (!Objects.nonNull(callerPointed)) continue;
                this.updateCallerNode((Node)calleePointed, calleeCG, mapsToObj, (Node)callerPointed);
            }
        }
    }

    private void updateCallerNode(Node calleeNode, ConnectionGraph calleeCG, Collection<Node> mapsToObj, Node callerNode) {
        if (mapsToObj.add(calleeNode)) {
            if (calleeCG.getEscapeValue(calleeNode).isGlobalEscape()) {
                this.setEscapeValue(callerNode, EscapeValue.GLOBAL_ESCAPE);
            }
            for (InstanceFieldOf calleeField : calleeCG.getFieldEdges(calleeNode)) {
                String calleeFieldName = calleeField.getVariableElement().getName();
                Collection callerFields = this.getFieldEdges(callerNode).stream().filter(field -> Objects.equals(field.getVariableElement().getName(), calleeFieldName)).collect(Collectors.toList());
                this.updatePointsToCallerNodes((Node)calleeField, callerFields, calleeCG, mapsToObj);
            }
        }
    }

    void updateAtMethodExit() {
        this.propagateGlobalEscape();
        this.propagateArgEscapeOnly();
    }

    private void propagateGlobalEscape() {
        List<Node> globalEscape = this.escapeValues.entrySet().stream().filter(e -> ((EscapeValue)((Object)((Object)e.getValue()))).isGlobalEscape()).map(Map.Entry::getKey).toList();
        globalEscape.forEach(this::computeGlobalEscape);
        Map<Integer, List<ParameterValue>> indexedParameterValues = this.escapeValues.keySet().stream().filter(key -> key instanceof ParameterValue).map(key -> (ParameterValue)key).collect(Collectors.groupingBy(ParameterValue::getIndex));
        globalEscape.stream().filter(n -> n instanceof ParameterValue).map(key -> (ParameterValue)key).flatMap(pv -> ((List)indexedParameterValues.get(pv.getIndex())).stream()).forEach(pv -> this.setEscapeValue((Node)pv, EscapeValue.GLOBAL_ESCAPE));
    }

    private void computeGlobalEscape(Node from) {
        Value pointsTo = this.getPointsToEdge(from);
        if (Objects.nonNull(pointsTo) && this.getEscapeValue((Node)pointsTo).notGlobalEscape()) {
            this.switchToGlobalEscape((Node)pointsTo);
        }
        this.getFieldEdges(from).stream().filter(field -> this.getEscapeValue((Node)field).notGlobalEscape()).forEach(this::switchToGlobalEscape);
    }

    private void switchToGlobalEscape(Node pointsTo) {
        this.setEscapeValue(pointsTo, EscapeValue.GLOBAL_ESCAPE);
        this.computeGlobalEscape(pointsTo);
    }

    void propagateArgEscapeOnly() {
        List<Node> argEscapeOnly = this.escapeValues.entrySet().stream().filter(e -> ((EscapeValue)((Object)((Object)e.getValue()))).isArgEscape()).map(Map.Entry::getKey).toList();
        argEscapeOnly.forEach(this::computeArgEscapeOnly);
    }

    private void computeArgEscapeOnly(Node from) {
        Value pointsTo = this.getPointsToEdge(from);
        if (Objects.nonNull(pointsTo) && this.getEscapeValue((Node)pointsTo).isMoreThanArgEscape()) {
            this.switchToArgEscape((Node)pointsTo);
        }
        this.getFieldEdges(from).stream().filter(field -> this.getEscapeValue((Node)field).isMoreThanArgEscape()).forEach(this::switchToArgEscape);
    }

    private void switchToArgEscape(Node to) {
        this.setEscapeValue(to, EscapeValue.ARG_ESCAPE);
        this.computeArgEscapeOnly(to);
    }

    ConnectionGraph union(ConnectionGraph other) {
        if (Objects.nonNull(other)) {
            this.pointsToEdges.putAll(other.pointsToEdges);
            this.fieldEdges.putAll(other.fieldEdges);
            Map<Node, EscapeValue> mergedEscapeValues = this.mergeEscapeValues(other);
            this.escapeValues.clear();
            this.escapeValues.putAll(mergedEscapeValues);
            this.parameters.addAll(other.parameters);
        }
        return this;
    }

    void resolveReturnedPhiValues() {
        List<Value> possibleNewValues = this.escapeValues.entrySet().stream().filter(entry -> entry.getKey() instanceof PhiValue && ((EscapeValue)((Object)((Object)entry.getValue()))).isArgEscape()).flatMap(entry -> ((PhiValue)entry.getKey()).getPossibleValues().stream()).filter(value -> value instanceof New && this.getEscapeValue((Node)value).isMoreThanArgEscape()).toList();
        possibleNewValues.forEach(value -> this.setEscapeValue((Node)value, EscapeValue.ARG_ESCAPE));
    }

    void validateNewNodes(List<New> supported) {
        List<Node> unsupportedNewNodes = this.escapeValues.entrySet().stream().filter(e -> e.getKey() instanceof New && ((EscapeValue)((Object)((Object)e.getValue()))).notGlobalEscape()).filter(e -> !supported.contains(e.getKey())).map(Map.Entry::getKey).toList();
        unsupportedNewNodes.forEach(node -> this.setEscapeValue((Node)node, EscapeValue.GLOBAL_ESCAPE));
    }

    private Map<Node, EscapeValue> mergeEscapeValues(ConnectionGraph other) {
        HashMap<Node, EscapeValue> result = new HashMap<Node, EscapeValue>(this.escapeValues);
        other.escapeValues.forEach((key, value) -> result.merge((Node)key, (EscapeValue)((Object)value), EscapeValue::merge));
        return result;
    }

    private boolean addFieldEdgeIfAbsent(ParameterValue from, InstanceFieldOf to) {
        return this.fieldEdges.computeIfAbsent(from, obj -> new ArrayList()).add(to);
    }

    private boolean addPointsToEdgeIfAbsent(Node from, Value to) {
        return this.pointsToEdges.putIfAbsent(from, to) == null;
    }

    private boolean setEscapeValue(Node node, EscapeValue escapeValue) {
        EscapeValue prev = this.escapeValues.get(node);
        if (prev == null || prev != EscapeValue.merge(prev, escapeValue)) {
            this.escapeValues.put(node, escapeValue);
            return true;
        }
        return false;
    }

    private static final class ParameterArray {
        private final ParameterValue[] elements;

        public ParameterArray(int size) {
            this.elements = new ParameterValue[size];
        }

        boolean addIfAbsent(ParameterValue elem) {
            if (this.elements[elem.getIndex()] != null) {
                return false;
            }
            this.elements[elem.getIndex()] = elem;
            return true;
        }

        ParameterValue get(int index) {
            return this.elements[index];
        }

        void addAll(ParameterArray other) {
            for (int i = 0; i < this.elements.length; ++i) {
                this.elements[i] = other.get(i);
            }
        }

        int size() {
            return this.elements.length;
        }
    }
}

