/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.opt.ea;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.qbicc.context.CompilationContext;
import org.qbicc.graph.Call;
import org.qbicc.graph.Executable;
import org.qbicc.plugin.opt.ea.ConnectionGraph;
import org.qbicc.plugin.opt.ea.EscapeAnalysisState;
import org.qbicc.plugin.reachability.ReachabilityInfo;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.LoadedTypeDefinition;
import org.qbicc.type.definition.element.ExecutableElement;
import org.qbicc.type.definition.element.MethodElement;
import org.qbicc.type.definition.element.NamedElement;

public class EscapeAnalysisInterMethodAnalysis
implements Consumer<CompilationContext> {
    @Override
    public void accept(CompilationContext ctxt) {
        new ConnectionGraphUpdater(ctxt).run();
    }

    private static boolean isImplementationOf(ExecutableElement executable, MethodElement instanceMethod) {
        if (executable instanceof NamedElement) {
            String executableName = ((NamedElement)executable).getName();
            return executableName.equals(instanceMethod.getName()) && executable.getDescriptor().equals(instanceMethod.getDescriptor());
        }
        return false;
    }

    private static final class ConnectionGraphUpdater
    implements Runnable {
        final Set<ExecutableElement> visited = new HashSet<ExecutableElement>();
        final EscapeAnalysisState state;
        final ReachabilityInfo rta;

        private ConnectionGraphUpdater(CompilationContext ctxt) {
            this.state = EscapeAnalysisState.get(ctxt);
            this.rta = ReachabilityInfo.get((CompilationContext)ctxt);
        }

        @Override
        public void run() {
            this.state.getMethodsVisited().forEach(this::updateConnectionGraphIfNotVisited);
        }

        private ConnectionGraph updateConnectionGraphIfNotVisited(ExecutableElement caller) {
            if (!this.visited.add(caller)) {
                return this.state.getConnectionGraph(caller);
            }
            return this.updateConnectionGraph(caller);
        }

        private ConnectionGraph updateConnectionGraph(ExecutableElement caller) {
            ConnectionGraph callerCG = this.findConnectionGraph(caller);
            if (callerCG == null) {
                return null;
            }
            for (Call callee : this.state.getCallees(caller)) {
                ExecutableElement calleeElement = ((Executable)callee.getValueHandle()).getExecutable();
                ConnectionGraph calleeCG = this.updateConnectionGraphIfNotVisited(calleeElement);
                if (calleeCG == null) continue;
                callerCG.updateAfterInvokingMethod(callee, calleeCG);
            }
            callerCG.updateAtMethodExit();
            return callerCG;
        }

        private ConnectionGraph findConnectionGraph(ExecutableElement executable) {
            ConnectionGraph cg = this.state.getConnectionGraph(executable);
            if (cg != null) {
                Set<ExecutableElement> subclasses = this.findSubclasses(executable, executable.getEnclosingType().load());
                if (subclasses.isEmpty()) {
                    return cg;
                }
                return this.unionConnectionGraph(subclasses, cg);
            }
            cg = this.findInterfaceConnectionGraph(executable);
            if (cg != null) {
                return cg;
            }
            cg = this.findAbstractConnectionGraph(executable);
            if (cg != null) {
                return cg;
            }
            return cg;
        }

        private Set<ExecutableElement> findSubclasses(ExecutableElement executable, LoadedTypeDefinition loadedExecutableType) {
            HashSet<ExecutableElement> implementors = new HashSet<ExecutableElement>();
            this.rta.visitReachableSubclassesPostOrder(loadedExecutableType, type -> this.findReachableMethods(executable, (LoadedTypeDefinition)type, (Set<ExecutableElement>)implementors));
            return implementors;
        }

        private ConnectionGraph findInterfaceConnectionGraph(ExecutableElement executable) {
            DefinedTypeDefinition enclosingType = executable.getEnclosingType();
            if (!enclosingType.isInterface()) {
                return null;
            }
            LoadedTypeDefinition loadedExecutableType = enclosingType.load();
            Set<ExecutableElement> implementors = this.findInterfaceImplementors(executable, loadedExecutableType);
            if (implementors.isEmpty()) {
                return null;
            }
            return this.unionConnectionGraph(implementors, new ConnectionGraph(executable));
        }

        private ConnectionGraph findAbstractConnectionGraph(ExecutableElement executable) {
            boolean isAbstractMethod;
            boolean bl = isAbstractMethod = executable instanceof MethodElement && ((MethodElement)executable).isAbstract();
            if (!isAbstractMethod) {
                return null;
            }
            LoadedTypeDefinition loadedExecutableType = executable.getEnclosingType().load();
            Set<ExecutableElement> subclasses = this.findSubclasses(executable, loadedExecutableType);
            if (subclasses.isEmpty()) {
                return null;
            }
            return this.unionConnectionGraph(subclasses, new ConnectionGraph(executable));
        }

        private ConnectionGraph unionConnectionGraph(Set<ExecutableElement> methods, ConnectionGraph initValue) {
            return methods.stream().map(this::updateConnectionGraphIfNotVisited).reduce(initValue, ConnectionGraph::union);
        }

        private Set<ExecutableElement> findInterfaceImplementors(ExecutableElement executable, LoadedTypeDefinition loadedExecutableType) {
            HashSet<ExecutableElement> implementors = new HashSet<ExecutableElement>();
            this.rta.visitReachableImplementors(loadedExecutableType, type -> this.findReachableMethods(executable, (LoadedTypeDefinition)type, (Set<ExecutableElement>)implementors));
            return implementors;
        }

        private void findReachableMethods(ExecutableElement executable, LoadedTypeDefinition type, Set<ExecutableElement> implementors) {
            MethodElement[] instanceMethods;
            for (MethodElement instanceMethod : instanceMethods = type.getInstanceMethods()) {
                if (!EscapeAnalysisInterMethodAnalysis.isImplementationOf(executable, instanceMethod) || !this.isReachable((ExecutableElement)instanceMethod)) continue;
                implementors.add((ExecutableElement)instanceMethod);
            }
        }

        private boolean isReachable(ExecutableElement executable) {
            return executable instanceof MethodElement && this.rta.isDispatchableMethod((MethodElement)executable);
        }
    }
}

