/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.opt.ea;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.qbicc.context.CompilationContext;
import org.qbicc.graph.InstanceFieldOf;
import org.qbicc.graph.Invoke;
import org.qbicc.graph.New;
import org.qbicc.graph.Node;
import org.qbicc.graph.NodeVisitor;
import org.qbicc.graph.ParameterValue;
import org.qbicc.graph.PhiValue;
import org.qbicc.graph.StaticField;
import org.qbicc.graph.Value;
import org.qbicc.plugin.dot.DotContext;
import org.qbicc.plugin.opt.ea.ConnectionGraph;
import org.qbicc.plugin.opt.ea.EscapeAnalysisState;
import org.qbicc.plugin.opt.ea.EscapeValue;

public final class EscapeAnalysisDotVisitor
implements NodeVisitor.Delegating<DotContext, String, String, String, String> {
    private final NodeVisitor<DotContext, String, String, String, String> delegate;
    private final EscapeAnalysisState escapeAnalysisState;
    private final Map<Invoke.ReturnValue, Node> invokeReturnValueQueue = new HashMap<Invoke.ReturnValue, Node>();

    public EscapeAnalysisDotVisitor(CompilationContext ctxt, NodeVisitor<DotContext, String, String, String, String> delegate) {
        this.delegate = delegate;
        this.escapeAnalysisState = EscapeAnalysisState.get(ctxt);
    }

    public NodeVisitor<DotContext, String, String, String, String> getDelegateNodeVisitor() {
        return this.delegate;
    }

    public String visit(DotContext param, New node) {
        return this.decorate(param, (Node)node);
    }

    public String visit(DotContext param, StaticField node) {
        return this.decorate(param, (Node)node);
    }

    public String visit(DotContext param, ParameterValue node) {
        return this.decorate(param, (Node)node);
    }

    public String visit(DotContext param, InstanceFieldOf node) {
        return this.decorate(param, (Node)node);
    }

    public String visit(DotContext param, PhiValue node) {
        return this.decorate(param, (Node)node);
    }

    public String visit(DotContext param, Invoke node) {
        Node pointsToFrom = this.invokeReturnValueQueue.get(node.getReturnValue());
        if (Objects.nonNull(pointsToFrom)) {
            this.addEdge(param, pointsToFrom, (Node)node, EdgeType.POINTS_TO, "P");
        }
        return param.getName((Node)node);
    }

    private String decorate(DotContext param, Node node) {
        ConnectionGraph connectionGraph = this.getConnectionGraph(param);
        String name = param.getName(node);
        param.appendTo((Object)name);
        param.attr("style", "filled");
        param.attr("fillcolor", this.nodeType((EscapeValue)connectionGraph.getEscapeValue((Node)node)).fillColor);
        param.nl();
        this.addFieldEdges(param, node, connectionGraph);
        this.addPointsToEdge(param, node, connectionGraph);
        return name;
    }

    private void addPointsToEdge(DotContext param, Node node, ConnectionGraph connectionGraph) {
        Value pointsTo = connectionGraph.getPointsToEdge(node);
        if (Objects.nonNull(pointsTo)) {
            if (pointsTo instanceof Invoke.ReturnValue) {
                Invoke.ReturnValue ret = (Invoke.ReturnValue)pointsTo;
                this.invokeReturnValueQueue.put(ret, node);
                return;
            }
            this.addEdge(param, node, (Node)pointsTo, EdgeType.POINTS_TO, "P");
        }
    }

    private void addFieldEdges(DotContext param, Node node, ConnectionGraph connectionGraph) {
        Collection<InstanceFieldOf> fields = connectionGraph.getFieldEdges(node);
        for (InstanceFieldOf field : fields) {
            this.addEdge(param, node, (Node)field, EdgeType.FIELD, "F");
        }
    }

    private ConnectionGraph getConnectionGraph(DotContext dtxt) {
        return this.escapeAnalysisState.getConnectionGraph(dtxt.getElement());
    }

    private NodeType nodeType(EscapeValue value) {
        return switch (value) {
            default -> throw new IncompatibleClassChangeError();
            case EscapeValue.GLOBAL_ESCAPE -> NodeType.GLOBAL_ESCAPE;
            case EscapeValue.ARG_ESCAPE -> NodeType.ARG_ESCAPE;
            case EscapeValue.NO_ESCAPE -> NodeType.NO_ESCAPE;
            case EscapeValue.UNKNOWN -> NodeType.UNKNOWN;
        };
    }

    private void addEdge(DotContext param, Node from, Node to, EdgeType edge, String label) {
        String fromName = param.visit(from);
        String toName = param.visit(to);
        this.addEdge(param, fromName, toName, edge, label);
    }

    private void addEdge(DotContext param, String fromName, String toName, EdgeType edge, String label) {
        param.appendTo((Object)fromName);
        param.appendTo((Object)" -> ");
        param.appendTo((Object)toName);
        param.attr("label", label);
        param.attr("style", edge.style);
        param.attr("color", edge.color);
        param.attr("fontcolor", edge.color);
        param.nl();
    }

    private static enum EdgeType {
        POINTS_TO("gray", "solid"),
        FIELD("gray", "dashed");

        final String color;
        final String style;
        final char label;

        private EdgeType(String color, String style) {
            this.color = color;
            this.style = style;
            this.label = this.toString().charAt(0);
        }
    }

    private static enum NodeType {
        GLOBAL_ESCAPE("lightsalmon"),
        ARG_ESCAPE("lightcyan3"),
        NO_ESCAPE("lightblue1"),
        UNKNOWN("lightpink1");

        final String fillColor;

        private NodeType(String fillColor) {
            this.fillColor = fillColor;
        }
    }
}

