/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.opt.ea;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.graph.Action;
import org.qbicc.graph.ActionVisitor;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.BlockLabel;
import org.qbicc.graph.Call;
import org.qbicc.graph.CastValue;
import org.qbicc.graph.CheckCast;
import org.qbicc.graph.DelegatingBasicBlockBuilder;
import org.qbicc.graph.Executable;
import org.qbicc.graph.InstanceFieldOf;
import org.qbicc.graph.Invoke;
import org.qbicc.graph.LocalVariable;
import org.qbicc.graph.New;
import org.qbicc.graph.Node;
import org.qbicc.graph.NodeVisitor;
import org.qbicc.graph.NotNull;
import org.qbicc.graph.OrderedNode;
import org.qbicc.graph.ParameterValue;
import org.qbicc.graph.ReferenceHandle;
import org.qbicc.graph.StaticField;
import org.qbicc.graph.Store;
import org.qbicc.graph.Terminator;
import org.qbicc.graph.TerminatorVisitor;
import org.qbicc.graph.Truncate;
import org.qbicc.graph.Value;
import org.qbicc.graph.ValueHandle;
import org.qbicc.graph.ValueHandleVisitor;
import org.qbicc.graph.ValueVisitor;
import org.qbicc.graph.atomic.ReadAccessMode;
import org.qbicc.graph.atomic.WriteAccessMode;
import org.qbicc.plugin.opt.ea.ConnectionGraph;
import org.qbicc.plugin.opt.ea.EscapeAnalysisState;
import org.qbicc.plugin.opt.ea.EscapeValue;
import org.qbicc.type.BooleanType;
import org.qbicc.type.ClassObjectType;
import org.qbicc.type.InstanceMethodType;
import org.qbicc.type.NumericType;
import org.qbicc.type.ObjectType;
import org.qbicc.type.ValueType;
import org.qbicc.type.VoidType;
import org.qbicc.type.WordType;
import org.qbicc.type.definition.element.ConstructorElement;
import org.qbicc.type.definition.element.FieldElement;
import org.qbicc.type.definition.element.MethodElement;
import org.qbicc.type.descriptor.MethodDescriptor;

public final class EscapeAnalysisIntraMethodBuilder
extends DelegatingBasicBlockBuilder {
    private final EscapeAnalysisState escapeAnalysisState;
    private final ConnectionGraph connectionGraph = new ConnectionGraph(this.getCurrentElement().toString());
    private final ClassContext bootstrapClassContext;
    private final SupportContext supportContext;

    public EscapeAnalysisIntraMethodBuilder(CompilationContext ctxt, BasicBlockBuilder delegate) {
        super(delegate);
        this.escapeAnalysisState = EscapeAnalysisState.get(ctxt);
        this.bootstrapClassContext = ctxt.getBootstrapClassContext();
        this.supportContext = new SupportContext(this.getCurrentElement().toString());
    }

    public Value new_(ClassObjectType type, Value typeId, Value size, Value align) {
        New result = (New)super.new_(type, typeId, size, align);
        this.connectionGraph.trackNew(result, this.defaultEscapeValue(type));
        return (Value)this.supports(result);
    }

    private EscapeValue defaultEscapeValue(ClassObjectType type) {
        if (this.isSubtypeOfClass("java/lang/Thread", type) || this.isSubtypeOfClass("java/lang/ThreadGroup", type)) {
            return EscapeValue.GLOBAL_ESCAPE;
        }
        return EscapeValue.NO_ESCAPE;
    }

    private boolean isSubtypeOfClass(String name, ClassObjectType type) {
        return type.isSubtypeOf(this.bootstrapClassContext.findDefinedType(name).load().getObjectType());
    }

    public ValueHandle instanceFieldOf(ValueHandle handle, FieldElement field) {
        InstanceFieldOf result = (InstanceFieldOf)super.instanceFieldOf(handle, field);
        this.handleInstanceFieldOf(result, handle, (Node)handle);
        return (ValueHandle)this.supports(result);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Node store(ValueHandle handle, Value value, WriteAccessMode mode) {
        Node result = super.store(handle, value, mode);
        if (handle instanceof StaticField) {
            if (value instanceof NotNull) {
                NotNull nn = (NotNull)value;
                this.connectionGraph.trackStoreStaticField(handle, nn.getInput());
                return this.supports(result);
            }
            this.connectionGraph.trackStoreStaticField(handle, value);
            return this.supports(result);
        }
        if (handle instanceof InstanceFieldOf) {
            InstanceFieldOf fieldOf = (InstanceFieldOf)handle;
            if (value instanceof New) {
                if (this.isThisHandle(fieldOf)) {
                    this.connectionGraph.trackStoreThisField(value);
                    return this.supports(result);
                }
                this.connectionGraph.fixEdgesNew(handle, (New)value);
                return this.supports(result);
            }
        }
        if (!(handle instanceof LocalVariable)) return this.supports(result);
        if (!(value instanceof New)) return this.supports(result);
        this.connectionGraph.trackLocalNew((LocalVariable)handle, (New)value);
        return this.supports(result);
    }

    private boolean isThisHandle(InstanceFieldOf fieldOf) {
        ParameterValue param;
        ReferenceHandle ref;
        ValueHandle valueHandle = fieldOf.getValueHandle();
        return valueHandle instanceof ReferenceHandle && (valueHandle = (ref = (ReferenceHandle)valueHandle).getReferenceValue()) instanceof ParameterValue && "this".equals((param = (ParameterValue)valueHandle).getLabel());
    }

    public Value call(ValueHandle target, List<Value> arguments) {
        Value result = super.call(target, arguments);
        if (target instanceof Executable) {
            this.escapeAnalysisState.trackCall(this.getCurrentElement(), (Call)result);
        }
        return this.supports(result);
    }

    public ValueHandle constructorOf(Value instance, ConstructorElement constructor, MethodDescriptor callSiteDescriptor, InstanceMethodType callSiteType) {
        return this.supports(super.constructorOf(instance, constructor, callSiteDescriptor, callSiteType));
    }

    public void startMethod(List<ParameterValue> arguments) {
        super.startMethod(arguments);
        this.escapeAnalysisState.trackMethod(this.getCurrentElement(), this.connectionGraph);
        this.connectionGraph.trackParameters(arguments);
    }

    public BasicBlock return_(Value value) {
        Invoke.ReturnValue ret;
        Call call;
        BasicBlock result = super.return_(value);
        if (value instanceof Call && !this.isPrimitive((call = (Call)value).getType())) {
            for (Value argument : call.getArguments()) {
                this.connectionGraph.trackReturn(argument);
            }
        } else if (value instanceof Invoke.ReturnValue && !this.isPrimitive((ret = (Invoke.ReturnValue)value).getType())) {
            for (Value argument : ret.getInvoke().getArguments()) {
                this.connectionGraph.trackReturn(argument);
            }
        } else if (!(value instanceof Truncate)) {
            this.connectionGraph.trackReturn(value);
        }
        return this.supports(result.getTerminator(), result);
    }

    private boolean isPrimitive(ValueType type) {
        return type instanceof VoidType || type instanceof BooleanType || type instanceof NumericType;
    }

    public BasicBlock throw_(Value value) {
        BasicBlock result = super.throw_(value);
        if (value instanceof New) {
            this.connectionGraph.trackThrowNew((New)value);
        }
        return result;
    }

    public Value checkcast(Value value, Value toType, Value toDimensions, CheckCast.CastType kind, ObjectType expectedType) {
        CastValue result = (CastValue)super.checkcast(value, toType, toDimensions, kind, expectedType);
        this.connectionGraph.trackCast(result);
        return (Value)this.supports(result);
    }

    public Value bitCast(Value value, WordType toType) {
        CastValue result = (CastValue)super.bitCast(value, toType);
        this.connectionGraph.trackCast(result);
        return (Value)this.supports(result);
    }

    public Value load(ValueHandle handle, ReadAccessMode accessMode) {
        return this.supports(super.load(handle, accessMode));
    }

    public ValueHandle referenceHandle(Value reference) {
        return this.supports(super.referenceHandle(reference));
    }

    public BasicBlock if_(Value condition, BlockLabel trueTarget, BlockLabel falseTarget) {
        BasicBlock result = super.if_(condition, trueTarget, falseTarget);
        return this.supports(result.getTerminator(), result);
    }

    public Value isEq(Value v1, Value v2) {
        return this.supports(super.isEq(v1, v2));
    }

    public Value sub(Value v1, Value v2) {
        return this.supports(super.sub(v1, v2));
    }

    public Value add(Value v1, Value v2) {
        return this.supports(super.add(v1, v2));
    }

    public Value truncate(Value value, WordType toType) {
        return this.supports(super.truncate(value, toType));
    }

    public Value extend(Value value, WordType toType) {
        return this.supports(super.extend(value, toType));
    }

    public ValueHandle virtualMethodOf(Value instance, MethodElement method, MethodDescriptor callSiteDescriptor, InstanceMethodType callSiteType) {
        return this.supports(super.virtualMethodOf(instance, method, callSiteDescriptor, callSiteType));
    }

    public BasicBlock goto_(BlockLabel resumeLabel) {
        BasicBlock result = super.goto_(resumeLabel);
        return this.supports(result.getTerminator(), result);
    }

    public void finish() {
        super.finish();
        this.connectionGraph.resolveReturnedPhiValues();
        this.supportContext.process();
        List<New> supported = this.supportContext.supported.entrySet().stream().filter(e -> e.getKey() instanceof New && (Boolean)e.getValue() != false).filter(e -> this.connectionGraph.getEscapeValue((Node)e.getKey()).notGlobalEscape()).map(e -> (New)e.getKey()).toList();
        this.connectionGraph.validateNewNodes(supported);
    }

    private <T extends Node> T supports(T value) {
        this.supportContext.addType(value.getClass());
        return value;
    }

    private BasicBlock supports(Terminator terminator, BasicBlock block) {
        this.supportContext.addToQueue(terminator);
        this.supportContext.addType(terminator.getClass());
        return block;
    }

    private void handleInstanceFieldOf(InstanceFieldOf result, ValueHandle handle, Node target) {
        if (target instanceof New) {
            this.connectionGraph.fixEdgesField((New)target, handle, result);
        } else if (target instanceof ParameterValue) {
            this.connectionGraph.fixEdgesParameterValue((ParameterValue)target, result);
        } else if (target instanceof Store) {
            Value value = ((Store)target).getValue();
            if (value instanceof New) {
                this.handleInstanceFieldOf(result, handle, (Node)value);
            } else {
                this.handleInstanceFieldOf(result, handle, (Node)target.getValueHandle());
            }
        } else if (target instanceof InstanceFieldOf) {
            this.handleInstanceFieldOf(result, handle, (Node)target.getValueHandle());
        } else if (target instanceof ReferenceHandle) {
            this.handleInstanceFieldOf(result, handle, (Node)((ReferenceHandle)target).getReferenceValue());
        } else if (target instanceof OrderedNode) {
            this.handleInstanceFieldOf(result, handle, ((OrderedNode)target).getDependency());
        }
    }

    static final class SupportContext {
        final Set<Node> visited = new HashSet<Node>();
        final Map<Node, Boolean> supported = new HashMap<Node, Boolean>();
        final Set<Class<?>> types = new HashSet();
        final Queue<Terminator> terminatorQueue = new ArrayDeque<Terminator>();
        final String name;

        SupportContext(String name) {
            this.name = name;
        }

        public String toString() {
            return "SupportContext{name='" + this.name + "'}";
        }

        void addType(Class<?> type) {
            this.types.add(type);
        }

        void addToQueue(Terminator terminator) {
            this.terminatorQueue.add(terminator);
        }

        void setSupported(Node node, boolean value) {
            this.supported.put(node, value);
        }

        boolean switchToUnsupported(Node node) {
            return this.supported.replace(node, true, false);
        }

        boolean addUnsupported(Node node) {
            return this.supported.putIfAbsent(node, false) == null;
        }

        public void process() {
            Terminator terminator;
            SupportVisitor visitor = new SupportVisitor();
            while ((terminator = this.terminatorQueue.poll()) != null) {
                terminator.accept((TerminatorVisitor)visitor, (Object)this);
            }
        }
    }

    static final class SupportVisitor
    implements NodeVisitor<SupportContext, Void, Void, Void, Void> {
        SupportVisitor() {
        }

        public Void visitUnknown(SupportContext param, Action node) {
            this.visitUnknown(param, (Node)node);
            return null;
        }

        public Void visitUnknown(SupportContext param, Terminator node) {
            this.visitUnknown(param, (Node)node);
            return null;
        }

        public Void visitUnknown(SupportContext param, ValueHandle node) {
            this.visitUnknown(param, (Node)node);
            return null;
        }

        public Void visitUnknown(SupportContext param, Value node) {
            this.visitUnknown(param, (Node)node);
            return null;
        }

        void visitUnknown(SupportContext param, Node node) {
            if (param.visited.add(node)) {
                boolean isNodeSupported = this.isSupported(param, node);
                if (node.hasValueHandleDependency()) {
                    ValueHandle dependency = node.getValueHandle();
                    this.checkSupport(isNodeSupported, (Node)dependency, param);
                    dependency.accept((ValueHandleVisitor)this, (Object)param);
                }
                int cnt = node.getValueDependencyCount();
                for (int i = 0; i < cnt; ++i) {
                    Value dependency = node.getValueDependency(i);
                    this.checkSupport(isNodeSupported, (Node)dependency, param);
                    dependency.accept((ValueVisitor)this, (Object)param);
                }
                if (node instanceof OrderedNode) {
                    Node dependency = ((OrderedNode)node).getDependency();
                    this.checkSupport(isNodeSupported, dependency, param);
                    if (dependency instanceof Action) {
                        ((Action)dependency).accept((ActionVisitor)this, (Object)param);
                    } else if (dependency instanceof Value) {
                        ((Value)dependency).accept((ValueVisitor)this, (Object)param);
                    } else if (dependency instanceof Terminator) {
                        ((Terminator)dependency).accept((TerminatorVisitor)this, (Object)param);
                    } else if (dependency instanceof ValueHandle) {
                        ((ValueHandle)dependency).accept((ValueHandleVisitor)this, (Object)param);
                    }
                }
            }
        }

        private void checkSupport(boolean isSupported, Node node, SupportContext param) {
            if (!isSupported) {
                if (Boolean.TRUE.equals(param.supported.get(node))) {
                    param.switchToUnsupported(node);
                    param.visited.remove(node);
                } else {
                    param.addUnsupported(node);
                }
            }
        }

        private boolean isSupported(SupportContext param, Node node) {
            Boolean prev = param.supported.get(node);
            if (prev == null) {
                boolean supported = param.types.contains(node.getClass());
                param.setSupported(node, supported);
                return supported;
            }
            return prev;
        }
    }
}

