/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.opt.ea;

import org.qbicc.context.CompilationContext;
import org.qbicc.graph.New;
import org.qbicc.graph.Node;
import org.qbicc.graph.NodeVisitor;
import org.qbicc.plugin.dot.DotContext;
import org.qbicc.plugin.opt.ea.ConnectionGraph;
import org.qbicc.plugin.opt.ea.EscapeAnalysisState;
import org.qbicc.plugin.opt.ea.EscapeValue;

public final class EscapeAnalysisDotVisitor
implements NodeVisitor.Delegating<DotContext, String, String, String, String> {
    private final NodeVisitor<DotContext, String, String, String, String> delegate;
    private final EscapeAnalysisState escapeAnalysisState;

    public EscapeAnalysisDotVisitor(CompilationContext ctxt, NodeVisitor<DotContext, String, String, String, String> delegate) {
        this.delegate = delegate;
        this.escapeAnalysisState = EscapeAnalysisState.get(ctxt);
    }

    public NodeVisitor<DotContext, String, String, String, String> getDelegateNodeVisitor() {
        return this.delegate;
    }

    public String visit(DotContext param, New node) {
        String name = param.getName((Node)node);
        param.appendTo((Object)name);
        param.attr("style", "filled");
        param.attr("fillcolor", this.nodeType((EscapeValue)this.getConnectionGraph((DotContext)param).getEscapeValue((Node)node)).fillColor);
        param.nl();
        return name;
    }

    private ConnectionGraph getConnectionGraph(DotContext dtxt) {
        return this.escapeAnalysisState.getConnectionGraph(dtxt.getElement());
    }

    private NodeType nodeType(EscapeValue value) {
        return switch (value) {
            default -> throw new IncompatibleClassChangeError();
            case EscapeValue.GLOBAL_ESCAPE -> NodeType.GLOBAL_ESCAPE;
            case EscapeValue.ARG_ESCAPE -> NodeType.ARG_ESCAPE;
            case EscapeValue.NO_ESCAPE -> NodeType.NO_ESCAPE;
            case EscapeValue.UNKNOWN -> NodeType.UNKNOWN;
        };
    }

    private static enum NodeType {
        GLOBAL_ESCAPE("lightsalmon"),
        ARG_ESCAPE("lightcyan3"),
        NO_ESCAPE("lightblue1"),
        UNKNOWN("lightpink1");

        final String fillColor;

        private NodeType(String fillColor) {
            this.fillColor = fillColor;
        }
    }
}

