/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.opt.ea;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.qbicc.graph.Call;
import org.qbicc.graph.CastValue;
import org.qbicc.graph.InstanceFieldOf;
import org.qbicc.graph.Load;
import org.qbicc.graph.LocalVariable;
import org.qbicc.graph.New;
import org.qbicc.graph.Node;
import org.qbicc.graph.ParameterValue;
import org.qbicc.graph.PhiValue;
import org.qbicc.graph.Value;
import org.qbicc.graph.ValueHandle;
import org.qbicc.plugin.opt.ea.EscapeValue;

final class ConnectionGraph {
    private final Map<Node, Node> pointsToEdges = new HashMap<Node, Node>();
    private final Map<Node, ValueHandle> deferredEdges = new HashMap<Node, ValueHandle>();
    private final Map<Node, Collection<InstanceFieldOf>> fieldEdges = new HashMap<Node, Collection<InstanceFieldOf>>();
    private final Map<Node, EscapeValue> escapeValues = new HashMap<Node, EscapeValue>();
    private final Map<ValueHandle, New> localNewNodes = new HashMap<ValueHandle, New>();
    private final List<ParameterValue> parameters = new ArrayList<ParameterValue>();
    private final String name;

    ConnectionGraph(String name) {
        this.name = name;
    }

    public String toString() {
        return "ConnectionGraph{name='" + this.name + "'}";
    }

    void trackLocalNew(LocalVariable localHandle, New new_) {
        this.localNewNodes.put((ValueHandle)localHandle, new_);
    }

    void trackNew(New new_, EscapeValue escapeValue) {
        this.setEscapeValue((Node)new_, escapeValue);
    }

    void trackParameters(List<ParameterValue> args) {
        this.parameters.addAll(args);
    }

    void trackReturn(Value value) {
        Value localNew;
        if (value instanceof Load && (localNew = (Value)this.localNewNodes.get(value.getValueHandle())) != null) {
            this.setEscapeValue((Node)localNew, EscapeValue.ARG_ESCAPE);
            return;
        }
        this.setEscapeValue((Node)value, EscapeValue.ARG_ESCAPE);
    }

    void trackStoreStaticField(ValueHandle handle, Value value) {
        this.addPointsToEdgeIfAbsent((Node)handle, (Node)value);
        this.setEscapeValue((Node)handle, EscapeValue.GLOBAL_ESCAPE);
    }

    void trackStoreThisField(Value value) {
        this.setEscapeValue((Node)value, EscapeValue.ARG_ESCAPE);
    }

    void trackThrowNew(New value) {
        this.setEscapeValue((Node)value, EscapeValue.ARG_ESCAPE);
    }

    void trackCast(CastValue cast) {
        this.addPointsToEdgeIfAbsent((Node)cast, (Node)cast.getInput());
    }

    void fixEdgesField(New new_, ValueHandle newHandle, InstanceFieldOf instanceField) {
        this.addFieldEdgeIfAbsent(new_, instanceField);
        this.addPointsToEdgeIfAbsent((Node)newHandle, (Node)new_);
    }

    void fixEdgesNew(ValueHandle newHandle, New new_) {
        this.addPointsToEdgeIfAbsent((Node)newHandle, (Node)new_);
    }

    void fixEdgesParameterValue(ParameterValue from, InstanceFieldOf to) {
        this.addDeferredEdgeIfAbsent((Node)from, (ValueHandle)to);
    }

    EscapeValue getEscapeValue(Node node) {
        return EscapeValue.of(this.escapeValues.get(node));
    }

    Collection<InstanceFieldOf> getFields(Node node) {
        Collection<InstanceFieldOf> fields = this.fieldEdges.get(node);
        return Objects.isNull(fields) ? Collections.emptyList() : fields;
    }

    ValueHandle getDeferred(Node node) {
        return this.deferredEdges.get(node);
    }

    void updateAtMethodEntry() {
        this.parameters.forEach(arg -> this.setEscapeValue((Node)arg, EscapeValue.ARG_ESCAPE));
    }

    void updateAfterInvokingMethod(Call callee, ConnectionGraph calleeCG) {
        if (callee.getArguments().size() > calleeCG.parameters.size()) {
            return;
        }
        List arguments = callee.getArguments();
        for (int i = 0; i < arguments.size(); ++i) {
            Value outsideArg = (Value)arguments.get(i);
            ParameterValue insideArg = calleeCG.parameters.get(i);
            this.updateCallerNodes((Node)insideArg, List.of(outsideArg), calleeCG, new ArrayList<Node>());
        }
    }

    private void updateCallerNodes(Node calleeNode, Collection<Node> mapsToField, ConnectionGraph calleeCG, Collection<Node> mapsToObj) {
        for (Node calleePointed : calleeCG.getPointsTo(calleeNode, true)) {
            for (Node callerNode : mapsToField) {
                for (Node callerPointed : this.getPointsTo(callerNode, true)) {
                    if (!mapsToObj.add(calleePointed)) continue;
                    if (calleeCG.getEscapeValue(calleePointed).isGlobalEscape()) {
                        this.setEscapeValue(callerPointed, EscapeValue.GLOBAL_ESCAPE);
                    }
                    for (InstanceFieldOf calleeField : calleeCG.getFields(calleePointed)) {
                        String calleeFieldName = calleeField.getVariableElement().getName();
                        Collection callerFields = this.getFields(callerPointed).stream().filter(field -> Objects.equals(field.getVariableElement().getName(), calleeFieldName)).collect(Collectors.toList());
                        this.updateCallerNodes((Node)calleeField, callerFields, calleeCG, mapsToObj);
                    }
                }
            }
        }
    }

    void updateAtMethodExit() {
        this.bypassAllDeferredEdges(this.deferredEdges);
        this.propagateGlobalEscape();
        this.propagateArgEscapeOnly();
    }

    private void bypassAllDeferredEdges(Map<Node, ValueHandle> oldDeferredEdges) {
        if (oldDeferredEdges.isEmpty()) {
            this.deferredEdges.clear();
            return;
        }
        HashMap<Node, ValueHandle> newDeferredEdges = new HashMap<Node, ValueHandle>();
        for (ValueHandle node : oldDeferredEdges.values()) {
            ValueHandle defersTo = oldDeferredEdges.get(node);
            Node pointsTo = this.pointsToEdges.get(node);
            if (defersTo == null && pointsTo == null) continue;
            for (Map.Entry<Node, ValueHandle> incoming : oldDeferredEdges.entrySet()) {
                if (!incoming.getValue().equals(node)) continue;
                if (defersTo != null) {
                    newDeferredEdges.put(incoming.getKey(), defersTo);
                }
                if (pointsTo == null) continue;
                this.addPointsToEdgeIfAbsent(incoming.getKey(), pointsTo);
            }
        }
        this.bypassAllDeferredEdges(newDeferredEdges);
    }

    private void propagateGlobalEscape() {
        List<Node> globalEscape = this.escapeValues.entrySet().stream().filter(e -> ((EscapeValue)((Object)((Object)e.getValue()))).isGlobalEscape()).map(Map.Entry::getKey).toList();
        globalEscape.forEach(this::computeGlobalEscape);
        Map<Integer, List<ParameterValue>> indexedParameterValues = this.escapeValues.keySet().stream().filter(key -> key instanceof ParameterValue).map(key -> (ParameterValue)key).collect(Collectors.groupingBy(ParameterValue::getIndex));
        globalEscape.stream().filter(n -> n instanceof ParameterValue).map(key -> (ParameterValue)key).flatMap(pv -> ((List)indexedParameterValues.get(pv.getIndex())).stream()).forEach(pv -> this.setEscapeValue((Node)pv, EscapeValue.GLOBAL_ESCAPE));
    }

    private void computeGlobalEscape(Node from) {
        Node to = this.pointsToEdges.get(from);
        if (to != null) {
            this.setEscapeValue(to, EscapeValue.GLOBAL_ESCAPE);
            this.computeGlobalEscape(to);
        }
    }

    void propagateArgEscapeOnly() {
        List<Node> argEscapeOnly = this.escapeValues.entrySet().stream().filter(e -> ((EscapeValue)((Object)((Object)e.getValue()))).isArgEscape()).map(Map.Entry::getKey).toList();
        argEscapeOnly.forEach(this::computeArgEscapeOnly);
    }

    private void computeArgEscapeOnly(Node from) {
        Node to = this.pointsToEdges.get(from);
        if (to != null && this.getEscapeValue(to).notGlobalEscape()) {
            this.setEscapeValue(to, EscapeValue.ARG_ESCAPE);
            this.computeArgEscapeOnly(to);
        }
    }

    Collection<Node> getPointsTo(Node node, boolean includeSef) {
        Node pointsTo = this.pointsToEdges.get(node);
        return pointsTo != null ? (includeSef ? List.of(node, pointsTo) : List.of(pointsTo)) : (includeSef ? List.of(node) : List.of());
    }

    ConnectionGraph union(ConnectionGraph other) {
        if (Objects.nonNull(other)) {
            this.pointsToEdges.putAll(other.pointsToEdges);
            this.deferredEdges.putAll(other.deferredEdges);
            this.fieldEdges.putAll(other.fieldEdges);
            Map<Node, EscapeValue> mergedEscapeValues = this.mergeEscapeValues(other);
            this.escapeValues.clear();
            this.escapeValues.putAll(mergedEscapeValues);
            this.localNewNodes.putAll(other.localNewNodes);
            this.parameters.addAll(other.parameters);
        }
        return this;
    }

    void resolveReturnedPhiValues() {
        List<Value> possibleNewValues = this.escapeValues.entrySet().stream().filter(entry -> entry.getKey() instanceof PhiValue && ((EscapeValue)((Object)((Object)entry.getValue()))).isArgEscape()).flatMap(entry -> ((PhiValue)entry.getKey()).getPossibleValues().stream()).filter(value -> value instanceof New && this.getEscapeValue((Node)value).isNoEscape()).toList();
        possibleNewValues.forEach(value -> this.setEscapeValue((Node)value, EscapeValue.ARG_ESCAPE));
    }

    void validateNewNodes(List<New> supported) {
        List<Node> unsupportedNewNodes = this.escapeValues.entrySet().stream().filter(e -> e.getKey() instanceof New && ((EscapeValue)((Object)((Object)e.getValue()))).notGlobalEscape()).filter(e -> !supported.contains(e.getKey())).map(Map.Entry::getKey).toList();
        unsupportedNewNodes.forEach(node -> this.setEscapeValue((Node)node, EscapeValue.GLOBAL_ESCAPE));
    }

    private Map<Node, EscapeValue> mergeEscapeValues(ConnectionGraph other) {
        HashMap<Node, EscapeValue> result = new HashMap<Node, EscapeValue>(this.escapeValues);
        other.escapeValues.forEach((key, value) -> result.merge((Node)key, (EscapeValue)((Object)value), EscapeValue::merge));
        return result;
    }

    private boolean addFieldEdgeIfAbsent(New from, InstanceFieldOf to) {
        return this.fieldEdges.computeIfAbsent((Node)from, obj -> new ArrayList()).add(to);
    }

    private boolean addPointsToEdgeIfAbsent(Node from, Node to) {
        return this.pointsToEdges.putIfAbsent(from, to) == null;
    }

    private boolean addDeferredEdgeIfAbsent(Node from, ValueHandle to) {
        return this.deferredEdges.putIfAbsent(from, to) == null;
    }

    private boolean setEscapeValue(Node node, EscapeValue escapeValue) {
        EscapeValue prev = this.escapeValues.get(node);
        if (prev == null || prev != EscapeValue.merge(prev, escapeValue)) {
            this.escapeValues.put(node, escapeValue);
            return true;
        }
        return false;
    }
}

