/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.opt;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.qbicc.context.CompilationContext;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.BlockEntry;
import org.qbicc.graph.Goto;
import org.qbicc.graph.If;
import org.qbicc.graph.Node;
import org.qbicc.graph.NodeVisitor;
import org.qbicc.graph.PhiValue;
import org.qbicc.graph.Terminator;
import org.qbicc.graph.Value;
import org.qbicc.graph.ValueHandle;

public class GotoRemovingVisitor
implements NodeVisitor.Delegating<Node.Copier, Value, Node, BasicBlock, ValueHandle> {
    private final CompilationContext context;
    private final NodeVisitor<Node.Copier, Value, Node, BasicBlock, ValueHandle> delegate;
    private final Set<BasicBlock> deleted = new HashSet<BasicBlock>();

    public GotoRemovingVisitor(CompilationContext context, NodeVisitor<Node.Copier, Value, Node, BasicBlock, ValueHandle> delegate) {
        this.context = context;
        this.delegate = delegate;
    }

    public NodeVisitor<Node.Copier, Value, Node, BasicBlock, ValueHandle> getDelegateNodeVisitor() {
        return this.delegate;
    }

    public BasicBlock visit(Node.Copier param, Goto node) {
        BasicBlock target = node.getResumeTarget();
        if (target.getIncoming().size() == 1 && Objects.equals(node.getCallSite(), target.getTerminator().getCallSite())) {
            this.deleted.add(target);
            param.copyNode(node.getDependency());
            return param.copyTerminator(target.getTerminator());
        }
        return (BasicBlock)this.getDelegateTerminatorVisitor().visit((Object)param, node);
    }

    public BasicBlock visit(Node.Copier param, If node) {
        Terminator terminator = node.getTrueBranch().getTerminator();
        if (terminator instanceof Goto) {
            Goto g1 = (Goto)terminator;
            terminator = node.getFalseBranch().getTerminator();
            if (terminator instanceof Goto) {
                Goto g2 = (Goto)terminator;
                if (g1.getResumeTarget() == g2.getResumeTarget() && g1.getDependency() instanceof BlockEntry && g2.getDependency() instanceof BlockEntry && node.getTrueBranch().getIncoming().size() == 1 && node.getFalseBranch().getIncoming().size() == 1 && g1.getResumeTarget().getIncoming().size() == 2 && Objects.equals(node.getCallSite(), g1.getResumeTarget().getTerminator().getCallSite()) && Objects.equals(node.getCallSite(), g2.getResumeTarget().getTerminator().getCallSite())) {
                    BasicBlock tb = node.getTrueBranch();
                    BasicBlock successor = tb.getTerminator().getSuccessor(0);
                    this.deleted.add(successor);
                    param.copyNode(node.getDependency());
                    return param.copyTerminator(successor.getTerminator());
                }
            }
        }
        return (BasicBlock)this.getDelegateTerminatorVisitor().visit((Object)param, node);
    }

    public Value visit(Node.Copier param, PhiValue node) {
        BasicBlock pinnedBlock = node.getPinnedBlock();
        Set incoming = pinnedBlock.getIncoming();
        boolean delete = this.deleted.contains(pinnedBlock);
        if (incoming.size() == 2 && delete) {
            If if_ = (If)((BasicBlock)((BasicBlock)incoming.iterator().next()).getIncoming().iterator().next()).getTerminator();
            Value trueValue = param.copyValue(node.getValueForInput(if_.getTrueBranch().getTerminator()));
            Value falseValue = param.copyValue(node.getValueForInput(if_.getFalseBranch().getTerminator()));
            return param.getBlockBuilder().select(param.copyValue(if_.getCondition()), trueValue, falseValue);
        }
        if (delete) {
            assert (incoming.size() == 1);
            return param.copyValue(node.getValueForInput(((BasicBlock)incoming.iterator().next()).getTerminator()));
        }
        return (Value)this.getDelegateValueVisitor().visit((Object)param, node);
    }

    public Node visit(Node.Copier param, BlockEntry node) {
        BasicBlock block = node.getPinnedBlock();
        if (this.deleted.contains(block)) {
            if (block.getIncoming().size() == 2) {
                return param.copyNode(((BasicBlock)((BasicBlock)block.getIncoming().iterator().next()).getIncoming().iterator().next()).getTerminator().getDependency());
            }
            return param.copyNode(((BasicBlock)block.getIncoming().iterator().next()).getTerminator().getDependency());
        }
        return (Node)this.getDelegateActionVisitor().visit((Object)param, node);
    }
}

