/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.opt.ea;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.qbicc.graph.New;
import org.qbicc.graph.Node;
import org.qbicc.graph.NodeVisitor;
import org.qbicc.plugin.dot.DotGenerationContext;
import org.qbicc.plugin.opt.ea.ConnectionGraph;
import org.qbicc.plugin.opt.ea.EscapeAnalysisState;
import org.qbicc.plugin.opt.ea.EscapeValue;

public final class EscapeAnalysisDotVisitor
implements NodeVisitor.Delegating<Appendable, String, String, String, String> {
    private final DotGenerationContext dtxt;
    private final NodeVisitor<Appendable, String, String, String, String> delegate;
    private final ConnectionGraph connectionGraph;
    private boolean attr;
    private boolean commaNeeded;

    public EscapeAnalysisDotVisitor(DotGenerationContext dtxt, NodeVisitor<Appendable, String, String, String, String> delegate) {
        this.dtxt = dtxt;
        this.delegate = delegate;
        this.connectionGraph = EscapeAnalysisState.get(dtxt.ctxt).getConnectionGraph(dtxt.element);
    }

    public NodeVisitor<Appendable, String, String, String, String> getDelegateNodeVisitor() {
        return this.delegate;
    }

    public String visit(Appendable param, New node) {
        String name = (String)this.dtxt.visited.get(node);
        EscapeAnalysisDotVisitor.appendTo(param, name);
        this.attr(param, "style", "filled");
        this.attr(param, "fillcolor", this.nodeType((EscapeValue)this.connectionGraph.getEscapeValue((Node)node)).fillColor);
        this.nl(param);
        return name;
    }

    private NodeType nodeType(EscapeValue value) {
        return switch (value) {
            default -> throw new IncompatibleClassChangeError();
            case EscapeValue.GLOBAL_ESCAPE -> NodeType.GLOBAL_ESCAPE;
            case EscapeValue.ARG_ESCAPE -> NodeType.ARG_ESCAPE;
            case EscapeValue.NO_ESCAPE -> NodeType.NO_ESCAPE;
            case EscapeValue.UNKNOWN -> NodeType.UNKNOWN;
        };
    }

    private void attr(Appendable param, String name, String val) {
        if (!this.attr) {
            this.attr = true;
            EscapeAnalysisDotVisitor.appendTo(param, " [");
        }
        if (this.commaNeeded) {
            EscapeAnalysisDotVisitor.appendTo(param, Character.valueOf(','));
        } else {
            this.commaNeeded = true;
        }
        EscapeAnalysisDotVisitor.appendTo(param, name);
        EscapeAnalysisDotVisitor.appendTo(param, Character.valueOf('='));
        EscapeAnalysisDotVisitor.quote(param, val);
    }

    static void quote(Appendable output, String orig) {
        int cp;
        EscapeAnalysisDotVisitor.appendTo(output, Character.valueOf('\"'));
        for (int i = 0; i < orig.length(); i += Character.charCount(cp)) {
            cp = orig.codePointAt(i);
            if (cp == 34) {
                EscapeAnalysisDotVisitor.appendTo(output, Character.valueOf('\\'));
            } else if (cp == 92 && (i + 1 == orig.length() || "nlrGNTHE".indexOf(orig.codePointAt(i + 1)) == -1)) {
                EscapeAnalysisDotVisitor.appendTo(output, Character.valueOf('\\'));
            }
            if (Character.charCount(cp) == 1) {
                EscapeAnalysisDotVisitor.appendTo(output, Character.valueOf((char)cp));
                continue;
            }
            EscapeAnalysisDotVisitor.appendTo(output, Character.valueOf(Character.highSurrogate(cp)));
            EscapeAnalysisDotVisitor.appendTo(output, Character.valueOf(Character.lowSurrogate(cp)));
        }
        EscapeAnalysisDotVisitor.appendTo(output, Character.valueOf('\"'));
    }

    private void nl(Appendable param) {
        if (this.attr) {
            EscapeAnalysisDotVisitor.appendTo(param, Character.valueOf(']'));
            this.attr = false;
            this.commaNeeded = false;
        }
        EscapeAnalysisDotVisitor.appendTo(param, System.lineSeparator());
    }

    static void appendTo(Appendable param, Object obj) {
        try {
            param.append(obj.toString());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static enum NodeType {
        GLOBAL_ESCAPE("lightsalmon"),
        ARG_ESCAPE("lightcyan3"),
        NO_ESCAPE("lightblue1"),
        UNKNOWN("lightpink1");

        final String fillColor;

        private NodeType(String fillColor) {
            this.fillColor = fillColor;
        }
    }
}

