/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.opt.ea;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.qbicc.graph.Action;
import org.qbicc.graph.ActionVisitor;
import org.qbicc.graph.Add;
import org.qbicc.graph.AddressOf;
import org.qbicc.graph.And;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.BinaryValue;
import org.qbicc.graph.BitCast;
import org.qbicc.graph.BlockEntry;
import org.qbicc.graph.Call;
import org.qbicc.graph.CallNoReturn;
import org.qbicc.graph.CallNoSideEffects;
import org.qbicc.graph.CastValue;
import org.qbicc.graph.CheckCast;
import org.qbicc.graph.ClassOf;
import org.qbicc.graph.Cmp;
import org.qbicc.graph.CmpAndSwap;
import org.qbicc.graph.CmpG;
import org.qbicc.graph.CmpL;
import org.qbicc.graph.Comp;
import org.qbicc.graph.ConstructorElementHandle;
import org.qbicc.graph.Convert;
import org.qbicc.graph.CountLeadingZeros;
import org.qbicc.graph.CountTrailingZeros;
import org.qbicc.graph.DebugAddressDeclaration;
import org.qbicc.graph.Div;
import org.qbicc.graph.ElementOf;
import org.qbicc.graph.ExactMethodElementHandle;
import org.qbicc.graph.Extend;
import org.qbicc.graph.ExtractElement;
import org.qbicc.graph.ExtractInstanceField;
import org.qbicc.graph.ExtractMember;
import org.qbicc.graph.Fence;
import org.qbicc.graph.FunctionElementHandle;
import org.qbicc.graph.GetAndAdd;
import org.qbicc.graph.GetAndBitwiseAnd;
import org.qbicc.graph.GetAndBitwiseNand;
import org.qbicc.graph.GetAndBitwiseOr;
import org.qbicc.graph.GetAndBitwiseXor;
import org.qbicc.graph.GetAndSet;
import org.qbicc.graph.GetAndSetMax;
import org.qbicc.graph.GetAndSetMin;
import org.qbicc.graph.GetAndSub;
import org.qbicc.graph.GlobalVariable;
import org.qbicc.graph.Goto;
import org.qbicc.graph.If;
import org.qbicc.graph.InitCheck;
import org.qbicc.graph.InsertElement;
import org.qbicc.graph.InsertMember;
import org.qbicc.graph.InstanceFieldOf;
import org.qbicc.graph.InstanceOf;
import org.qbicc.graph.InterfaceMethodElementHandle;
import org.qbicc.graph.Invoke;
import org.qbicc.graph.InvokeNoReturn;
import org.qbicc.graph.IsEq;
import org.qbicc.graph.IsGe;
import org.qbicc.graph.IsGt;
import org.qbicc.graph.IsLe;
import org.qbicc.graph.IsLt;
import org.qbicc.graph.IsNe;
import org.qbicc.graph.Jsr;
import org.qbicc.graph.Load;
import org.qbicc.graph.LocalVariable;
import org.qbicc.graph.Max;
import org.qbicc.graph.MemberOf;
import org.qbicc.graph.Min;
import org.qbicc.graph.Mod;
import org.qbicc.graph.MonitorEnter;
import org.qbicc.graph.MonitorExit;
import org.qbicc.graph.MultiNewArray;
import org.qbicc.graph.Multiply;
import org.qbicc.graph.Neg;
import org.qbicc.graph.New;
import org.qbicc.graph.NewArray;
import org.qbicc.graph.NewReferenceArray;
import org.qbicc.graph.Node;
import org.qbicc.graph.NodeVisitor;
import org.qbicc.graph.NotNull;
import org.qbicc.graph.OffsetOfField;
import org.qbicc.graph.Or;
import org.qbicc.graph.OrderedNode;
import org.qbicc.graph.ParameterValue;
import org.qbicc.graph.PhiValue;
import org.qbicc.graph.PointerHandle;
import org.qbicc.graph.ReadModifyWriteValue;
import org.qbicc.graph.ReferenceHandle;
import org.qbicc.graph.Ret;
import org.qbicc.graph.Return;
import org.qbicc.graph.Rol;
import org.qbicc.graph.Ror;
import org.qbicc.graph.Select;
import org.qbicc.graph.Shl;
import org.qbicc.graph.Shr;
import org.qbicc.graph.StackAllocation;
import org.qbicc.graph.StaticField;
import org.qbicc.graph.StaticMethodElementHandle;
import org.qbicc.graph.Store;
import org.qbicc.graph.Sub;
import org.qbicc.graph.Switch;
import org.qbicc.graph.TailCall;
import org.qbicc.graph.TailInvoke;
import org.qbicc.graph.Terminator;
import org.qbicc.graph.TerminatorVisitor;
import org.qbicc.graph.Throw;
import org.qbicc.graph.Truncate;
import org.qbicc.graph.UnaryValue;
import org.qbicc.graph.Unreachable;
import org.qbicc.graph.Value;
import org.qbicc.graph.ValueHandle;
import org.qbicc.graph.ValueHandleVisitor;
import org.qbicc.graph.ValueReturn;
import org.qbicc.graph.ValueVisitor;
import org.qbicc.graph.VirtualMethodElementHandle;
import org.qbicc.graph.Xor;
import org.qbicc.graph.literal.BitCastLiteral;
import org.qbicc.graph.literal.BlockLiteral;
import org.qbicc.graph.literal.BooleanLiteral;
import org.qbicc.graph.literal.ConstantLiteral;
import org.qbicc.graph.literal.FloatLiteral;
import org.qbicc.graph.literal.IntegerLiteral;
import org.qbicc.graph.literal.MethodHandleLiteral;
import org.qbicc.graph.literal.NullLiteral;
import org.qbicc.graph.literal.ObjectLiteral;
import org.qbicc.graph.literal.ProgramObjectLiteral;
import org.qbicc.graph.literal.StringLiteral;
import org.qbicc.graph.literal.TypeLiteral;
import org.qbicc.graph.literal.UndefinedLiteral;
import org.qbicc.graph.literal.ZeroInitializerLiteral;
import org.qbicc.plugin.opt.ea.ConnectionGraph;
import org.qbicc.plugin.opt.ea.EscapeValue;
import org.qbicc.plugin.opt.ea.TooBigException;

public class ConnectionGraphDotVisitor
implements NodeVisitor<Appendable, String, String, String, String> {
    private final ConnectionGraph connectionGraph;
    final BasicBlock entryBlock;
    final Map<Node, String> visited = new HashMap<Node, String>();
    private final Set<BasicBlock> blockQueued = ConcurrentHashMap.newKeySet();
    private final Queue<BasicBlock> blockQueue = new ArrayDeque<BasicBlock>();
    int depth;
    int counter;
    int bbCounter;
    boolean attr;
    boolean commaNeeded;

    public ConnectionGraphDotVisitor(BasicBlock entryBlock, ConnectionGraph connectionGraph) {
        this.entryBlock = entryBlock;
        this.connectionGraph = connectionGraph;
    }

    public String visitUnknown(Appendable param, Value node) {
        throw new IllegalStateException("Visitor for node " + node.getClass() + " is not implemented");
    }

    public String visit(Appendable param, BlockEntry node) {
        return this.register((Node)node);
    }

    public String visit(Appendable param, Cmp node) {
        return this.bypass(param, (BinaryValue)node);
    }

    public String visit(Appendable param, CmpAndSwap node) {
        String name = this.register((Node)node);
        this.processDependency(param, (Node)node.getExpectedValue());
        this.processDependency(param, (Node)node.getUpdateValue());
        return name;
    }

    public String visit(Appendable param, CmpL node) {
        return this.bypass(param, (BinaryValue)node);
    }

    public String visit(Appendable param, CmpG node) {
        return this.bypass(param, (BinaryValue)node);
    }

    public String visit(Appendable param, ElementOf node) {
        String name = this.register((Node)node);
        this.processDependency(param, (Node)node.getValueHandle());
        this.processDependency(param, (Node)node.getIndex());
        return name;
    }

    public String visit(Appendable param, GlobalVariable node) {
        return this.register((Node)node);
    }

    public String visit(Appendable param, InstanceFieldOf node) {
        String name = this.register((Node)node);
        ConnectionGraphDotVisitor.appendTo(param, name);
        this.attr(param, "label", "field access\\n" + node.getVariableElement().getName());
        this.attr(param, "style", "filled");
        this.attr(param, "fillcolor", String.valueOf(this.nodeType((EscapeValue)this.connectionGraph.getEscapeValue((Node)node)).fillColor));
        this.nl(param);
        Collection<Node> pointsTo = this.connectionGraph.getPointsTo((Node)node, false);
        for (Node pointsToNode : pointsTo) {
            String valueName = this.getNodeName(param, pointsToNode);
            this.addEdge(param, name, valueName, EdgeType.POINTS_TO);
        }
        this.processDependency(param, (Node)node.getValueHandle());
        return name;
    }

    public String visit(Appendable param, MemberOf node) {
        String name = this.register((Node)node);
        this.processDependency(param, (Node)node.getValueHandle());
        return name;
    }

    public String visit(Appendable param, MonitorEnter node) {
        String name = this.bypass(param, (OrderedNode)node);
        this.processDependency(param, (Node)node.getInstance());
        return name;
    }

    public String visit(Appendable param, MonitorExit node) {
        String name = this.bypass(param, (OrderedNode)node);
        this.processDependency(param, (Node)node.getInstance());
        return name;
    }

    public String visit(Appendable param, PointerHandle node) {
        String name = this.register((Node)node);
        this.processDependency(param, (Node)node.getPointerValue());
        return name;
    }

    public String visit(Appendable param, ReferenceHandle node) {
        String name = this.register((Node)node);
        this.processDependency(param, (Node)node.getReferenceValue());
        return name;
    }

    public String visit(Appendable param, StaticField node) {
        String name = this.register((Node)node);
        ConnectionGraphDotVisitor.appendTo(param, name);
        this.nl(param);
        this.attr(param, "label", "static field\\n" + node.getVariableElement().toString());
        this.attr(param, "style", "filled");
        this.attr(param, "fillcolor", String.valueOf(this.nodeType((EscapeValue)this.connectionGraph.getEscapeValue((Node)node)).fillColor));
        this.nl(param);
        Collection<Node> pointsTo = this.connectionGraph.getPointsTo((Node)node, false);
        for (Node pointsToNode : pointsTo) {
            String valueName = this.getNodeName(param, pointsToNode);
            this.addEdge(param, name, valueName, EdgeType.POINTS_TO);
        }
        return name;
    }

    public String visit(Appendable param, ConstructorElementHandle node) {
        String name = this.register((Node)node);
        this.processDependency(param, (Node)node.getInstance());
        return name;
    }

    public String visit(Appendable param, ExactMethodElementHandle node) {
        String name = this.register((Node)node);
        this.processDependency(param, (Node)node.getInstance());
        return name;
    }

    public String visit(Appendable param, FunctionElementHandle node) {
        return this.register((Node)node);
    }

    public String visit(Appendable param, InterfaceMethodElementHandle node) {
        String name = this.register((Node)node);
        this.processDependency(param, (Node)node.getInstance());
        return name;
    }

    public String visit(Appendable param, VirtualMethodElementHandle node) {
        String name = this.register((Node)node);
        this.processDependency(param, (Node)node.getInstance());
        return name;
    }

    public String visit(Appendable param, LocalVariable node) {
        return this.register((Node)node);
    }

    public String visit(Appendable param, StaticMethodElementHandle node) {
        return this.register((Node)node);
    }

    public String visit(Appendable param, CallNoReturn node) {
        String name = this.register((Node)node);
        this.processDependency(param, node.getDependency());
        this.processDependency(param, (Node)node.getValueHandle());
        for (Value arg : node.getArguments()) {
            this.processDependency(param, (Node)arg);
        }
        ConnectionGraphDotVisitor.appendTo(param, "}");
        this.nl(param);
        return name;
    }

    public String visit(Appendable param, Invoke node) {
        String name = this.register((Node)node);
        this.processDependency(param, node.getDependency());
        this.processDependency(param, (Node)node.getValueHandle());
        for (Value arg : node.getArguments()) {
            this.processDependency(param, (Node)arg);
        }
        ConnectionGraphDotVisitor.appendTo(param, "}");
        this.nl(param);
        this.addToQueue(node.getCatchBlock());
        this.addToQueue(node.getResumeTarget());
        return name;
    }

    public String visit(Appendable param, InvokeNoReturn node) {
        String name = this.register((Node)node);
        this.processDependency(param, node.getDependency());
        this.processDependency(param, (Node)node.getValueHandle());
        for (Value arg : node.getArguments()) {
            this.processDependency(param, (Node)arg);
        }
        ConnectionGraphDotVisitor.appendTo(param, "}");
        this.nl(param);
        this.addToQueue(node.getCatchBlock());
        return name;
    }

    public String visit(Appendable param, TailCall node) {
        String name = this.register((Node)node);
        this.processDependency(param, node.getDependency());
        this.processDependency(param, (Node)node.getValueHandle());
        for (Value arg : node.getArguments()) {
            this.processDependency(param, (Node)arg);
        }
        ConnectionGraphDotVisitor.appendTo(param, "}");
        this.nl(param);
        return name;
    }

    public String visit(Appendable param, TailInvoke node) {
        String name = this.register((Node)node);
        this.processDependency(param, node.getDependency());
        this.processDependency(param, (Node)node.getValueHandle());
        for (Value arg : node.getArguments()) {
            this.processDependency(param, (Node)arg);
        }
        ConnectionGraphDotVisitor.appendTo(param, "}");
        this.nl(param);
        this.addToQueue(node.getCatchBlock());
        return name;
    }

    public String visit(Appendable param, Goto node) {
        String name = this.register((Node)node);
        this.processDependency(param, node.getDependency());
        ConnectionGraphDotVisitor.appendTo(param, "}");
        this.nl(param);
        this.addToQueue(node.getResumeTarget());
        return name;
    }

    public String visit(Appendable param, If node) {
        String name = this.register((Node)node);
        this.processDependency(param, node.getDependency());
        this.processDependency(param, (Node)node.getCondition());
        ConnectionGraphDotVisitor.appendTo(param, "}");
        this.nl(param);
        this.addToQueue(node.getTrueBranch());
        this.addToQueue(node.getFalseBranch());
        return name;
    }

    public String visit(Appendable param, Jsr node) {
        return this.bypassTerminator(param, (OrderedNode)node);
    }

    public String visit(Appendable param, Ret node) {
        return this.bypassTerminator(param, (OrderedNode)node);
    }

    public String visit(Appendable param, Return node) {
        return this.bypassTerminator(param, (OrderedNode)node);
    }

    public String visit(Appendable param, Invoke.ReturnValue node) {
        this.processDependency(param, (Node)node.getInvoke());
        return this.visited.get(node.getInvoke());
    }

    public String visit(Appendable param, Unreachable node) {
        return this.bypassTerminator(param, (OrderedNode)node);
    }

    public String visit(Appendable param, Switch node) {
        String name = this.register((Node)node);
        this.processDependency(param, node.getDependency());
        ConnectionGraphDotVisitor.appendTo(param, "}");
        this.nl(param);
        int cnt = node.getNumberOfValues();
        for (int i = 0; i < cnt; ++i) {
            this.addToQueue(node.getTargetForIndex(i));
        }
        return name;
    }

    public String visit(Appendable param, Throw node) {
        String name = this.register((Node)node);
        this.processDependency(param, node.getDependency());
        this.processDependency(param, (Node)node.getThrownValue());
        ConnectionGraphDotVisitor.appendTo(param, "}");
        this.nl(param);
        return name;
    }

    public String visit(Appendable param, ValueReturn node) {
        String name = this.register((Node)node);
        this.processDependency(param, node.getDependency());
        this.processDependency(param, (Node)node.getReturnValue());
        ConnectionGraphDotVisitor.appendTo(param, "}");
        this.nl(param);
        return name;
    }

    public String visit(Appendable param, InitCheck node) {
        return this.bypass(param, (OrderedNode)node);
    }

    public String visit(Appendable param, DebugAddressDeclaration node) {
        String name = this.register((Node)node);
        this.processDependency(param, (Node)node.getAddress());
        this.processDependency(param, node.getDependency());
        return name;
    }

    public String visit(Appendable param, Add node) {
        return this.bypass(param, (BinaryValue)node);
    }

    public String visit(Appendable param, AddressOf node) {
        String name = this.register((Node)node);
        this.processDependency(param, (Node)node.getValueHandle());
        return name;
    }

    public String visit(Appendable param, And node) {
        return this.bypass(param, (BinaryValue)node);
    }

    public String visit(Appendable param, BitCast node) {
        return this.bypass(param, (CastValue)node);
    }

    public String visit(Appendable param, BitCastLiteral node) {
        return this.register((Node)node);
    }

    public String visit(Appendable param, BlockLiteral node) {
        String name = this.register((Node)node);
        this.processDependency(param, (Node)node.getBlock().getBlockEntry());
        return name;
    }

    public String visit(Appendable param, BooleanLiteral node) {
        return this.register((Node)node);
    }

    public String visit(Appendable param, Call node) {
        String name = this.register((Node)node);
        ConnectionGraphDotVisitor.appendTo(param, name);
        this.attr(param, "label", "call\\n" + node.getValueHandle().toString());
        this.attr(param, "style", "filled");
        this.attr(param, "fillcolor", String.valueOf(this.nodeType((EscapeValue)this.connectionGraph.getEscapeValue((Node)node)).fillColor));
        this.nl(param);
        this.processDependency(param, node.getDependency());
        this.processDependency(param, (Node)node.getValueHandle());
        for (Value arg : node.getArguments()) {
            this.processDependency(param, (Node)arg);
        }
        return name;
    }

    public String visit(Appendable param, CallNoSideEffects node) {
        String name = this.register((Node)node);
        this.processDependency(param, (Node)node.getValueHandle());
        for (Value arg : node.getArguments()) {
            this.processDependency(param, (Node)arg);
        }
        return name;
    }

    public String visit(Appendable param, ClassOf node) {
        String name = this.register((Node)node);
        this.processDependency(param, (Node)node.getInput());
        return name;
    }

    public String visit(Appendable param, Comp node) {
        return this.bypass(param, (UnaryValue)node);
    }

    public String visit(Appendable param, CountLeadingZeros node) {
        return this.bypass(param, (UnaryValue)node);
    }

    public String visit(Appendable param, CountTrailingZeros node) {
        return this.bypass(param, (UnaryValue)node);
    }

    public String visit(Appendable param, Convert node) {
        return this.bypass(param, (CastValue)node);
    }

    public String visit(Appendable param, Div node) {
        return this.bypass(param, (BinaryValue)node);
    }

    public String visit(Appendable param, Extend node) {
        return this.bypass(param, (CastValue)node);
    }

    public String visit(Appendable param, ExtractElement node) {
        String name = this.register((Node)node);
        this.processDependency(param, (Node)node.getIndex());
        this.processDependency(param, (Node)node.getArrayValue());
        return name;
    }

    public String visit(Appendable param, ExtractInstanceField node) {
        String name = this.register((Node)node);
        this.processDependency(param, (Node)node.getObjectValue());
        return name;
    }

    public String visit(Appendable param, ExtractMember node) {
        String name = this.register((Node)node);
        this.processDependency(param, (Node)node.getCompoundValue());
        return name;
    }

    public String visit(Appendable param, Fence node) {
        return this.bypass(param, (OrderedNode)node);
    }

    public String visit(Appendable param, FloatLiteral node) {
        return this.register((Node)node);
    }

    private String node(Appendable param, ReadModifyWriteValue node) {
        String name = this.register((Node)node);
        if (node instanceof OrderedNode) {
            OrderedNode on = (OrderedNode)node;
            this.processDependency(param, on.getDependency());
        }
        this.processDependency(param, (Node)node.getValueHandle());
        this.processDependency(param, (Node)node.getUpdateValue());
        return name;
    }

    public String visit(Appendable param, GetAndAdd node) {
        return this.node(param, (ReadModifyWriteValue)node);
    }

    public String visit(Appendable param, GetAndSet node) {
        return this.node(param, (ReadModifyWriteValue)node);
    }

    public String visit(Appendable param, GetAndBitwiseAnd node) {
        return this.node(param, (ReadModifyWriteValue)node);
    }

    public String visit(Appendable param, GetAndBitwiseNand node) {
        return this.node(param, (ReadModifyWriteValue)node);
    }

    public String visit(Appendable param, GetAndBitwiseOr node) {
        return this.node(param, (ReadModifyWriteValue)node);
    }

    public String visit(Appendable param, GetAndBitwiseXor node) {
        return this.node(param, (ReadModifyWriteValue)node);
    }

    public String visit(Appendable param, GetAndSetMax node) {
        return this.node(param, (ReadModifyWriteValue)node);
    }

    public String visit(Appendable param, GetAndSetMin node) {
        return this.node(param, (ReadModifyWriteValue)node);
    }

    public String visit(Appendable param, GetAndSub node) {
        return this.node(param, (ReadModifyWriteValue)node);
    }

    public String visit(Appendable param, InsertElement node) {
        String name = this.register((Node)node);
        this.processDependency(param, (Node)node.getIndex());
        this.processDependency(param, (Node)node.getInsertedValue());
        this.processDependency(param, (Node)node.getArrayValue());
        return name;
    }

    public String visit(Appendable param, InsertMember node) {
        String name = this.register((Node)node);
        this.processDependency(param, (Node)node.getInsertedValue());
        this.processDependency(param, (Node)node.getCompoundValue());
        return name;
    }

    public String visit(Appendable param, InstanceOf node) {
        String name = this.bypass(param, (OrderedNode)node);
        this.processDependency(param, (Node)node.getInstance());
        return name;
    }

    public String visit(Appendable param, IntegerLiteral node) {
        return this.register((Node)node);
    }

    public String visit(Appendable param, IsEq node) {
        return this.bypass(param, (BinaryValue)node);
    }

    public String visit(Appendable param, IsGe node) {
        return this.bypass(param, (BinaryValue)node);
    }

    public String visit(Appendable param, IsGt node) {
        return this.bypass(param, (BinaryValue)node);
    }

    public String visit(Appendable param, IsLe node) {
        return this.bypass(param, (BinaryValue)node);
    }

    public String visit(Appendable param, IsLt node) {
        return this.bypass(param, (BinaryValue)node);
    }

    public String visit(Appendable param, IsNe node) {
        return this.bypass(param, (BinaryValue)node);
    }

    public String visit(Appendable param, Load node) {
        String name = this.bypass(param, (OrderedNode)node);
        this.processDependency(param, (Node)node.getValueHandle());
        return name;
    }

    public String visit(Appendable param, MethodHandleLiteral node) {
        return this.register((Node)node);
    }

    public String visit(Appendable param, Max node) {
        return this.bypass(param, (BinaryValue)node);
    }

    public String visit(Appendable param, Min node) {
        return this.bypass(param, (BinaryValue)node);
    }

    public String visit(Appendable param, Mod node) {
        return this.bypass(param, (BinaryValue)node);
    }

    public String visit(Appendable param, MultiNewArray node) {
        String name = this.bypass(param, (OrderedNode)node);
        for (Value dimension : node.getDimensions()) {
            this.processDependency(param, (Node)dimension);
        }
        return name;
    }

    public String visit(Appendable param, Multiply node) {
        return this.bypass(param, (BinaryValue)node);
    }

    public String visit(Appendable param, OffsetOfField node) {
        return this.register((Node)node);
    }

    public String visit(Appendable param, CheckCast node) {
        String name = this.register((Node)node);
        ConnectionGraphDotVisitor.appendTo(param, name);
        this.attr(param, "label", node.getKind() + "\u2192" + node.getType().toString());
        this.attr(param, "style", "filled");
        this.attr(param, "fillcolor", String.valueOf(this.nodeType((EscapeValue)this.connectionGraph.getEscapeValue((Node)node)).fillColor));
        this.nl(param);
        Collection<Node> pointsTo = this.connectionGraph.getPointsTo((Node)node, false);
        for (Node pointedTo : pointsTo) {
            String pointedToName = this.getNodeName(param, pointedTo);
            this.addEdge(param, name, pointedToName, EdgeType.POINTS_TO);
        }
        this.processDependency(param, node.getDependency());
        this.processDependency(param, (Node)node.getInput());
        this.processDependency(param, (Node)node.getToType());
        this.processDependency(param, (Node)node.getToDimensions());
        return name;
    }

    public String visit(Appendable param, ConstantLiteral node) {
        return this.register((Node)node);
    }

    public String visit(Appendable param, Neg node) {
        return this.bypass(param, (UnaryValue)node);
    }

    public String visit(Appendable param, New node) {
        String name = this.register((Node)node);
        ConnectionGraphDotVisitor.appendTo(param, name);
        this.attr(param, "label", "new\\n" + this.show(node));
        this.attr(param, "style", "filled");
        this.attr(param, "fillcolor", String.valueOf(this.nodeType((EscapeValue)this.connectionGraph.getEscapeValue((Node)node)).fillColor));
        this.nl(param);
        Collection<InstanceFieldOf> fields = this.connectionGraph.getFields((Node)node);
        for (InstanceFieldOf field : fields) {
            String fieldName = this.getNodeName(param, (ValueHandle)field);
            this.addEdge(param, name, fieldName, EdgeType.FIELD);
        }
        return name;
    }

    private String show(New node) {
        return node.getType().getUpperBound().toString();
    }

    public String visit(Appendable param, NewArray node) {
        String name = this.bypass(param, (OrderedNode)node);
        this.processDependency(param, (Node)node.getSize());
        return name;
    }

    public String visit(Appendable param, NewReferenceArray node) {
        String name = this.bypass(param, (OrderedNode)node);
        this.processDependency(param, (Node)node.getElemTypeId());
        this.processDependency(param, (Node)node.getDimensions());
        this.processDependency(param, (Node)node.getSize());
        return name;
    }

    public String visit(Appendable param, NotNull node) {
        return this.bypass(param, (UnaryValue)node);
    }

    public String visit(Appendable param, NullLiteral node) {
        return this.register((Node)node);
    }

    public String visit(Appendable param, ZeroInitializerLiteral node) {
        return this.register((Node)node);
    }

    public String visit(Appendable param, ObjectLiteral node) {
        return this.register((Node)node);
    }

    public String visit(Appendable param, Or node) {
        return this.bypass(param, (BinaryValue)node);
    }

    public String visit(Appendable param, ParameterValue node) {
        String name = this.register((Node)node);
        ConnectionGraphDotVisitor.appendTo(param, name);
        int index = node.getIndex();
        StringBuilder b = new StringBuilder();
        b.append(node.getType()).append(' ').append("param").append('[').append(node.getLabel());
        if (index > 0) {
            b.append(index);
        }
        b.append(']');
        this.attr(param, "label", b.toString());
        this.attr(param, "style", "filled");
        this.attr(param, "fillcolor", String.valueOf(this.nodeType((EscapeValue)this.connectionGraph.getEscapeValue((Node)node)).fillColor));
        this.nl(param);
        ValueHandle deferred = this.connectionGraph.getDeferred((Node)node);
        if (deferred != null) {
            String deferredName = this.getNodeName(param, deferred);
            this.addEdge(param, name, deferredName, EdgeType.DEFERRED);
        } else {
            Collection<Node> pointsTo = this.connectionGraph.getPointsTo((Node)node, false);
            for (Node pointedTo : pointsTo) {
                String pointedToName = this.getNodeName(param, pointedTo);
                this.addEdge(param, name, pointedToName, EdgeType.POINTS_TO);
            }
        }
        return name;
    }

    public String visit(Appendable param, PhiValue node) {
        String name = this.register((Node)node);
        ConnectionGraphDotVisitor.appendTo(param, name);
        this.attr(param, "label", "phi");
        this.attr(param, "style", "filled");
        this.attr(param, "fillcolor", String.valueOf(this.nodeType((EscapeValue)this.connectionGraph.getEscapeValue((Node)node)).fillColor));
        this.nl(param);
        return name;
    }

    public String visit(Appendable param, Rol node) {
        return this.bypass(param, (BinaryValue)node);
    }

    public String visit(Appendable param, Ror node) {
        return this.bypass(param, (BinaryValue)node);
    }

    public String visit(Appendable param, Select node) {
        String name = this.register((Node)node);
        this.processDependency(param, (Node)node.getCondition());
        this.processDependency(param, (Node)node.getTrueValue());
        this.processDependency(param, (Node)node.getFalseValue());
        return name;
    }

    public String visit(Appendable param, Shl node) {
        return this.bypass(param, (BinaryValue)node);
    }

    public String visit(Appendable param, Shr node) {
        return this.bypass(param, (BinaryValue)node);
    }

    public String visit(Appendable param, StackAllocation node) {
        String name = this.bypass(param, (OrderedNode)node);
        this.processDependency(param, (Node)node.getCount());
        return name;
    }

    public String visit(Appendable param, Store node) {
        String name = this.bypass(param, (OrderedNode)node);
        this.processDependency(param, (Node)node.getValueHandle());
        this.processDependency(param, (Node)node.getValue());
        return name;
    }

    public String visit(Appendable param, StringLiteral node) {
        return this.register((Node)node);
    }

    public String visit(Appendable param, ProgramObjectLiteral node) {
        return this.register((Node)node);
    }

    public String visit(Appendable param, Sub node) {
        return this.bypass(param, (BinaryValue)node);
    }

    public String visit(Appendable param, Truncate node) {
        return this.bypass(param, (CastValue)node);
    }

    public String visit(Appendable param, TypeLiteral node) {
        return this.register((Node)node);
    }

    public String visit(Appendable param, UndefinedLiteral node) {
        return this.register((Node)node);
    }

    public String visit(Appendable param, Xor node) {
        return this.bypass(param, (BinaryValue)node);
    }

    private void addEdge(Appendable param, String fromName, String toName, EdgeType edge) {
        ConnectionGraphDotVisitor.appendTo(param, fromName);
        ConnectionGraphDotVisitor.appendTo(param, " -> ");
        ConnectionGraphDotVisitor.appendTo(param, toName);
        this.attr(param, "style", edge.style);
        this.attr(param, "color", edge.color);
        this.attr(param, "label", " " + edge.label);
        this.nl(param);
    }

    private String bypass(Appendable param, BinaryValue node) {
        String name = this.register((Node)node);
        this.processDependency(param, (Node)node.getLeftInput());
        this.processDependency(param, (Node)node.getRightInput());
        return name;
    }

    private String bypass(Appendable param, OrderedNode node) {
        String name = this.register((Node)node);
        this.processDependency(param, node.getDependency());
        return name;
    }

    private String bypass(Appendable param, CastValue node) {
        String name = this.register((Node)node);
        this.processDependency(param, (Node)node.getInput());
        return name;
    }

    private String bypass(Appendable param, UnaryValue node) {
        String name = this.register((Node)node);
        this.processDependency(param, (Node)node.getInput());
        return name;
    }

    private String bypassTerminator(Appendable param, OrderedNode node) {
        String name = this.register((Node)node);
        this.processDependency(param, node.getDependency());
        ConnectionGraphDotVisitor.appendTo(param, "}");
        this.nl(param);
        return name;
    }

    void processDependency(Appendable param, Node node) {
        if (this.depth++ > 500) {
            throw new TooBigException();
        }
        try {
            this.getNodeName(param, node);
        }
        finally {
            --this.depth;
        }
    }

    private String getNodeName(Appendable param, Node node) {
        if (node instanceof Value) {
            return this.getNodeName(param, (Value)node);
        }
        if (node instanceof ValueHandle) {
            return this.getNodeName(param, (ValueHandle)node);
        }
        if (node instanceof Action) {
            return this.getNodeName(param, (Action)node);
        }
        assert (node instanceof Terminator);
        return this.getNodeName(param, (Terminator)node);
    }

    private String getNodeName(Appendable param, Action node) {
        String name = this.visited.get(node);
        if (name == null) {
            name = (String)node.accept((ActionVisitor)this, (Object)param);
        }
        return name;
    }

    private String getNodeName(Appendable param, Value node) {
        String name = this.visited.get(node);
        if (name == null) {
            name = (String)node.accept((ValueVisitor)this, (Object)param);
        }
        return name;
    }

    private String getNodeName(Appendable param, ValueHandle node) {
        String name = this.visited.get(node);
        if (name == null) {
            name = (String)node.accept((ValueHandleVisitor)this, (Object)param);
        }
        return name;
    }

    private String getNodeName(Appendable param, Terminator node) {
        String name = this.visited.get(node);
        if (name == null) {
            name = (String)node.accept((TerminatorVisitor)this, (Object)param);
        }
        return name;
    }

    private void attr(Appendable param, String name, String val) {
        if (!this.attr) {
            this.attr = true;
            ConnectionGraphDotVisitor.appendTo(param, " [");
        }
        if (this.commaNeeded) {
            ConnectionGraphDotVisitor.appendTo(param, Character.valueOf(','));
        } else {
            this.commaNeeded = true;
        }
        ConnectionGraphDotVisitor.appendTo(param, name);
        ConnectionGraphDotVisitor.appendTo(param, Character.valueOf('='));
        this.quote(param, val);
    }

    void quote(Appendable output, String orig) {
        int cp;
        ConnectionGraphDotVisitor.appendTo(output, Character.valueOf('\"'));
        for (int i = 0; i < orig.length(); i += Character.charCount(cp)) {
            cp = orig.codePointAt(i);
            if (cp == 34) {
                ConnectionGraphDotVisitor.appendTo(output, Character.valueOf('\\'));
            } else if (cp == 92 && (i + 1 == orig.length() || "nlrGNTHE".indexOf(orig.codePointAt(i + 1)) == -1)) {
                ConnectionGraphDotVisitor.appendTo(output, Character.valueOf('\\'));
            }
            if (Character.charCount(cp) == 1) {
                ConnectionGraphDotVisitor.appendTo(output, Character.valueOf((char)cp));
                continue;
            }
            ConnectionGraphDotVisitor.appendTo(output, Character.valueOf(Character.highSurrogate(cp)));
            ConnectionGraphDotVisitor.appendTo(output, Character.valueOf(Character.lowSurrogate(cp)));
        }
        ConnectionGraphDotVisitor.appendTo(output, Character.valueOf('\"'));
    }

    private String register(Node node) {
        String name = this.nextName();
        this.visited.put(node, name);
        return name;
    }

    private String nextName() {
        return "n" + this.counter++;
    }

    public void process(Appendable param) {
        BasicBlock block;
        this.addToQueue(this.entryBlock);
        while ((block = this.blockQueue.poll()) != null) {
            String bbName = this.nextBBName();
            ConnectionGraphDotVisitor.appendTo(param, "subgraph cluster_" + bbName + " {");
            this.nl(param);
            ConnectionGraphDotVisitor.appendTo(param, "label = \"" + bbName + "\";");
            this.nl(param);
            this.getNodeName(param, block.getTerminator());
        }
    }

    private void nl(Appendable param) {
        if (this.attr) {
            ConnectionGraphDotVisitor.appendTo(param, Character.valueOf(']'));
            this.attr = false;
            this.commaNeeded = false;
        }
        ConnectionGraphDotVisitor.appendTo(param, System.lineSeparator());
    }

    static void appendTo(Appendable param, Object obj) {
        try {
            param.append(obj.toString());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    void addToQueue(BasicBlock block) {
        if (this.blockQueued.add(block)) {
            this.blockQueue.add(block);
        }
    }

    private String nextBBName() {
        return "b" + this.bbCounter++;
    }

    private NodeType nodeType(EscapeValue value) {
        switch (value) {
            case GLOBAL_ESCAPE: {
                return NodeType.GLOBAL_ESCAPE;
            }
            case ARG_ESCAPE: {
                return NodeType.ARG_ESCAPE;
            }
            case NO_ESCAPE: {
                return NodeType.NO_ESCAPE;
            }
            case UNKNOWN: {
                return NodeType.UNKNOWN;
            }
        }
        throw new IllegalStateException("Unknown escape value: " + value);
    }

    private static enum NodeType {
        GLOBAL_ESCAPE(2),
        ARG_ESCAPE(3),
        NO_ESCAPE(1),
        UNKNOWN(4);

        final int fillColor;

        private NodeType(int fillColor) {
            this.fillColor = fillColor;
        }
    }

    private static enum EdgeType {
        DEFERRED("black", "dashed"),
        POINTS_TO("black", "solid"),
        FIELD("black", "solid");

        final String color;
        final String style;
        final char label;

        private EdgeType(String color, String style) {
            this.color = color;
            this.style = style;
            this.label = this.toString().charAt(0);
        }
    }
}

