/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.opt;

import java.util.List;
import java.util.function.Function;
import org.qbicc.context.CompilationContext;
import org.qbicc.graph.Add;
import org.qbicc.graph.And;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.BitCast;
import org.qbicc.graph.BlockEarlyTermination;
import org.qbicc.graph.BlockLabel;
import org.qbicc.graph.Call;
import org.qbicc.graph.CallNoReturn;
import org.qbicc.graph.CallNoSideEffects;
import org.qbicc.graph.ConstructorElementHandle;
import org.qbicc.graph.Convert;
import org.qbicc.graph.DelegatingBasicBlockBuilder;
import org.qbicc.graph.Div;
import org.qbicc.graph.ExactMethodElementHandle;
import org.qbicc.graph.Extend;
import org.qbicc.graph.FunctionElementHandle;
import org.qbicc.graph.If;
import org.qbicc.graph.Invoke;
import org.qbicc.graph.InvokeNoReturn;
import org.qbicc.graph.IsEq;
import org.qbicc.graph.IsGe;
import org.qbicc.graph.IsGt;
import org.qbicc.graph.IsLe;
import org.qbicc.graph.IsLt;
import org.qbicc.graph.IsNe;
import org.qbicc.graph.Mod;
import org.qbicc.graph.Multiply;
import org.qbicc.graph.Neg;
import org.qbicc.graph.Node;
import org.qbicc.graph.NodeVisitor;
import org.qbicc.graph.Or;
import org.qbicc.graph.ParameterValue;
import org.qbicc.graph.PhiValue;
import org.qbicc.graph.Return;
import org.qbicc.graph.Rol;
import org.qbicc.graph.Ror;
import org.qbicc.graph.Shl;
import org.qbicc.graph.Shr;
import org.qbicc.graph.StaticMethodElementHandle;
import org.qbicc.graph.Sub;
import org.qbicc.graph.Switch;
import org.qbicc.graph.TailCall;
import org.qbicc.graph.TailInvoke;
import org.qbicc.graph.Terminator;
import org.qbicc.graph.Truncate;
import org.qbicc.graph.Value;
import org.qbicc.graph.ValueHandle;
import org.qbicc.graph.ValueHandleVisitor;
import org.qbicc.graph.ValueReturn;
import org.qbicc.graph.Xor;
import org.qbicc.object.DataDeclaration;
import org.qbicc.object.FunctionDeclaration;
import org.qbicc.object.ProgramModule;
import org.qbicc.object.ProgramObject;
import org.qbicc.object.Section;
import org.qbicc.type.definition.MethodBody;
import org.qbicc.type.definition.element.Element;
import org.qbicc.type.definition.element.ExecutableElement;
import org.qbicc.type.definition.element.FunctionElement;

public class InliningBasicBlockBuilder
extends DelegatingBasicBlockBuilder
implements ValueHandleVisitor<Void, ExecutableElement> {
    private final CompilationContext ctxt;
    private final float costThreshold = 80.0f;
    private float cost;

    public InliningBasicBlockBuilder(CompilationContext ctxt, BasicBlockBuilder delegate) {
        super(delegate);
        this.ctxt = ctxt;
    }

    public Value call(ValueHandle target, List<Value> arguments) {
        PhiValue returnVal;
        BlockLabel resumeLabel;
        BasicBlock inlined;
        ExecutableElement toInline = this.getInlinedElement(target);
        if (toInline != null && (inlined = this.doInline(target, toInline, arguments, null, arg_0 -> this.lambda$call$0(resumeLabel = new BlockLabel(), returnVal = this.phi(toInline.getType().getReturnType(), resumeLabel, new PhiValue.Flag[0]), toInline, arg_0), () -> this.begin(resumeLabel))) != null) {
            return returnVal;
        }
        return super.call(target, arguments);
    }

    public Value callNoSideEffects(ValueHandle target, List<Value> arguments) {
        PhiValue returnVal;
        BlockLabel resumeLabel;
        BasicBlock inlined;
        ExecutableElement toInline = this.getInlinedElement(target);
        if (toInline != null && (inlined = this.doInline(target, toInline, arguments, null, arg_0 -> this.lambda$callNoSideEffects$2(resumeLabel = new BlockLabel(), returnVal = this.phi(toInline.getType().getReturnType(), resumeLabel, new PhiValue.Flag[0]), toInline, arg_0), () -> this.begin(resumeLabel))) != null) {
            return returnVal;
        }
        return super.callNoSideEffects(target, arguments);
    }

    public BasicBlock callNoReturn(ValueHandle target, List<Value> arguments) {
        BasicBlock inlined;
        ExecutableElement toInline = this.getInlinedElement(target);
        if (toInline != null && (inlined = this.doInline(target, toInline, arguments, null, val -> {
            this.ctxt.error(this.getLocation(), "Invalid return from noreturn method", new Object[0]);
            throw new BlockEarlyTermination(this.unreachable());
        }, () -> {})) != null) {
            return inlined;
        }
        return super.callNoReturn(target, arguments);
    }

    public BasicBlock invokeNoReturn(ValueHandle target, List<Value> arguments, BlockLabel catchLabel) {
        BasicBlock inlined;
        ExecutableElement toInline = this.getInlinedElement(target);
        if (toInline != null && (inlined = this.doInline(target, toInline, arguments, catchLabel, val -> {
            this.ctxt.error(this.getLocation(), "Invalid return from noreturn method", new Object[0]);
            throw new BlockEarlyTermination(this.unreachable());
        }, () -> {})) != null) {
            return inlined;
        }
        return super.invokeNoReturn(target, arguments, catchLabel);
    }

    public BasicBlock tailCall(ValueHandle target, List<Value> arguments) {
        BasicBlock inlined;
        ExecutableElement toInline = this.getInlinedElement(target);
        if (toInline != null && (inlined = this.doInline(target, toInline, arguments, null, arg_0 -> ((InliningBasicBlockBuilder)this).return_(arg_0), () -> {})) != null) {
            return inlined;
        }
        return super.tailCall(target, arguments);
    }

    public BasicBlock tailInvoke(ValueHandle target, List<Value> arguments, BlockLabel catchLabel) {
        BasicBlock inlined;
        ExecutableElement toInline = this.getInlinedElement(target);
        if (toInline != null && (inlined = this.doInline(target, toInline, arguments, catchLabel, arg_0 -> ((InliningBasicBlockBuilder)this).return_(arg_0), () -> {})) != null) {
            return inlined;
        }
        return super.tailInvoke(target, arguments, catchLabel);
    }

    public Value invoke(ValueHandle target, List<Value> arguments, BlockLabel catchLabel, BlockLabel resumeLabel) {
        PhiValue returnVal;
        BasicBlock inlined;
        ExecutableElement toInline = this.getInlinedElement(target);
        if (toInline != null && (inlined = this.doInline(target, toInline, arguments, catchLabel, arg_0 -> this.lambda$invoke$10(resumeLabel, returnVal = this.phi(toInline.getType().getReturnType(), resumeLabel, new PhiValue.Flag[0]), toInline, arg_0), () -> {})) != null) {
            return returnVal;
        }
        return super.invoke(target, arguments, catchLabel, resumeLabel);
    }

    private ExecutableElement getInlinedElement(ValueHandle target) {
        ExecutableElement element = (ExecutableElement)target.accept((ValueHandleVisitor)this, null);
        if (element != null && element.hasNoModifiersOf(0x200000)) {
            return element;
        }
        return null;
    }

    public ExecutableElement visitUnknown(Void param, ValueHandle node) {
        return null;
    }

    public ExecutableElement visit(Void param, FunctionElementHandle node) {
        return this.getCurrentElement() instanceof FunctionElement ? node.getExecutable() : null;
    }

    public ExecutableElement visit(Void param, ConstructorElementHandle node) {
        return this.getCurrentElement() instanceof FunctionElement ? null : node.getExecutable();
    }

    public ExecutableElement visit(Void param, ExactMethodElementHandle node) {
        return this.getCurrentElement() instanceof FunctionElement ? null : node.getExecutable();
    }

    public ExecutableElement visit(Void param, StaticMethodElementHandle node) {
        return this.getCurrentElement() instanceof FunctionElement ? null : node.getExecutable();
    }

    private BasicBlock doInline(ValueHandle target, ExecutableElement element, List<Value> arguments, BlockLabel catchLabel, Function<Value, BasicBlock> onReturn, Runnable andThen) {
        MethodBody body = element.getPreviousMethodBody();
        if (body != null) {
            float savedCost = this.cost;
            boolean alwaysInline = element.hasAllModifiersOf(0x100000);
            BlockLabel inlined = new BlockLabel();
            BasicBlock fromBlock = this.goto_(inlined);
            Terminator callSite = fromBlock.getTerminator();
            Node oldCallSite = this.setCallSite((Node)callSite);
            try {
                BasicBlock copied;
                try {
                    copied = Node.Copier.execute((BasicBlock)body.getEntryBlock(), (BasicBlockBuilder)this.getFirstBuilder(), (CompilationContext)this.ctxt, (ctxt, visitor) -> new Visitor((NodeVisitor<Node.Copier, Value, Node, BasicBlock, ValueHandle>)visitor, arguments, target, onReturn, catchLabel, alwaysInline));
                }
                catch (BlockEarlyTermination e) {
                    copied = e.getTerminatedBlock();
                }
                this.copyDeclarations(element);
                inlined.setTarget(copied);
                this.setCallSite(oldCallSite);
                andThen.run();
                return fromBlock;
            }
            catch (Cancel ignored) {
                this.cost = savedCost;
                this.setCallSite(oldCallSite);
                this.begin(inlined);
                return null;
            }
        }
        return null;
    }

    private void copyDeclarations(ExecutableElement target) {
        ProgramModule ourModule = this.ctxt.getOrAddProgramModule(this.getRootElement().getEnclosingType());
        ProgramModule module = this.ctxt.getOrAddProgramModule(target.getEnclosingType());
        for (Section section : module.sections()) {
            for (ProgramObject object : section.contents()) {
                if (object instanceof FunctionDeclaration) {
                    FunctionDeclaration declaration = (FunctionDeclaration)object;
                    ourModule.getOrAddSection(section.getName()).declareFunction(declaration);
                    continue;
                }
                if (!(object instanceof DataDeclaration)) continue;
                DataDeclaration declaration = (DataDeclaration)object;
                ourModule.getOrAddSection(section.getName()).declareData(declaration);
            }
        }
    }

    private /* synthetic */ BasicBlock lambda$invoke$10(BlockLabel resumeLabel, PhiValue returnVal, ExecutableElement toInline, Value val) {
        BasicBlock basicBlock = this.goto_(resumeLabel);
        returnVal.setValueForBlock(this.ctxt, (Element)toInline, basicBlock, val);
        return basicBlock;
    }

    private /* synthetic */ BasicBlock lambda$callNoSideEffects$2(BlockLabel resumeLabel, PhiValue returnVal, ExecutableElement toInline, Value val) {
        BasicBlock basicBlock = this.goto_(resumeLabel);
        returnVal.setValueForBlock(this.ctxt, (Element)toInline, basicBlock, val);
        return basicBlock;
    }

    private /* synthetic */ BasicBlock lambda$call$0(BlockLabel resumeLabel, PhiValue returnVal, ExecutableElement toInline, Value val) {
        BasicBlock basicBlock = this.goto_(resumeLabel);
        returnVal.setValueForBlock(this.ctxt, (Element)toInline, basicBlock, val);
        return basicBlock;
    }

    static final class Cancel
    extends RuntimeException {
        Cancel() {
            super(null, null, false, false);
        }
    }

    final class Visitor
    implements NodeVisitor.Delegating<Node.Copier, Value, Node, BasicBlock, ValueHandle> {
        private final NodeVisitor<Node.Copier, Value, Node, BasicBlock, ValueHandle> delegate;
        private final List<Value> arguments;
        private final Value this_;
        private final Function<Value, BasicBlock> onReturn;
        private final BlockLabel catchLabel;
        private final boolean alwaysInline;

        Visitor(NodeVisitor<Node.Copier, Value, Node, BasicBlock, ValueHandle> delegate, BlockLabel resume, PhiValue returnValue, List<Value> arguments, Value this_, boolean alwaysInline) {
            this(delegate, arguments, this_, (Value val) -> {
                BasicBlock basicBlock = this$0.goto_(resume);
                returnValue.setValueForBlock(org$qbicc$plugin$opt$InliningBasicBlockBuilder$this.ctxt, (Element)this$0.getCurrentElement(), basicBlock, val);
                return basicBlock;
            }, null, alwaysInline);
        }

        Visitor(NodeVisitor<Node.Copier, Value, Node, BasicBlock, ValueHandle> delegate, List<Value> arguments, ValueHandle target, Function<Value, BasicBlock> onReturn, BlockLabel catchLabel, boolean alwaysInline) {
            this(delegate, arguments, target.hasValueHandleDependency() ? this$0.referenceTo(target.getValueHandle()) : null, onReturn, catchLabel, alwaysInline);
        }

        Visitor(NodeVisitor<Node.Copier, Value, Node, BasicBlock, ValueHandle> delegate, List<Value> arguments, Value this_, Function<Value, BasicBlock> onReturn, BlockLabel catchLabel, boolean alwaysInline) {
            this.delegate = delegate;
            this.arguments = arguments;
            this.this_ = this_;
            this.onReturn = onReturn;
            this.catchLabel = catchLabel;
            this.alwaysInline = alwaysInline;
        }

        public NodeVisitor<Node.Copier, Value, Node, BasicBlock, ValueHandle> getDelegateNodeVisitor() {
            return this.delegate;
        }

        public BasicBlock visit(Node.Copier param, Return node) {
            param.copyNode(node.getDependency());
            return this.onReturn.apply(null);
        }

        public BasicBlock visit(Node.Copier param, ValueReturn node) {
            try {
                param.copyNode(node.getDependency());
                return this.onReturn.apply(param.copyValue(node.getReturnValue()));
            }
            catch (BlockEarlyTermination e) {
                return e.getTerminatedBlock();
            }
        }

        public Value visit(Node.Copier param, ParameterValue node) {
            if (node.getLabel().equals("this")) {
                return this.this_;
            }
            return this.arguments.get(node.getIndex());
        }

        public Value visit(Node.Copier param, Add node) {
            this.addCost(param, 1);
            return (Value)this.delegate.visit((Object)param, node);
        }

        public Value visit(Node.Copier param, And node) {
            this.addCost(param, 1);
            return (Value)this.delegate.visit((Object)param, node);
        }

        public Value visit(Node.Copier param, Div node) {
            this.addCost(param, 1);
            return (Value)this.delegate.visit((Object)param, node);
        }

        public Value visit(Node.Copier param, Mod node) {
            this.addCost(param, 1);
            return (Value)this.delegate.visit((Object)param, node);
        }

        public Value visit(Node.Copier param, Multiply node) {
            this.addCost(param, 1);
            return (Value)this.delegate.visit((Object)param, node);
        }

        public Value visit(Node.Copier param, Neg node) {
            this.addCost(param, 1);
            return (Value)this.delegate.visit((Object)param, node);
        }

        public Value visit(Node.Copier param, Or node) {
            this.addCost(param, 1);
            return (Value)this.delegate.visit((Object)param, node);
        }

        public Value visit(Node.Copier param, Sub node) {
            this.addCost(param, 1);
            return (Value)this.delegate.visit((Object)param, node);
        }

        public Value visit(Node.Copier param, Xor node) {
            this.addCost(param, 1);
            return (Value)this.delegate.visit((Object)param, node);
        }

        public Value visit(Node.Copier param, IsEq node) {
            this.addCost(param, 1);
            return (Value)this.delegate.visit((Object)param, node);
        }

        public Value visit(Node.Copier param, IsGe node) {
            this.addCost(param, 1);
            return (Value)this.delegate.visit((Object)param, node);
        }

        public Value visit(Node.Copier param, IsGt node) {
            this.addCost(param, 1);
            return (Value)this.delegate.visit((Object)param, node);
        }

        public Value visit(Node.Copier param, IsLe node) {
            this.addCost(param, 1);
            return (Value)this.delegate.visit((Object)param, node);
        }

        public Value visit(Node.Copier param, IsLt node) {
            this.addCost(param, 1);
            return (Value)this.delegate.visit((Object)param, node);
        }

        public Value visit(Node.Copier param, IsNe node) {
            this.addCost(param, 1);
            return (Value)this.delegate.visit((Object)param, node);
        }

        public Value visit(Node.Copier param, BitCast node) {
            this.addCost(param, 1);
            return (Value)this.delegate.visit((Object)param, node);
        }

        public Value visit(Node.Copier param, Convert node) {
            this.addCost(param, 1);
            return (Value)this.delegate.visit((Object)param, node);
        }

        public Value visit(Node.Copier param, Extend node) {
            this.addCost(param, 1);
            return (Value)this.delegate.visit((Object)param, node);
        }

        public Value visit(Node.Copier param, Truncate node) {
            this.addCost(param, 1);
            return (Value)this.delegate.visit((Object)param, node);
        }

        public Value visit(Node.Copier param, Rol node) {
            this.addCost(param, 1);
            return (Value)this.delegate.visit((Object)param, node);
        }

        public Value visit(Node.Copier param, Ror node) {
            this.addCost(param, 1);
            return (Value)this.delegate.visit((Object)param, node);
        }

        public Value visit(Node.Copier param, Shl node) {
            this.addCost(param, 1);
            return (Value)this.delegate.visit((Object)param, node);
        }

        public Value visit(Node.Copier param, Shr node) {
            this.addCost(param, 1);
            return (Value)this.delegate.visit((Object)param, node);
        }

        public BasicBlock visit(Node.Copier param, If node) {
            this.addCost(param, 4);
            return (BasicBlock)this.delegate.visit((Object)param, node);
        }

        public BasicBlock visit(Node.Copier param, Switch node) {
            this.addCost(param, 2 * (node.getNumberOfValues() + 1));
            return (BasicBlock)this.delegate.visit((Object)param, node);
        }

        public Value visit(Node.Copier param, Call node) {
            this.addCost(param, 10);
            if (this.catchLabel != null) {
                param.copyNode(node.getDependency());
                BlockLabel resume = new BlockLabel();
                Value result = InliningBasicBlockBuilder.this.invoke(param.copyValueHandle(node.getValueHandle()), param.copyValues(this.arguments), this.catchLabel, resume);
                InliningBasicBlockBuilder.this.begin(resume);
                return result;
            }
            return (Value)this.delegate.visit((Object)param, node);
        }

        public Value visit(Node.Copier param, CallNoSideEffects node) {
            this.addCost(param, 10);
            if (this.catchLabel != null) {
                BlockLabel resume = new BlockLabel();
                Value result = InliningBasicBlockBuilder.this.invoke(param.copyValueHandle(node.getValueHandle()), param.copyValues(this.arguments), this.catchLabel, resume);
                InliningBasicBlockBuilder.this.begin(resume);
                return result;
            }
            return (Value)this.delegate.visit((Object)param, node);
        }

        public BasicBlock visit(Node.Copier param, CallNoReturn node) {
            this.addCost(param, 10);
            if (this.catchLabel != null) {
                param.copyNode(node.getDependency());
                return InliningBasicBlockBuilder.this.invokeNoReturn(param.copyValueHandle(node.getValueHandle()), param.copyValues(this.arguments), this.catchLabel);
            }
            return (BasicBlock)this.delegate.visit((Object)param, node);
        }

        public BasicBlock visit(Node.Copier param, TailCall node) {
            this.addCost(param, 10);
            if (this.catchLabel != null) {
                param.copyNode(node.getDependency());
                return InliningBasicBlockBuilder.this.tailInvoke(param.copyValueHandle(node.getValueHandle()), param.copyValues(this.arguments), this.catchLabel);
            }
            return (BasicBlock)this.delegate.visit((Object)param, node);
        }

        public BasicBlock visit(Node.Copier param, Invoke node) {
            this.addCost(param, 10);
            return (BasicBlock)this.delegate.visit((Object)param, node);
        }

        public BasicBlock visit(Node.Copier param, InvokeNoReturn node) {
            this.addCost(param, 10);
            return (BasicBlock)this.delegate.visit((Object)param, node);
        }

        public BasicBlock visit(Node.Copier param, TailInvoke node) {
            this.addCost(param, 10);
            return (BasicBlock)this.delegate.visit((Object)param, node);
        }

        void addCost(Node.Copier copier, int amount) {
            if (!this.alwaysInline) {
                float cost = InliningBasicBlockBuilder.this.cost + (float)amount;
                if (cost >= 80.0f) {
                    try {
                        copier.getBlockBuilder().unreachable();
                    }
                    catch (IllegalStateException | BlockEarlyTermination throwable) {
                        // empty catch block
                    }
                    throw new Cancel();
                }
                InliningBasicBlockBuilder.this.cost = cost;
            }
        }
    }
}

