/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.opt;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.qbicc.context.CompilationContext;
import org.qbicc.graph.AddressOf;
import org.qbicc.graph.And;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.BitCast;
import org.qbicc.graph.BlockLabel;
import org.qbicc.graph.Cmp;
import org.qbicc.graph.Comp;
import org.qbicc.graph.Convert;
import org.qbicc.graph.DelegatingBasicBlockBuilder;
import org.qbicc.graph.Extend;
import org.qbicc.graph.Neg;
import org.qbicc.graph.PointerHandle;
import org.qbicc.graph.Truncate;
import org.qbicc.graph.Value;
import org.qbicc.graph.ValueHandle;
import org.qbicc.graph.WordCastValue;
import org.qbicc.graph.literal.ArrayLiteral;
import org.qbicc.graph.literal.BooleanLiteral;
import org.qbicc.graph.literal.CompoundLiteral;
import org.qbicc.graph.literal.FloatLiteral;
import org.qbicc.graph.literal.IntegerLiteral;
import org.qbicc.graph.literal.Literal;
import org.qbicc.graph.literal.LiteralFactory;
import org.qbicc.graph.literal.NullLiteral;
import org.qbicc.type.ArrayType;
import org.qbicc.type.BooleanType;
import org.qbicc.type.CompoundType;
import org.qbicc.type.FloatType;
import org.qbicc.type.IntegerType;
import org.qbicc.type.NullableType;
import org.qbicc.type.PointerType;
import org.qbicc.type.ReferenceType;
import org.qbicc.type.ValueType;
import org.qbicc.type.WordType;

public class SimpleOptBasicBlockBuilder
extends DelegatingBasicBlockBuilder {
    private final CompilationContext ctxt;

    public SimpleOptBasicBlockBuilder(CompilationContext ctxt, BasicBlockBuilder delegate) {
        super(delegate);
        this.ctxt = ctxt;
    }

    public Value extractElement(Value array, Value index) {
        Value value = array.extractElement(this.ctxt.getLiteralFactory(), index);
        if (value != null) {
            return value;
        }
        return super.extractElement(array, index);
    }

    public Value extractMember(Value compound, CompoundType.Member member) {
        Value value = compound.extractMember(this.ctxt.getLiteralFactory(), member);
        if (value != null) {
            return value;
        }
        return super.extractMember(compound, member);
    }

    public Value insertElement(Value array, Value index, Value value) {
        if (array instanceof ArrayLiteral) {
            ArrayLiteral al = (ArrayLiteral)array;
            if (index instanceof IntegerLiteral) {
                IntegerLiteral il = (IntegerLiteral)index;
                if (value instanceof Literal) {
                    Literal lit = (Literal)value;
                    LiteralFactory lf = this.ctxt.getLiteralFactory();
                    Literal[] values = (Literal[])al.getValues().toArray(Literal[]::new);
                    values[il.intValue()] = lit;
                    return lf.literalOf(al.getType(), List.of(values));
                }
            }
        }
        return super.insertElement(array, index, value);
    }

    public Value insertMember(Value compound, CompoundType.Member member, Value value) {
        if (compound instanceof CompoundLiteral) {
            CompoundLiteral cl = (CompoundLiteral)compound;
            if (value instanceof Literal) {
                Literal lit = (Literal)value;
                LiteralFactory lf = this.ctxt.getLiteralFactory();
                Map values = cl.getValues();
                HashMap<CompoundType.Member, Literal> copy = new HashMap<CompoundType.Member, Literal>(values);
                copy.put(member, lit);
                return lf.literalOf(cl.getType(), Map.copyOf(copy));
            }
        }
        return super.insertMember(compound, member, value);
    }

    private Value literalCast(Value value, WordType toType, boolean truncate) {
        if (value instanceof IntegerLiteral) {
            if (toType instanceof IntegerType) {
                return this.ctxt.getLiteralFactory().literalOf((IntegerType)toType, ((IntegerLiteral)value).longValue());
            }
            if (toType instanceof BooleanType) {
                long longValue = ((IntegerLiteral)value).longValue();
                return this.ctxt.getLiteralFactory().literalOf((truncate ? longValue & 1L : longValue) != 0L);
            }
            if (toType instanceof FloatType) {
                return this.ctxt.getLiteralFactory().literalOf((FloatType)toType, (double)((IntegerLiteral)value).longValue());
            }
        } else if (value instanceof FloatLiteral) {
            if (toType instanceof IntegerType) {
                return this.ctxt.getLiteralFactory().literalOf((IntegerType)toType, (long)((FloatLiteral)value).doubleValue());
            }
            if (toType instanceof FloatType) {
                return this.ctxt.getLiteralFactory().literalOf((FloatType)toType, ((FloatLiteral)value).doubleValue());
            }
            if (toType instanceof BooleanType) {
                assert (truncate);
                return this.ctxt.getLiteralFactory().literalOf(((long)((FloatLiteral)value).doubleValue() & 1L) != 0L);
            }
        } else if (value instanceof BooleanLiteral && toType instanceof IntegerType) {
            return this.ctxt.getLiteralFactory().literalOf((IntegerType)toType, ((BooleanLiteral)value).booleanValue() ? 1L : 0L);
        }
        return null;
    }

    public Value truncate(Value value, WordType toType) {
        Value result = this.literalCast(value, toType, true);
        if (result != null) {
            return result;
        }
        if (value instanceof Truncate) {
            Truncate trunc = (Truncate)value;
            return this.truncate(trunc.getInput(), toType);
        }
        return super.truncate(value, toType);
    }

    public Value extend(Value value, WordType toType) {
        Value result = this.literalCast(value, toType, false);
        return result != null ? result : super.extend(value, toType);
    }

    public Value complement(Value v) {
        if (v instanceof Comp) {
            Comp c = (Comp)v;
            return c.getInput();
        }
        LiteralFactory lf = this.ctxt.getLiteralFactory();
        if (v instanceof IntegerLiteral) {
            IntegerLiteral il = (IntegerLiteral)v;
            return lf.literalOf(il.getType(), il.longValue() ^ 0xFFFFFFFFFFFFFFFFL);
        }
        if (v.isDefEq((Value)lf.literalOf(true))) {
            return lf.literalOf(false);
        }
        if (v.isDefEq((Value)lf.literalOf(false))) {
            return lf.literalOf(true);
        }
        return this.getDelegate().complement(v);
    }

    public Value isEq(Value v1, Value v2) {
        if (v1.isDefEq(v2)) {
            return this.ctxt.getLiteralFactory().literalOf(true);
        }
        if (!v1.isNullable() && SimpleOptBasicBlockBuilder.isAlwaysNull(v2) || SimpleOptBasicBlockBuilder.isAlwaysNull(v1) && !v2.isNullable() || v1.isDefNe(v2)) {
            return this.ctxt.getLiteralFactory().literalOf(false);
        }
        if (v2.isDefEq((Value)this.ctxt.getLiteralFactory().literalOf(false))) {
            return this.complement(v1);
        }
        if (v1.isDefEq((Value)this.ctxt.getLiteralFactory().literalOf(false))) {
            return this.complement(v2);
        }
        if ((v1 instanceof Extend || v1 instanceof BitCast && v1.getType() instanceof NullableType) && this.isZero(v2)) {
            Value input = ((WordCastValue)v1).getInput();
            return this.isEq(input, (Value)this.ctxt.getLiteralFactory().zeroInitializerLiteralOfType(input.getType()));
        }
        if ((v2 instanceof Extend || v2 instanceof BitCast && v2.getType() instanceof NullableType) && this.isZero(v1)) {
            Value input = ((WordCastValue)v2).getInput();
            return this.isEq((Value)this.ctxt.getLiteralFactory().zeroInitializerLiteralOfType(input.getType()), input);
        }
        if (SimpleOptBasicBlockBuilder.isCmp(v1) && this.isEqualToLiteral(v2, 0)) {
            return this.isEq(SimpleOptBasicBlockBuilder.cmpLeft(v1), SimpleOptBasicBlockBuilder.cmpRight(v1));
        }
        if (SimpleOptBasicBlockBuilder.isCmp(v2) && this.isEqualToLiteral(v1, 0)) {
            return this.isEq(SimpleOptBasicBlockBuilder.cmpLeft(v2), SimpleOptBasicBlockBuilder.cmpRight(v2));
        }
        return super.isEq(v1, v2);
    }

    public Value isNe(Value v1, Value v2) {
        if (v1.isDefEq(v2)) {
            return this.ctxt.getLiteralFactory().literalOf(false);
        }
        if (!v1.isNullable() && SimpleOptBasicBlockBuilder.isAlwaysNull(v2) || SimpleOptBasicBlockBuilder.isAlwaysNull(v1) && !v2.isNullable() || v1.isDefNe(v2)) {
            return this.ctxt.getLiteralFactory().literalOf(true);
        }
        if (v2.isDefEq((Value)this.ctxt.getLiteralFactory().literalOf(true))) {
            return this.complement(v1);
        }
        if (v1.isDefEq((Value)this.ctxt.getLiteralFactory().literalOf(true))) {
            return this.complement(v2);
        }
        if ((v1 instanceof Extend || v1 instanceof BitCast && v1.getType() instanceof NullableType) && this.isZero(v2)) {
            Value input = ((WordCastValue)v1).getInput();
            if (input.getType() instanceof BooleanType) {
                return input;
            }
            return this.isNe(input, (Value)this.ctxt.getLiteralFactory().zeroInitializerLiteralOfType(input.getType()));
        }
        if ((v2 instanceof Extend || v2 instanceof BitCast && v2.getType() instanceof NullableType) && this.isZero(v1)) {
            Value input = ((WordCastValue)v2).getInput();
            if (input.getType() instanceof BooleanType) {
                return input;
            }
            return this.isNe((Value)this.ctxt.getLiteralFactory().zeroInitializerLiteralOfType(input.getType()), input);
        }
        if (SimpleOptBasicBlockBuilder.isCmp(v1) && this.isEqualToLiteral(v2, 0)) {
            return this.isNe(SimpleOptBasicBlockBuilder.cmpLeft(v1), SimpleOptBasicBlockBuilder.cmpRight(v1));
        }
        if (SimpleOptBasicBlockBuilder.isCmp(v2) && this.isEqualToLiteral(v1, 0)) {
            return this.isNe(SimpleOptBasicBlockBuilder.cmpLeft(v2), SimpleOptBasicBlockBuilder.cmpRight(v2));
        }
        return super.isNe(v1, v2);
    }

    public Value isLt(Value v1, Value v2) {
        LiteralFactory lf = this.ctxt.getLiteralFactory();
        if (v1.isDefLt(v2)) {
            return lf.literalOf(true);
        }
        if (v1.isDefGe(v2)) {
            return lf.literalOf(false);
        }
        if (SimpleOptBasicBlockBuilder.isCmp(v1) && this.isEqualToLiteral(v2, 1)) {
            return this.isLe(SimpleOptBasicBlockBuilder.cmpLeft(v1), SimpleOptBasicBlockBuilder.cmpRight(v1));
        }
        if (SimpleOptBasicBlockBuilder.isCmp(v2) && this.isEqualToLiteral(v1, -1)) {
            return this.isGe(SimpleOptBasicBlockBuilder.cmpLeft(v2), SimpleOptBasicBlockBuilder.cmpRight(v2));
        }
        if (SimpleOptBasicBlockBuilder.isCmp(v1) && this.isEqualToLiteral(v2, 0)) {
            return this.isLt(SimpleOptBasicBlockBuilder.cmpLeft(v1), SimpleOptBasicBlockBuilder.cmpRight(v1));
        }
        if (SimpleOptBasicBlockBuilder.isCmp(v2) && this.isEqualToLiteral(v1, 0)) {
            return this.isLt(SimpleOptBasicBlockBuilder.cmpRight(v2), SimpleOptBasicBlockBuilder.cmpLeft(v2));
        }
        return super.isLt(v1, v2);
    }

    public Value isGt(Value v1, Value v2) {
        LiteralFactory lf = this.ctxt.getLiteralFactory();
        if (v1.isDefGt(v2)) {
            return lf.literalOf(true);
        }
        if (v1.isDefLe(v2)) {
            return lf.literalOf(false);
        }
        if (SimpleOptBasicBlockBuilder.isCmp(v2) && this.isEqualToLiteral(v1, 1)) {
            return this.isLe(SimpleOptBasicBlockBuilder.cmpLeft(v2), SimpleOptBasicBlockBuilder.cmpRight(v2));
        }
        if (SimpleOptBasicBlockBuilder.isCmp(v1) && this.isEqualToLiteral(v2, -1)) {
            return this.isGe(SimpleOptBasicBlockBuilder.cmpLeft(v1), SimpleOptBasicBlockBuilder.cmpRight(v1));
        }
        if (SimpleOptBasicBlockBuilder.isCmp(v1) && this.isEqualToLiteral(v2, 0)) {
            return this.isGt(SimpleOptBasicBlockBuilder.cmpLeft(v1), SimpleOptBasicBlockBuilder.cmpRight(v1));
        }
        if (SimpleOptBasicBlockBuilder.isCmp(v2) && this.isEqualToLiteral(v1, 0)) {
            return this.isGt(SimpleOptBasicBlockBuilder.cmpRight(v2), SimpleOptBasicBlockBuilder.cmpLeft(v2));
        }
        return super.isGt(v1, v2);
    }

    public Value isLe(Value v1, Value v2) {
        LiteralFactory lf = this.ctxt.getLiteralFactory();
        if (v1.isDefLe(v2)) {
            return lf.literalOf(true);
        }
        if (v1.isDefGt(v2)) {
            return lf.literalOf(false);
        }
        if (SimpleOptBasicBlockBuilder.isCmp(v2) && this.isEqualToLiteral(v1, 1)) {
            return this.isGt(SimpleOptBasicBlockBuilder.cmpLeft(v2), SimpleOptBasicBlockBuilder.cmpRight(v2));
        }
        if (SimpleOptBasicBlockBuilder.isCmp(v1) && this.isEqualToLiteral(v2, -1)) {
            return this.isLt(SimpleOptBasicBlockBuilder.cmpLeft(v1), SimpleOptBasicBlockBuilder.cmpRight(v1));
        }
        if (SimpleOptBasicBlockBuilder.isCmp(v1) && this.isEqualToLiteral(v2, 0)) {
            return this.isLe(SimpleOptBasicBlockBuilder.cmpLeft(v1), SimpleOptBasicBlockBuilder.cmpRight(v1));
        }
        if (SimpleOptBasicBlockBuilder.isCmp(v2) && this.isEqualToLiteral(v1, 0)) {
            return this.isLe(SimpleOptBasicBlockBuilder.cmpRight(v2), SimpleOptBasicBlockBuilder.cmpLeft(v2));
        }
        return super.isLe(v1, v2);
    }

    public Value isGe(Value v1, Value v2) {
        LiteralFactory lf = this.ctxt.getLiteralFactory();
        if (v1.isDefGe(v2)) {
            return lf.literalOf(true);
        }
        if (v1.isDefLt(v2)) {
            return lf.literalOf(false);
        }
        if (SimpleOptBasicBlockBuilder.isCmp(v1) && this.isEqualToLiteral(v2, -1)) {
            return this.isGe(SimpleOptBasicBlockBuilder.cmpLeft(v1), SimpleOptBasicBlockBuilder.cmpRight(v1));
        }
        if (SimpleOptBasicBlockBuilder.isCmp(v2) && this.isEqualToLiteral(v1, -1)) {
            return this.isLt(SimpleOptBasicBlockBuilder.cmpLeft(v2), SimpleOptBasicBlockBuilder.cmpRight(v2));
        }
        if (SimpleOptBasicBlockBuilder.isCmp(v1) && this.isEqualToLiteral(v2, 0)) {
            return this.isGe(SimpleOptBasicBlockBuilder.cmpLeft(v1), SimpleOptBasicBlockBuilder.cmpRight(v1));
        }
        if (SimpleOptBasicBlockBuilder.isCmp(v2) && this.isEqualToLiteral(v1, 0)) {
            return this.isGe(SimpleOptBasicBlockBuilder.cmpRight(v2), SimpleOptBasicBlockBuilder.cmpLeft(v2));
        }
        return super.isGe(v1, v2);
    }

    public Value and(Value v1, Value v2) {
        LiteralFactory lf = this.ctxt.getLiteralFactory();
        if (v1.getType() instanceof BooleanType) {
            BooleanLiteral trueLit = lf.literalOf(true);
            BooleanLiteral falseLit = lf.literalOf(false);
            if (v1.isDefEq((Value)trueLit) || v1.isDefNe((Value)falseLit)) {
                return v2;
            }
            if (v2.isDefEq((Value)trueLit) || v2.isDefNe((Value)falseLit)) {
                return v1;
            }
            if (v1.isDefEq((Value)falseLit) || v1.isDefNe((Value)trueLit) || v2.isDefEq((Value)falseLit) || v2.isDefNe((Value)trueLit)) {
                return falseLit;
            }
            if (v1 instanceof Comp) {
                Comp c1 = (Comp)v1;
                if (v2 instanceof Comp) {
                    Comp c2 = (Comp)v2;
                    return this.complement(this.or(c1.getInput(), c2.getInput()));
                }
            }
        } else {
            ValueType trueLit = v1.getType();
            if (trueLit instanceof IntegerType) {
                IntegerLiteral zero;
                IntegerType it = (IntegerType)trueLit;
                if (v1 instanceof IntegerLiteral) {
                    IntegerLiteral l1 = (IntegerLiteral)v1;
                    if (v2 instanceof IntegerLiteral) {
                        IntegerLiteral l2 = (IntegerLiteral)v2;
                        return lf.literalOf(it, l1.longValue() & l2.longValue());
                    }
                }
                if (v1.isDefEq((Value)(zero = lf.literalOf(it, 0L))) || v2.isDefEq((Value)zero)) {
                    return zero;
                }
                IntegerLiteral allOnes = lf.literalOf(it, -1L);
                if (v1.isDefEq((Value)allOnes)) {
                    return v2;
                }
                if (v2.isDefEq((Value)allOnes)) {
                    return v1;
                }
            }
        }
        return this.getDelegate().and(v1, v2);
    }

    public Value or(Value v1, Value v2) {
        LiteralFactory lf = this.ctxt.getLiteralFactory();
        if (v1.getType() instanceof BooleanType) {
            trueLit = lf.literalOf(true);
            BooleanLiteral falseLit = lf.literalOf(false);
            if (v1.isDefNe((Value)trueLit) || v1.isDefEq((Value)falseLit)) {
                return v2;
            }
            if (v2.isDefNe((Value)trueLit) || v2.isDefEq((Value)falseLit)) {
                return v1;
            }
            if (v1.isDefNe((Value)falseLit) || v1.isDefEq((Value)trueLit) || v2.isDefNe((Value)falseLit) || v2.isDefEq((Value)trueLit)) {
                return trueLit;
            }
            if (v1 instanceof Comp) {
                Comp c1 = (Comp)v1;
                if (v2 instanceof Comp) {
                    Comp c2 = (Comp)v2;
                    return this.complement(this.and(c1.getInput(), c2.getInput()));
                }
            }
        } else {
            trueLit = v1.getType();
            if (trueLit instanceof IntegerType) {
                IntegerLiteral allOnes;
                IntegerType it = (IntegerType)trueLit;
                if (v1 instanceof IntegerLiteral) {
                    IntegerLiteral l1 = (IntegerLiteral)v1;
                    if (v2 instanceof IntegerLiteral) {
                        IntegerLiteral l2 = (IntegerLiteral)v2;
                        return lf.literalOf(it, l1.longValue() | l2.longValue());
                    }
                }
                if (v1.isDefEq((Value)(allOnes = lf.literalOf(it, -1L))) || v2.isDefEq((Value)allOnes)) {
                    return allOnes;
                }
                IntegerLiteral zero = lf.literalOf(it, 0L);
                if (v1.isDefEq((Value)zero)) {
                    return v2;
                }
                if (v2.isDefEq((Value)zero)) {
                    return v1;
                }
            }
        }
        if (v1 instanceof And) {
            And a1 = (And)v1;
            if (v2 instanceof And) {
                And a2 = (And)v2;
                Value a1Left = a1.getLeftInput();
                Value a2Left = a2.getLeftInput();
                Value a1Right = a1.getRightInput();
                Value a2Right = a2.getRightInput();
                if (a1Left.isDefEq(a2Left) || a2Left.isDefEq(a1Left)) {
                    return this.and(a1Left, this.or(a1Right, a2Right));
                }
                if (a1Left.isDefEq(a2Right) || a2Right.isDefEq(a1Left)) {
                    return this.and(a1Left, this.or(a1Right, a2Left));
                }
                if (a1Right.isDefEq(a2Left) || a2Left.isDefEq(a1Right)) {
                    return this.and(a1Right, this.or(a1Left, a2Right));
                }
                if (a1Right.isDefEq(a2Right) || a2Right.isDefEq(a1Right)) {
                    return this.and(a1Right, this.or(a1Left, a2Left));
                }
            }
        }
        return this.getDelegate().or(v1, v2);
    }

    public Value xor(Value v1, Value v2) {
        IntegerLiteral allOnes;
        if (v1.getType() instanceof BooleanType) {
            return this.isNe(v1, v2);
        }
        LiteralFactory lf = this.ctxt.getLiteralFactory();
        IntegerType it = (IntegerType)v1.getType();
        if (v1 instanceof IntegerLiteral) {
            IntegerLiteral l1 = (IntegerLiteral)v1;
            if (v2 instanceof IntegerLiteral) {
                IntegerLiteral l2 = (IntegerLiteral)v2;
                return lf.literalOf(it, l1.longValue() ^ l2.longValue());
            }
        }
        if (v1.isDefEq((Value)(allOnes = lf.literalOf(it, -1L)))) {
            return this.complement(v2);
        }
        if (v2.isDefEq((Value)allOnes)) {
            return this.complement(v1);
        }
        IntegerLiteral zero = lf.literalOf(it, 0L);
        if (v1.isDefEq((Value)zero)) {
            return v2;
        }
        if (v2.isDefEq((Value)zero)) {
            return v1;
        }
        return this.getDelegate().xor(v1, v2);
    }

    public Value bitCast(Value input, WordType toType) {
        if (input instanceof BitCast) {
            BitCast inputNode = (BitCast)input;
            if (inputNode.getInput().getType().equals((ValueType)toType)) {
                return inputNode.getInput();
            }
            return this.bitCast(inputNode.getInput(), toType);
        }
        ValueType valueType = input.getType();
        if (valueType instanceof PointerType) {
            PointerType inPtrType = (PointerType)valueType;
            if (toType instanceof PointerType) {
                IntegerLiteral z;
                ValueHandle outVal;
                PointerType outPtrType = (PointerType)toType;
                if (inPtrType.getPointeeType() instanceof CompoundType && (outVal = this.addressOfFirst(this.pointerHandle(input, (Value)(z = this.ctxt.getLiteralFactory().literalOf(0))), outPtrType.getPointeeType())) != null) {
                    return this.addressOf(outVal);
                }
            }
        }
        return super.bitCast(input, toType);
    }

    private ValueHandle addressOfFirst(ValueHandle input, ValueType outputType) {
        CompoundType ct;
        ValueType valueType = input.getValueType();
        if (valueType instanceof CompoundType && (ct = (CompoundType)valueType).getMemberCount() > 0) {
            memberZero = ct.getMember(0);
            if (memberZero.getOffset() == 0) {
                ValueHandle nextHandle = this.memberOf(input, (CompoundType.Member)memberZero);
                if (outputType.equals(memberZero.getType())) {
                    return nextHandle;
                }
                return this.addressOfFirst(nextHandle, outputType);
            }
        } else {
            ArrayType at;
            memberZero = input.getValueType();
            if (memberZero instanceof ArrayType && (at = (ArrayType)memberZero).getElementCount() > 0L) {
                ValueHandle nextHandle = this.elementOf(input, (Value)this.ctxt.getLiteralFactory().literalOf(0));
                if (outputType.equals(at.getElementType())) {
                    return nextHandle;
                }
                return this.addressOfFirst(nextHandle, outputType);
            }
        }
        return null;
    }

    public Value valueConvert(Value input, WordType toType) {
        Value result = this.literalCast(input, toType, false);
        if (result != null) {
            return result;
        }
        if (input instanceof Convert) {
            Convert inputNode = (Convert)input;
            Value inputInput = inputNode.getInput();
            ValueType inputInputType = inputInput.getType();
            if (inputInputType instanceof PointerType && toType instanceof PointerType) {
                return this.bitCast(inputInput, toType);
            }
            if (inputInputType instanceof ReferenceType && toType instanceof ReferenceType) {
                return this.bitCast(inputInput, toType);
            }
        }
        return super.valueConvert(input, toType);
    }

    public Value select(Value condition, Value trueValue, Value falseValue) {
        if (this.isEqualToLiteral(trueValue, 1) && this.isEqualToLiteral(falseValue, 0)) {
            return this.extend(condition, (WordType)trueValue.getType());
        }
        if (this.isEqualToLiteral(trueValue, 0) && this.isEqualToLiteral(falseValue, 1)) {
            return this.extend(this.xor(condition, (Value)this.ctxt.getLiteralFactory().literalOf(true)), (WordType)trueValue.getType());
        }
        BooleanLiteral trueLit = this.ctxt.getLiteralFactory().literalOf(true);
        BooleanLiteral falseLit = this.ctxt.getLiteralFactory().literalOf(false);
        if (condition.isDefEq((Value)trueLit) || condition.isDefNe((Value)falseLit)) {
            return trueValue;
        }
        if (condition.isDefEq((Value)falseLit) || condition.isDefNe((Value)trueLit)) {
            return falseValue;
        }
        if (trueValue.equals(falseValue)) {
            return trueValue;
        }
        if (trueValue.isDefEq((Value)trueLit) && falseValue.isDefEq((Value)falseLit)) {
            return condition;
        }
        if (trueValue.isDefEq((Value)falseLit) && falseValue.isDefEq((Value)trueLit)) {
            return this.complement(condition);
        }
        return this.getDelegate().select(condition, trueValue, falseValue);
    }

    public BasicBlock if_(Value condition, BlockLabel trueTarget, BlockLabel falseTarget) {
        BooleanLiteral trueLit = this.ctxt.getLiteralFactory().literalOf(true);
        BooleanLiteral falseLit = this.ctxt.getLiteralFactory().literalOf(false);
        if (condition.isDefEq((Value)trueLit) || condition.isDefNe((Value)falseLit)) {
            return this.goto_(trueTarget);
        }
        if (condition.isDefEq((Value)falseLit) || condition.isDefNe((Value)trueLit)) {
            return this.goto_(falseTarget);
        }
        if (trueTarget == falseTarget) {
            return this.goto_(trueTarget);
        }
        return this.getDelegate().if_(condition, trueTarget, falseTarget);
    }

    public BasicBlock switch_(Value value, int[] checkValues, BlockLabel[] targets, BlockLabel defaultTarget) {
        ValueType valueType = value.getType();
        if (valueType instanceof IntegerType) {
            IntegerType it = (IntegerType)valueType;
            LiteralFactory lf = this.ctxt.getLiteralFactory();
            boolean defaultMatches = true;
            for (int checkValue : checkValues) {
                IntegerLiteral checkValueLit = lf.literalOf(it, (long)checkValue);
                if (value.isDefEq((Value)checkValueLit)) {
                    return this.goto_(targets[checkValue]);
                }
                if (!defaultMatches || value.isDefNe((Value)checkValueLit)) continue;
                defaultMatches = false;
            }
            if (defaultMatches) {
                return this.goto_(defaultTarget);
            }
        }
        return this.getDelegate().switch_(value, checkValues, targets, defaultTarget);
    }

    public Value add(Value v1, Value v2) {
        if (v1.getType() instanceof IntegerType) {
            assert (v2.getType() instanceof IntegerType);
            if (this.isZero(v1)) {
                return v2;
            }
            if (this.isZero(v2)) {
                return v1;
            }
            if (v1 instanceof Neg) {
                Neg n1 = (Neg)v1;
                return this.sub(v2, n1.getInput());
            }
            if (v2 instanceof Neg) {
                Neg n2 = (Neg)v2;
                return this.sub(v1, n2.getInput());
            }
        }
        return super.add(v1, v2);
    }

    public Value sub(Value v1, Value v2) {
        if (v1.getType() instanceof IntegerType) {
            assert (v2.getType() instanceof IntegerType);
            if (this.isZero(v1)) {
                return this.negate(v2);
            }
            if (this.isZero(v2)) {
                return v1;
            }
            if (v2 instanceof Neg) {
                Neg n2 = (Neg)v2;
                return this.add(v1, n2.getInput());
            }
        }
        return super.sub(v1, v2);
    }

    public Value negate(Value v) {
        if (v instanceof Neg) {
            Neg neg = (Neg)v;
            return neg.getInput();
        }
        if (SimpleOptBasicBlockBuilder.isCmp(v)) {
            return this.cmp(SimpleOptBasicBlockBuilder.cmpRight(v), SimpleOptBasicBlockBuilder.cmpLeft(v));
        }
        return super.negate(v);
    }

    public Value addressOf(ValueHandle handle) {
        PointerHandle ph;
        if (handle instanceof PointerHandle && this.isZero((ph = (PointerHandle)handle).getOffsetValue())) {
            return ((PointerHandle)handle).getPointerValue();
        }
        return super.addressOf(handle);
    }

    public ValueHandle pointerHandle(Value pointer, Value offsetValue) {
        if (pointer instanceof AddressOf) {
            if (this.isZero(offsetValue)) {
                return pointer.getValueHandle();
            }
            ValueHandle valueHandle = pointer.getValueHandle();
            if (valueHandle instanceof PointerHandle) {
                PointerHandle ph = (PointerHandle)valueHandle;
                return this.pointerHandle(ph.getPointerValue(), this.add(ph.getOffsetValue(), offsetValue));
            }
        }
        return super.pointerHandle(pointer, offsetValue);
    }

    private static boolean isAlwaysNull(Value value) {
        return value instanceof NullLiteral;
    }

    private boolean isZero(Value value) {
        return value.isDefEq((Value)this.ctxt.getLiteralFactory().zeroInitializerLiteralOfType(value.getType()));
    }

    private static boolean isCmp(Value value) {
        return value instanceof Cmp;
    }

    private static Value cmpLeft(Value value) {
        return ((Cmp)value).getLeftInput();
    }

    private static Value cmpRight(Value value) {
        return ((Cmp)value).getRightInput();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isEqualToLiteral(Value value, int literal) {
        ValueType valueType = value.getType();
        if (!(valueType instanceof IntegerType)) return false;
        IntegerType it = (IntegerType)valueType;
        if (!value.isDefEq((Value)this.ctxt.getLiteralFactory().literalOf(it, (long)literal))) return false;
        return true;
    }
}

