/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.opt;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.qbicc.context.CompilationContext;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.BlockLabel;
import org.qbicc.graph.CmpAndSwap;
import org.qbicc.graph.DelegatingBasicBlockBuilder;
import org.qbicc.graph.ElementOf;
import org.qbicc.graph.MemberOf;
import org.qbicc.graph.MemoryAtomicityMode;
import org.qbicc.graph.Node;
import org.qbicc.graph.Value;
import org.qbicc.graph.ValueHandle;
import org.qbicc.graph.ValueHandleVisitor;

public class LocalMemoryTrackingBasicBlockBuilder
extends DelegatingBasicBlockBuilder
implements ValueHandleVisitor<MemoryAtomicityMode, Value> {
    private final CompilationContext ctxt;
    private final Map<ValueHandle, Value> knownValues = new HashMap<ValueHandle, Value>();

    public LocalMemoryTrackingBasicBlockBuilder(CompilationContext ctxt, BasicBlockBuilder delegate) {
        super(delegate);
        this.ctxt = ctxt;
    }

    public Node begin(BlockLabel blockLabel) {
        this.knownValues.clear();
        return super.begin(blockLabel);
    }

    public Value load(ValueHandle handle, MemoryAtomicityMode mode) {
        if (mode != MemoryAtomicityMode.NONE && mode != MemoryAtomicityMode.UNORDERED) {
            this.knownValues.clear();
        } else {
            Value value = (Value)handle.accept((ValueHandleVisitor)this, (Object)mode);
            if (value != null) {
                return value;
            }
        }
        Value loaded = super.load(handle, mode);
        this.knownValues.put(handle, loaded);
        return loaded;
    }

    public Node store(ValueHandle handle, Value value, MemoryAtomicityMode mode) {
        ValueHandle root = LocalMemoryTrackingBasicBlockBuilder.findRoot(handle);
        this.knownValues.keySet().removeIf(k -> !LocalMemoryTrackingBasicBlockBuilder.hasSameRoot(k, root));
        this.knownValues.put(handle, value);
        return super.store(handle, value, mode);
    }

    public Value getAndAdd(ValueHandle target, Value update, MemoryAtomicityMode atomicityMode) {
        this.knownValues.clear();
        return super.getAndAdd(target, update, atomicityMode);
    }

    public Value getAndBitwiseAnd(ValueHandle target, Value update, MemoryAtomicityMode atomicityMode) {
        this.knownValues.clear();
        return super.getAndBitwiseAnd(target, update, atomicityMode);
    }

    public Value getAndBitwiseNand(ValueHandle target, Value update, MemoryAtomicityMode atomicityMode) {
        this.knownValues.clear();
        return super.getAndBitwiseNand(target, update, atomicityMode);
    }

    public Value getAndBitwiseOr(ValueHandle target, Value update, MemoryAtomicityMode atomicityMode) {
        this.knownValues.clear();
        return super.getAndBitwiseOr(target, update, atomicityMode);
    }

    public Value getAndBitwiseXor(ValueHandle target, Value update, MemoryAtomicityMode atomicityMode) {
        this.knownValues.clear();
        return super.getAndBitwiseXor(target, update, atomicityMode);
    }

    public Value getAndSet(ValueHandle target, Value update, MemoryAtomicityMode atomicityMode) {
        this.knownValues.clear();
        return super.getAndSet(target, update, atomicityMode);
    }

    public Value getAndSetMax(ValueHandle target, Value update, MemoryAtomicityMode atomicityMode) {
        this.knownValues.clear();
        return super.getAndSetMax(target, update, atomicityMode);
    }

    public Value getAndSetMin(ValueHandle target, Value update, MemoryAtomicityMode atomicityMode) {
        this.knownValues.clear();
        return super.getAndSetMin(target, update, atomicityMode);
    }

    public Value getAndSub(ValueHandle target, Value update, MemoryAtomicityMode atomicityMode) {
        this.knownValues.clear();
        return super.getAndSub(target, update, atomicityMode);
    }

    public Value cmpAndSwap(ValueHandle target, Value expect, Value update, MemoryAtomicityMode successMode, MemoryAtomicityMode failureMode, CmpAndSwap.Strength strength) {
        this.knownValues.clear();
        return super.cmpAndSwap(target, expect, update, successMode, failureMode, strength);
    }

    public Node fence(MemoryAtomicityMode fenceType) {
        this.knownValues.clear();
        return super.fence(fenceType);
    }

    public Node monitorEnter(Value obj) {
        this.knownValues.clear();
        return super.monitorEnter(obj);
    }

    public Node monitorExit(Value obj) {
        this.knownValues.clear();
        return super.monitorExit(obj);
    }

    public Value call(ValueHandle target, List<Value> arguments) {
        this.knownValues.clear();
        return super.call(target, arguments);
    }

    public BasicBlock callNoReturn(ValueHandle target, List<Value> arguments) {
        this.knownValues.clear();
        return super.callNoReturn(target, arguments);
    }

    public BasicBlock invokeNoReturn(ValueHandle target, List<Value> arguments, BlockLabel catchLabel) {
        this.knownValues.clear();
        return super.invokeNoReturn(target, arguments, catchLabel);
    }

    public BasicBlock tailCall(ValueHandle target, List<Value> arguments) {
        this.knownValues.clear();
        return super.tailCall(target, arguments);
    }

    public BasicBlock tailInvoke(ValueHandle target, List<Value> arguments, BlockLabel catchLabel) {
        this.knownValues.clear();
        return super.tailInvoke(target, arguments, catchLabel);
    }

    public Value invoke(ValueHandle target, List<Value> arguments, BlockLabel catchLabel, BlockLabel resumeLabel) {
        this.knownValues.clear();
        return super.invoke(target, arguments, catchLabel, resumeLabel);
    }

    private static ValueHandle findRoot(ValueHandle handle) {
        return handle instanceof ElementOf || !handle.hasValueHandleDependency() ? handle : LocalMemoryTrackingBasicBlockBuilder.findRoot(handle.getValueHandle());
    }

    private static boolean hasSameRoot(ValueHandle handle, ValueHandle root) {
        return LocalMemoryTrackingBasicBlockBuilder.findRoot(handle).equals(root);
    }

    public Value visitUnknown(MemoryAtomicityMode param, ValueHandle node) {
        return this.knownValues.get(node);
    }

    public Value visit(MemoryAtomicityMode param, ElementOf node) {
        Value value = this.knownValues.get(node);
        if (value != null) {
            return value;
        }
        value = (Value)node.getValueHandle().accept((ValueHandleVisitor)this, (Object)param);
        if (value != null) {
            return this.extractElement(value, node.getIndex());
        }
        return null;
    }

    public Value visit(MemoryAtomicityMode param, MemberOf node) {
        Value value = this.knownValues.get(node);
        if (value != null) {
            return value;
        }
        value = (Value)node.getValueHandle().accept((ValueHandleVisitor)this, (Object)param);
        if (value != null) {
            return this.extractMember(value, node.getMember());
        }
        return null;
    }
}

