/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.instanceofcheckcast;

import java.util.List;
import java.util.Map;
import org.qbicc.context.CompilationContext;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.BlockEarlyTermination;
import org.qbicc.graph.BlockLabel;
import org.qbicc.graph.CheckCast;
import org.qbicc.graph.DelegatingBasicBlockBuilder;
import org.qbicc.graph.Value;
import org.qbicc.graph.literal.IntegerLiteral;
import org.qbicc.graph.literal.NullLiteral;
import org.qbicc.graph.literal.TypeIdLiteral;
import org.qbicc.plugin.coreclasses.RuntimeMethodFinder;
import org.qbicc.type.InterfaceObjectType;
import org.qbicc.type.NullableType;
import org.qbicc.type.ObjectType;
import org.qbicc.type.PhysicalObjectType;
import org.qbicc.type.PrimitiveArrayObjectType;
import org.qbicc.type.ReferenceArrayObjectType;
import org.qbicc.type.ReferenceType;
import org.qbicc.type.ValueType;
import org.qbicc.type.WordType;
import org.qbicc.type.definition.element.MethodElement;

public final class InvalidCastsCleanupBasicBlockBuilder
extends DelegatingBasicBlockBuilder {
    public InvalidCastsCleanupBasicBlockBuilder(BasicBlockBuilder.FactoryContext ctxt, BasicBlockBuilder delegate) {
        super(delegate);
    }

    public Value instanceOf(Value input, ObjectType expectedType, int expectedDimensions) {
        ValueType valueType = input.getType();
        if (valueType instanceof ReferenceType) {
            ReferenceType inputRefType = (ReferenceType)valueType;
            if (input instanceof NullLiteral) {
                return this.getLiteralFactory().literalOf(false);
            }
            ObjectType ifTrueExpectedType = expectedType;
            for (int i = 0; i < expectedDimensions; ++i) {
                ifTrueExpectedType = ifTrueExpectedType.getReferenceArrayObject();
            }
            if (inputRefType.instanceOf(ifTrueExpectedType)) {
                return this.getLiteralFactory().literalOf(true);
            }
            ReferenceType narrowed = inputRefType.narrow(ifTrueExpectedType);
            if (narrowed == null) {
                return this.getLiteralFactory().literalOf(false);
            }
        }
        return super.instanceOf(input, expectedType, expectedDimensions);
    }

    public Value checkcast(Value value, Value toType, Value toDimensions, CheckCast.CastType kind, ObjectType expectedType) {
        ValueType inputType = value.getType();
        if (inputType instanceof ReferenceType) {
            int dims;
            ObjectType toTypeOT;
            ReferenceType rt = (ReferenceType)inputType;
            ReferenceType outputType = rt.narrow(expectedType);
            if (outputType == null) {
                if (value.isNullable()) {
                    BlockLabel resume = new BlockLabel();
                    BlockLabel doThrow = new BlockLabel();
                    this.if_(this.isEq(value, (Value)this.getLiteralFactory().nullLiteralOfType((NullableType)value.getType(NullableType.class))), resume, doThrow, Map.of());
                    this.begin(doThrow);
                    try {
                        MethodElement thrower = RuntimeMethodFinder.get((CompilationContext)this.getContext()).getMethod(kind.equals((Object)CheckCast.CastType.Cast) ? "raiseClassCastException" : "raiseArrayStoreException");
                        this.callNoReturn((Value)this.getLiteralFactory().literalOf(thrower), List.of());
                    }
                    catch (BlockEarlyTermination blockEarlyTermination) {
                        // empty catch block
                    }
                    this.begin(resume);
                    return this.getLiteralFactory().nullLiteralOfType((NullableType)expectedType.getReference());
                }
                MethodElement thrower = RuntimeMethodFinder.get((CompilationContext)this.getContext()).getMethod(kind.equals((Object)CheckCast.CastType.Cast) ? "raiseClassCastException" : "raiseArrayStoreException");
                throw new BlockEarlyTermination(this.callNoReturn((Value)this.getLiteralFactory().literalOf(thrower), List.of()));
            }
            if (value instanceof NullLiteral) {
                return this.getLiteralFactory().nullLiteralOfType((NullableType)outputType);
            }
            if (toType instanceof TypeIdLiteral && toDimensions instanceof IntegerLiteral ? this.isAlwaysAssignable(rt, toTypeOT = (ObjectType)((TypeIdLiteral)toType).getValue(), dims = ((IntegerLiteral)toDimensions).intValue()) : kind.equals((Object)CheckCast.CastType.ArrayStore) && this.isEffectivelyFinal(expectedType) && rt.instanceOf(expectedType)) {
                return this.bitCast(value, (WordType)outputType);
            }
        }
        return super.checkcast(value, toType, toDimensions, kind, expectedType);
    }

    private boolean isAlwaysAssignable(ReferenceType inputType, ObjectType toType, int toDimensions) {
        if (toDimensions == 0) {
            return inputType.instanceOf(toType);
        }
        PhysicalObjectType physicalObjectType = inputType.getUpperBound();
        if (physicalObjectType instanceof ReferenceArrayObjectType) {
            ReferenceArrayObjectType inputArrayType = (ReferenceArrayObjectType)physicalObjectType;
            if (inputArrayType.getDimensionCount() == toDimensions) {
                return inputType.instanceOf(inputArrayType.getElementType());
            }
            if (inputArrayType.getDimensionCount() > toDimensions) {
                return !toType.hasSuperClass();
            }
        }
        return false;
    }

    private boolean isEffectivelyFinal(ObjectType type) {
        if (type instanceof PrimitiveArrayObjectType) {
            return true;
        }
        if (type instanceof ReferenceArrayObjectType || type instanceof InterfaceObjectType) {
            return false;
        }
        return type.getDefinition().load().isFinal();
    }
}

