/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.instanceofcheckcast;

import java.util.function.Consumer;
import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.plugin.coreclasses.CoreClasses;
import org.qbicc.plugin.instanceofcheckcast.SupersDisplayTables;
import org.qbicc.plugin.reachability.ReachabilityInfo;
import org.qbicc.type.Primitive;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.LoadedTypeDefinition;

public class SupersDisplayBuilder
implements Consumer<CompilationContext> {
    @Override
    public void accept(CompilationContext ctxt) {
        ReachabilityInfo info = ReachabilityInfo.get((CompilationContext)ctxt);
        SupersDisplayTables tables = SupersDisplayTables.get(ctxt);
        ClassContext classContext = ctxt.getBootstrapClassContext();
        DefinedTypeDefinition jloDef = classContext.findDefinedType("java/lang/Object");
        LoadedTypeDefinition jlo = jloDef.load();
        tables.buildSupersDisplay(jlo);
        info.visitReachableSubclassesPreOrder(jlo, tables::buildSupersDisplay);
        CoreClasses coreClasses = CoreClasses.get((CompilationContext)ctxt);
        Primitive.VOID.setTypeId(tables.assignTypeID(coreClasses.getVoidTypeDefinition()));
        Primitive.BOOLEAN.setTypeId(tables.assignTypeID(coreClasses.getBooleanTypeDefinition()));
        Primitive.BYTE.setTypeId(tables.assignTypeID(coreClasses.getByteTypeDefinition()));
        Primitive.SHORT.setTypeId(tables.assignTypeID(coreClasses.getShortTypeDefinition()));
        Primitive.CHAR.setTypeId(tables.assignTypeID(coreClasses.getCharTypeDefinition()));
        Primitive.INT.setTypeId(tables.assignTypeID(coreClasses.getIntTypeDefinition()));
        Primitive.FLOAT.setTypeId(tables.assignTypeID(coreClasses.getFloatTypeDefinition()));
        Primitive.LONG.setTypeId(tables.assignTypeID(coreClasses.getLongTypeDefinition()));
        Primitive.DOUBLE.setTypeId(tables.assignTypeID(coreClasses.getDoubleTypeDefinition()));
        tables.assignTypeID(jlo);
        tables.assignTypeID(coreClasses.getArrayBaseTypeDefinition());
        tables.assignTypeID(coreClasses.getArrayLoadedTypeDefinition("[Z"));
        tables.assignTypeID(coreClasses.getArrayLoadedTypeDefinition("[B"));
        tables.assignTypeID(coreClasses.getArrayLoadedTypeDefinition("[S"));
        tables.assignTypeID(coreClasses.getArrayLoadedTypeDefinition("[C"));
        tables.assignTypeID(coreClasses.getArrayLoadedTypeDefinition("[I"));
        tables.assignTypeID(coreClasses.getArrayLoadedTypeDefinition("[F"));
        tables.assignTypeID(coreClasses.getArrayLoadedTypeDefinition("[J"));
        tables.assignTypeID(coreClasses.getArrayLoadedTypeDefinition("[D"));
        tables.assignTypeID(coreClasses.getArrayLoadedTypeDefinition("[ref"));
        info.visitReachableSubclassesPreOrder(jlo, tables::assignTypeID);
        info.visitReachableSubclassesPostOrder(jlo, tables::assignMaximumSubtypeId);
        info.visitReachableInterfaces(tables::assignInterfaceId);
        tables.updateJLORange(jlo);
        tables.statistics();
        tables.writeTypeIdToClasses();
        tables.defineTypeIdStructAndGlobalArray(jlo);
    }
}

