/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.instanceofcheckcast;

import java.util.List;
import java.util.Map;
import org.qbicc.context.CompilationContext;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.BlockEarlyTermination;
import org.qbicc.graph.BlockLabel;
import org.qbicc.graph.CheckCast;
import org.qbicc.graph.DelegatingBasicBlockBuilder;
import org.qbicc.graph.Slot;
import org.qbicc.graph.Value;
import org.qbicc.graph.literal.IntegerLiteral;
import org.qbicc.graph.literal.LiteralFactory;
import org.qbicc.graph.literal.NullLiteral;
import org.qbicc.graph.literal.TypeLiteral;
import org.qbicc.plugin.coreclasses.CoreClasses;
import org.qbicc.plugin.coreclasses.RuntimeMethodFinder;
import org.qbicc.plugin.instanceofcheckcast.SupersDisplayTables;
import org.qbicc.plugin.reachability.ReachabilityInfo;
import org.qbicc.type.ClassObjectType;
import org.qbicc.type.IntegerType;
import org.qbicc.type.InterfaceObjectType;
import org.qbicc.type.ObjectType;
import org.qbicc.type.PrimitiveArrayObjectType;
import org.qbicc.type.ReferenceArrayObjectType;
import org.qbicc.type.ReferenceType;
import org.qbicc.type.TypeSystem;
import org.qbicc.type.UnsignedIntegerType;
import org.qbicc.type.ValueType;
import org.qbicc.type.WordType;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.LoadedTypeDefinition;
import org.qbicc.type.definition.element.GlobalVariableElement;
import org.qbicc.type.definition.element.MethodElement;

public class InstanceOfCheckCastBasicBlockBuilder
extends DelegatingBasicBlockBuilder {
    private final CompilationContext ctxt = this.getContext();

    public InstanceOfCheckCastBasicBlockBuilder(BasicBlockBuilder.FactoryContext ctxt, BasicBlockBuilder delegate) {
        super(delegate);
    }

    public Value checkcast(Value input, Value toType, Value toDimensions, CheckCast.CastType kind, ObjectType expectedType) {
        int dims;
        ObjectType toTypeOT;
        ValueType valueType = input.getType();
        if (!(valueType instanceof ReferenceType)) {
            this.ctxt.error(this.getLocation(), "Invalid type for checkcast: %s", new Object[]{input.getType()});
            throw new BlockEarlyTermination(this.unreachable());
        }
        ReferenceType inputType = (ReferenceType)valueType;
        ReferenceType outputType = inputType.narrow(expectedType);
        if (outputType == null) {
            throw new IllegalStateException("Invalid cast");
        }
        if (toType instanceof TypeLiteral && toDimensions instanceof IntegerLiteral ? this.isAlwaysAssignable((ValueType)inputType, toTypeOT = (ObjectType)((TypeLiteral)toType).getValue(), dims = ((IntegerLiteral)toDimensions).intValue()) : kind.equals((Object)CheckCast.CastType.ArrayStore) && this.isEffectivelyFinal(expectedType) && inputType.instanceOf(expectedType)) {
            return this.bitCast(input, (WordType)outputType);
        }
        if (input instanceof NullLiteral) {
            return this.ctxt.getLiteralFactory().zeroInitializerLiteralOfType((ValueType)outputType);
        }
        BlockLabel pass = new BlockLabel();
        BlockLabel fail = new BlockLabel();
        BlockLabel dynCheck = new BlockLabel();
        this.if_(this.isEq(input, (Value)this.ctxt.getLiteralFactory().zeroInitializerLiteralOfType((ValueType)inputType)), pass, dynCheck, Map.of());
        try {
            this.begin(fail);
            MethodElement thrower = RuntimeMethodFinder.get((CompilationContext)this.ctxt).getMethod(kind.equals((Object)CheckCast.CastType.Cast) ? "raiseClassCastException" : "raiseArrayStoreException");
            this.getFirstBuilder().callNoReturn((Value)this.getLiteralFactory().literalOf(thrower), List.of());
        }
        catch (BlockEarlyTermination thrower) {
            // empty catch block
        }
        ReachabilityInfo info = ReachabilityInfo.get((CompilationContext)this.ctxt);
        if (expectedType instanceof ClassObjectType || expectedType instanceof InterfaceObjectType) {
            LoadedTypeDefinition vtd = expectedType.getDefinition().load();
            if (vtd.isInterface()) {
                if (!info.isReachableInterface(vtd)) {
                    dynCheck.setTarget(fail);
                    this.begin(pass);
                    if (input.isNullable()) {
                        return this.ctxt.getLiteralFactory().zeroInitializerLiteralOfType((ValueType)outputType);
                    }
                    throw new BlockEarlyTermination(this.unreachable());
                }
            } else if (!info.isReachableClass(vtd)) {
                dynCheck.setTarget(fail);
                this.begin(pass);
                if (input.isNullable()) {
                    return this.ctxt.getLiteralFactory().zeroInitializerLiteralOfType((ValueType)outputType);
                }
                throw new BlockEarlyTermination(this.unreachable());
            }
        }
        try {
            boolean inlinedTest;
            this.begin(dynCheck);
            if (toType instanceof TypeLiteral && toDimensions instanceof IntegerLiteral) {
                ObjectType toTypeOT2 = (ObjectType)((TypeLiteral)toType).getValue();
                int dims2 = ((IntegerLiteral)toDimensions).intValue();
                inlinedTest = this.generateTypeTest(input, toTypeOT2, dims2, pass, fail);
            } else {
                inlinedTest = this.generateTypeTest(input, toType, toDimensions, expectedType, pass, fail);
            }
            if (!inlinedTest) {
                String helperName = kind.equals((Object)CheckCast.CastType.Cast) ? (toType instanceof TypeLiteral ? "checkcastTypeId" : "checkcastClass") : "arrayStoreCheck";
                MethodElement method = RuntimeMethodFinder.get((CompilationContext)this.ctxt).getMethod(helperName);
                this.getFirstBuilder().call((Value)this.getLiteralFactory().literalOf(method), List.of(input, toType, toDimensions));
                this.goto_(pass, Map.of());
            }
        }
        catch (BlockEarlyTermination blockEarlyTermination) {
            // empty catch block
        }
        this.begin(pass);
        return this.bitCast(input, (WordType)outputType);
    }

    public Value instanceOf(Value input, ObjectType expectedType, int expectedDimensions) {
        LoadedTypeDefinition vtd;
        LiteralFactory lf = this.ctxt.getLiteralFactory();
        if (input instanceof NullLiteral) {
            return this.ctxt.getLiteralFactory().literalOf(false);
        }
        ValueType actualType = input.getType();
        if (actualType instanceof ReferenceType && expectedDimensions == 0 && ((ReferenceType)actualType).instanceOf(expectedType)) {
            return super.isNe(input, (Value)lf.zeroInitializerLiteralOfType(actualType));
        }
        ReachabilityInfo info = ReachabilityInfo.get((CompilationContext)this.ctxt);
        if ((expectedType instanceof ClassObjectType || expectedType instanceof InterfaceObjectType) && ((vtd = expectedType.getDefinition().load()).isInterface() ? !info.isReachableInterface(vtd) : !info.isReachableClass(vtd))) {
            return this.ctxt.getLiteralFactory().literalOf(false);
        }
        BlockLabel fail = new BlockLabel();
        BlockLabel notNull = new BlockLabel();
        BlockLabel allDone = new BlockLabel();
        this.if_(this.isEq(input, (Value)this.ctxt.getLiteralFactory().zeroInitializerLiteralOfType(input.getType())), fail, notNull, Map.of());
        TypeSystem ts = this.getTypeSystem();
        try {
            this.begin(notNull);
            BlockLabel passInline = new BlockLabel();
            boolean inlinedTest = this.generateTypeTest(input, expectedType, expectedDimensions, passInline, fail);
            if (!inlinedTest) {
                MethodElement helper = RuntimeMethodFinder.get((CompilationContext)this.ctxt).getMethod("instanceofTypeId");
                BasicBlockBuilder fb = this.getFirstBuilder();
                UnsignedIntegerType u8 = ts.getUnsignedInteger8Type();
                Value passResult = fb.call((Value)lf.literalOf(helper), List.of(input, lf.literalOfType((ValueType)expectedType), lf.literalOf((IntegerType)u8, (long)expectedDimensions)));
                this.goto_(allDone, Slot.temp((int)0), passResult);
            } else {
                this.begin(passInline);
                this.goto_(allDone, Slot.temp((int)0), (Value)lf.literalOf(true));
            }
        }
        catch (BlockEarlyTermination blockEarlyTermination) {
            // empty catch block
        }
        this.begin(fail);
        this.goto_(allDone, Slot.temp((int)0), (Value)lf.literalOf(false));
        this.begin(allDone);
        return this.addParam(allDone, Slot.temp((int)0), (ValueType)ts.getBooleanType());
    }

    public Value classOf(Value typeId, Value dimensions) {
        RuntimeMethodFinder methodFinder = RuntimeMethodFinder.get((CompilationContext)this.ctxt);
        LiteralFactory lf = this.getLiteralFactory();
        if (dimensions.isDefEq((Value)lf.literalOf((IntegerType)this.ctxt.getTypeSystem().getUnsignedInteger8Type(), 0L))) {
            MethodElement methodElement = methodFinder.getMethod("getClassFromTypeIdSimple");
            return this.notNull(this.getFirstBuilder().call((Value)lf.literalOf(methodElement), List.of(typeId)));
        }
        MethodElement methodElement = methodFinder.getMethod("getClassFromTypeId");
        return this.notNull(this.getFirstBuilder().call((Value)lf.literalOf(methodElement), List.of(typeId, dimensions)));
    }

    private boolean generateTypeTest(Value input, ObjectType toType, int toDimensions, BlockLabel pass, BlockLabel fail) {
        if (toDimensions != 0) {
            return false;
        }
        LiteralFactory lf = this.ctxt.getLiteralFactory();
        if (toType instanceof PrimitiveArrayObjectType) {
            DefinedTypeDefinition dtd = CoreClasses.get((CompilationContext)this.ctxt).getArrayContentField(toType).getEnclosingType();
            LoadedTypeDefinition arrayVTD = dtd.load();
            int primArrayTypeId = arrayVTD.getTypeId();
            Value inputTypeId = this.load(this.instanceFieldOf(this.decodeReference(input), CoreClasses.get((CompilationContext)this.ctxt).getObjectTypeIdField()));
            this.if_(this.isEq(inputTypeId, (Value)lf.literalOf(primArrayTypeId)), pass, fail, Map.of());
        } else if (toType instanceof InterfaceObjectType) {
            SupersDisplayTables tables = SupersDisplayTables.get(this.ctxt);
            LoadedTypeDefinition vtdExpectedType = toType.getDefinition().load();
            int byteIndex = tables.getInterfaceByteIndex(vtdExpectedType);
            int mask = tables.getInterfaceBitMask(vtdExpectedType);
            GlobalVariableElement typeIdGlobal = tables.getAndRegisterGlobalTypeIdArray(this.getDelegate().getCurrentElement());
            Value inputTypeId = this.load(this.instanceFieldOf(this.decodeReference(input), CoreClasses.get((CompilationContext)this.ctxt).getObjectTypeIdField()));
            Value typeIdStruct = this.elementOf((Value)lf.literalOf(typeIdGlobal), inputTypeId);
            Value bits = this.memberOf(typeIdStruct, tables.getGlobalTypeIdStructType().getMember("interfaceBits"));
            Value thisByte = this.load(this.elementOf(bits, (Value)lf.literalOf(byteIndex)));
            Value maskedValue = this.and(thisByte, (Value)lf.literalOf(mask));
            this.if_(this.isEq(maskedValue, (Value)lf.literalOf(mask)), pass, fail, Map.of());
        } else {
            ClassObjectType cotExpectedType = (ClassObjectType)toType;
            LoadedTypeDefinition vtdExpectedType = cotExpectedType.getDefinition().load();
            Value inputTypeId = this.load(this.instanceFieldOf(this.decodeReference(input), CoreClasses.get((CompilationContext)this.ctxt).getObjectTypeIdField()));
            int typeId = vtdExpectedType.getTypeId();
            int maxSubId = vtdExpectedType.getMaximumSubtypeId();
            IntegerLiteral vtdTypeId = lf.literalOf(typeId);
            if (typeId == maxSubId) {
                this.if_(this.isEq(inputTypeId, (Value)vtdTypeId), pass, fail, Map.of());
            } else {
                IntegerLiteral allowedRange = lf.literalOf(maxSubId - typeId);
                Value subtract = this.sub(inputTypeId, (Value)vtdTypeId);
                this.if_(this.isLe(subtract, (Value)allowedRange), pass, fail, Map.of());
            }
        }
        return true;
    }

    private boolean generateTypeTest(Value input, Value toType, Value toDimensions, ObjectType shape, BlockLabel pass, BlockLabel fail) {
        if (shape instanceof ClassObjectType && shape.hasSuperClass()) {
            SupersDisplayTables tables = SupersDisplayTables.get(this.ctxt);
            GlobalVariableElement typeIdGlobal = tables.getAndRegisterGlobalTypeIdArray(this.getDelegate().getCurrentElement());
            Value typeIdStruct = this.elementOf((Value)this.ctxt.getLiteralFactory().literalOf(typeIdGlobal), toType);
            Value maxTypeId = this.load(this.memberOf(typeIdStruct, tables.getGlobalTypeIdStructType().getMember("maxSubTypeId")));
            Value valueTypeId = this.load(this.instanceFieldOf(this.decodeReference(input), CoreClasses.get((CompilationContext)this.ctxt).getObjectTypeIdField()));
            this.if_(this.and(this.isLe(toType, valueTypeId), this.isLe(valueTypeId, maxTypeId)), pass, fail, Map.of());
            return true;
        }
        return false;
    }

    private boolean isAlwaysAssignable(ValueType inputValueType, ObjectType toType, int toDimensions) {
        if (!(inputValueType instanceof ReferenceType)) {
            return false;
        }
        ReferenceType inputType = (ReferenceType)inputValueType;
        if (toDimensions == 0) {
            return inputType.instanceOf(toType);
        }
        if (inputType.getUpperBound() instanceof ReferenceArrayObjectType) {
            ReferenceArrayObjectType inputArrayType = (ReferenceArrayObjectType)inputType.getUpperBound();
            if (inputArrayType.getDimensionCount() == toDimensions) {
                return inputType.instanceOf(inputArrayType.getElementType());
            }
            if (inputArrayType.getDimensionCount() > toDimensions) {
                return !toType.hasSuperClass();
            }
        }
        return false;
    }

    private boolean isEffectivelyFinal(ObjectType type) {
        int maxSubId;
        if (type instanceof PrimitiveArrayObjectType) {
            return true;
        }
        if (type instanceof ReferenceArrayObjectType || type instanceof InterfaceObjectType) {
            return false;
        }
        LoadedTypeDefinition vtd = type.getDefinition().load();
        int typeId = vtd.getTypeId();
        return typeId == (maxSubId = vtd.getMaximumSubtypeId());
    }
}

