/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.instanceofcheckcast;

import io.smallrye.common.constraint.Assert;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.IntStream;
import org.jboss.logging.Logger;
import org.qbicc.context.AttachmentKey;
import org.qbicc.context.CompilationContext;
import org.qbicc.graph.Value;
import org.qbicc.graph.literal.IntegerLiteral;
import org.qbicc.graph.literal.Literal;
import org.qbicc.graph.literal.LiteralFactory;
import org.qbicc.object.Function;
import org.qbicc.object.ProgramObject;
import org.qbicc.object.Section;
import org.qbicc.plugin.reachability.ReachabilityInfo;
import org.qbicc.type.ArrayType;
import org.qbicc.type.CompoundType;
import org.qbicc.type.FunctionType;
import org.qbicc.type.IntegerType;
import org.qbicc.type.Primitive;
import org.qbicc.type.TypeSystem;
import org.qbicc.type.UnsignedIntegerType;
import org.qbicc.type.ValueType;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.LoadedTypeDefinition;
import org.qbicc.type.definition.element.ExecutableElement;
import org.qbicc.type.definition.element.GlobalVariableElement;
import org.qbicc.type.definition.element.InitializerElement;
import org.qbicc.type.descriptor.BaseTypeDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;
import org.qbicc.type.generic.BaseTypeSignature;
import org.qbicc.type.generic.TypeSignature;

public class SupersDisplayTables {
    private static final Logger log = Logger.getLogger((String)"org.qbicc.plugin.instanceofcheckcast");
    private static final Logger supersLog = Logger.getLogger((String)"org.qbicc.plugin.instanceofcheckcast.supers");
    private static final AttachmentKey<SupersDisplayTables> KEY = new AttachmentKey();
    private static final LoadedTypeDefinition[] INVALID_DISPLAY = new LoadedTypeDefinition[0];
    private final CompilationContext ctxt;
    private final Map<LoadedTypeDefinition, LoadedTypeDefinition[]> supers = new ConcurrentHashMap<LoadedTypeDefinition, LoadedTypeDefinition[]>();
    private final Map<LoadedTypeDefinition, IdAndRange> typeids = new ConcurrentHashMap<LoadedTypeDefinition, IdAndRange>();
    static final String GLOBAL_TYPEID_ARRAY = "qbicc_typeid_array";
    private GlobalVariableElement typeIdArrayGlobal;
    private CompoundType typeIdStructType;
    static final String GLOBAL_CLINIT_STATES_STRUCT = "qbicc_clinit_states";
    private GlobalVariableElement clinitStatesGlobal;
    private final IdAndRange.Factory idAndRange = new IdAndRange.Factory();
    private int maxDisplaySizeElements;

    private SupersDisplayTables(CompilationContext ctxt) {
        this.ctxt = ctxt;
    }

    public static SupersDisplayTables get(CompilationContext ctxt) {
        SupersDisplayTables appearing;
        SupersDisplayTables dt = (SupersDisplayTables)ctxt.getAttachment(KEY);
        if (dt == null && (appearing = (SupersDisplayTables)ctxt.putAttachmentIfAbsent(KEY, (Object)(dt = new SupersDisplayTables(ctxt)))) != null) {
            dt = appearing;
        }
        return dt;
    }

    /*
     * Exception decompiling
     */
    public LoadedTypeDefinition[] getSupersDisplay(LoadedTypeDefinition cls) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void buildSupersDisplay(LoadedTypeDefinition cls) {
        log.debug((Object)("Building SupersDisplay for: " + cls.getDescriptor()));
        LoadedTypeDefinition[] supersArray = this.getSupersDisplay(cls);
        if (supersArray == INVALID_DISPLAY) {
            ReachabilityInfo info = ReachabilityInfo.get((CompilationContext)this.ctxt);
            ArrayList<LoadedTypeDefinition> superDisplay = new ArrayList<LoadedTypeDefinition>();
            LoadedTypeDefinition next = cls;
            do {
                superDisplay.add(next);
                if (info.isReachableClass(next)) continue;
                log.debug((Object)("Found RTA non-live super: " + cls.getDescriptor()));
            } while ((next = next.getSuperClass()) != null);
            Collections.reverse(superDisplay);
            this.maxDisplaySizeElements = Math.max(this.maxDisplaySizeElements, superDisplay.size());
            supersArray = superDisplay.toArray(INVALID_DISPLAY);
            this.supers.put(cls, supersArray);
        }
        log.debug((Object)("Display size: " + supersArray.length));
    }

    public void statistics() {
        HashMap histogram = new HashMap();
        this.supers.values().stream().forEach(vtd -> {
            Integer column = ((LoadedTypeDefinition[])vtd).length;
            Integer count = histogram.getOrDefault(column, 0);
            count = count + 1;
            histogram.put(column, count);
        });
        supersLog.debug((Object)"Supers display statistics: [size, occurrance]");
        histogram.entrySet().stream().forEach(es -> supersLog.debug((Object)("\t[" + es.getKey() + ", " + es.getValue() + "]")));
        int numClasses = this.supers.size();
        supersLog.debug((Object)("Classes: " + numClasses));
        supersLog.debug((Object)("Max display size: " + this.maxDisplaySizeElements));
        supersLog.debug((Object)("Slots of storage: " + numClasses * this.maxDisplaySizeElements));
        int emptySlots = histogram.entrySet().stream().flatMapToInt(es -> {
            int waste = this.maxDisplaySizeElements - (Integer)es.getKey();
            return IntStream.of(waste *= ((Integer)es.getValue()).intValue());
        }).sum();
        supersLog.debug((Object)("Slots of waste: " + emptySlots));
        supersLog.debug((Object)"typeid and range");
        this.typeids.entrySet().stream().sorted((a, b) -> ((IdAndRange)a.getValue()).typeid - ((IdAndRange)b.getValue()).typeid).forEach(es -> {
            LoadedTypeDefinition vtd = (LoadedTypeDefinition)es.getKey();
            IdAndRange idRange = (IdAndRange)es.getValue();
            supersLog.debug((Object)(idRange.toString() + " " + vtd.getInternalName()));
        });
        int bytesPerClass = this.getNumberOfBytesInInterfaceBitsArray();
        supersLog.debug((Object)"===============");
        supersLog.debug((Object)("Implemented interface bits require " + bytesPerClass + " bytes per class"));
        supersLog.debug((Object)("classes + interfaces = " + this.typeids.size()));
        supersLog.debug((Object)("Interface bits[] space (in bytes): " + this.typeids.size() * bytesPerClass));
    }

    void assignTypeIdToPrimitives() {
        Primitive.forEach(type -> type.setTypeId(this.idAndRange.nextID().typeid));
    }

    void assignTypeID(LoadedTypeDefinition cls) {
        IdAndRange myID = this.typeids.computeIfAbsent(cls, theCls -> this.idAndRange.nextID());
        log.debug((Object)("[" + myID.typeid + "] Class: " + cls.getInternalName()));
    }

    void assignMaximumSubtypeId(LoadedTypeDefinition cls) {
        IdAndRange superID;
        IdAndRange myID = this.typeids.get(cls);
        log.debug((Object)("Visiting: " + cls.getInternalName() + " " + myID.toString()));
        LoadedTypeDefinition superclass = cls.getSuperClass();
        if (superclass != null && (superID = (IdAndRange)this.typeids.getOrDefault(superclass, null)) != null) {
            superID.setMaximumSubtypeId(myID.maximumSubtypeId);
            log.debug((Object)("Setting Super's max subtype id: " + superclass.getInternalName() + " " + superID.toString()));
        }
    }

    void assignInterfaceId(LoadedTypeDefinition cls) {
        Assert.assertTrue((boolean)cls.isInterface());
        this.typeids.computeIfAbsent(cls, theInterface -> this.idAndRange.nextInterfaceID());
    }

    void updateJLORange(LoadedTypeDefinition jlo) {
        Assert.assertTrue((jlo.getSuperClass() == null ? 1 : 0) != 0);
        IdAndRange r = this.typeids.get(jlo);
        r.maximumSubtypeId = this.idAndRange.typeid_index - 1;
    }

    void reserveTypeIds(int numToReserve) {
        Assert.assertTrue((numToReserve >= 0 ? 1 : 0) != 0);
        this.idAndRange.typeid_index += numToReserve;
    }

    void writeTypeIdToClasses() {
        this.typeids.entrySet().stream().forEach(es -> {
            LoadedTypeDefinition vtd = (LoadedTypeDefinition)es.getKey();
            IdAndRange idRange = (IdAndRange)es.getValue();
            vtd.assignTypeId(idRange.typeid);
            vtd.assignMaximumSubtypeId(idRange.maximumSubtypeId);
        });
    }

    public int getFirstInterfaceTypeId() {
        return this.idAndRange.first_interface_typeid;
    }

    int getNumberOfInterfacesInTypeIds() {
        return this.typeids.size() - this.idAndRange.first_interface_typeid + 10;
    }

    public int getNumberOfBytesInInterfaceBitsArray() {
        int numInterfaces = this.getNumberOfInterfacesInTypeIds();
        return (numInterfaces + 8 - 1) / 8;
    }

    byte[] getImplementedInterfaceBits(LoadedTypeDefinition cls) {
        byte[] setBits = new byte[this.getNumberOfBytesInInterfaceBitsArray()];
        cls.forEachInterfaceFullImplementedSet(i -> {
            IdAndRange idRange = this.typeids.get(i);
            if (idRange != null) {
                int index;
                int n = index = idRange.implementedInterfaceByteIndex();
                setBits[n] = (byte)(setBits[n] | idRange.implementedInterfaceBitMask());
            }
        });
        return setBits;
    }

    public int getInterfaceByteIndex(LoadedTypeDefinition cls) {
        Assert.assertTrue((boolean)cls.isInterface());
        IdAndRange idRange = this.typeids.get(cls);
        if (idRange == null) {
            throw new IllegalStateException();
        }
        return idRange.implementedInterfaceByteIndex();
    }

    public int getInterfaceBitMask(LoadedTypeDefinition cls) {
        Assert.assertTrue((boolean)cls.isInterface());
        IdAndRange idRange = this.typeids.get(cls);
        return idRange.implementedInterfaceBitMask();
    }

    List<Literal> convertByteArrayToValuesList(LiteralFactory literalFactory, byte[] array) {
        Literal[] literals = new Literal[array.length];
        for (int i = 0; i < array.length; ++i) {
            literals[i] = literalFactory.literalOf(array[i]);
        }
        return List.of(literals);
    }

    Literal calculateTypeIdFlags(UnsignedIntegerType type, LoadedTypeDefinition ltd) {
        int flags = 0;
        InitializerElement initializer = ltd.getInitializer();
        if (initializer != null && initializer.hasMethodBody()) {
            flags |= 1;
        }
        if (ltd.declaresDefaultMethods()) {
            flags |= 2;
        }
        if (ltd.hasDefaultMethods()) {
            flags |= 4;
        }
        LiteralFactory lf = this.ctxt.getLiteralFactory();
        supersLog.debug((Object)("[[Flags] ID[" + ltd.getTypeId() + "] Flags = " + Integer.toBinaryString(flags) + " : " + ltd.getInternalName() + "]"));
        return lf.literalOf((IntegerType)type, (long)flags);
    }

    void defineTypeIdStructAndGlobalArray(LoadedTypeDefinition jlo) {
        TypeSystem ts = this.ctxt.getTypeSystem();
        UnsignedIntegerType u8 = ts.getUnsignedInteger8Type();
        int typeIdSize = ts.getTypeIdSize();
        UnsignedIntegerType uTypeId = switch (typeIdSize) {
            case 1 -> ts.getUnsignedInteger8Type();
            case 2 -> ts.getUnsignedInteger16Type();
            case 4 -> ts.getUnsignedInteger32Type();
            case 8 -> ts.getUnsignedInteger64Type();
            default -> throw Assert.impossibleSwitchCase((Object)("#getTypeIdSize() must be one of {1,2,4,8} - was: " + typeIdSize));
        };
        supersLog.debug((Object)("typeIdSize set to: " + uTypeId.toFriendlyString(new StringBuilder()).toString()));
        Assert.assertTrue((typeIdSize <= uTypeId.getMinBits() ? 1 : 0) != 0);
        int numInterfaces = this.getNumberOfInterfacesInTypeIds();
        supersLog.debug((Object)("NumInterfaces=" + numInterfaces + " numBytes=" + this.getNumberOfBytesInInterfaceBitsArray()));
        ArrayType interfaceBitsType = ts.getArrayType((ValueType)u8, (long)this.getNumberOfBytesInInterfaceBitsArray());
        UnsignedIntegerType u32 = ts.getUnsignedInteger32Type();
        CompoundType typeIdStruct = CompoundType.builder((TypeSystem)ts).setTag(CompoundType.Tag.STRUCT).setName("typeIds").setOverallAlignment(ts.getPointerAlignment()).addNextMember("typedId", (ValueType)uTypeId).addNextMember("maxSubTypeId", (ValueType)uTypeId).addNextMember("superTypeId", (ValueType)uTypeId).addNextMember("interfaceBits", (ValueType)interfaceBitsType).addNextMember("flags", (ValueType)u32).build();
        ArrayType typeIdsArrayType = ts.getArrayType((ValueType)typeIdStruct, (long)this.get_number_of_typeids());
        GlobalVariableElement.Builder builder = GlobalVariableElement.builder((String)GLOBAL_TYPEID_ARRAY, (TypeDescriptor)BaseTypeDescriptor.V);
        builder.setType((ValueType)typeIdsArrayType);
        builder.setEnclosingType((DefinedTypeDefinition)jlo);
        builder.setSignature((TypeSignature)BaseTypeSignature.V);
        this.typeIdArrayGlobal = builder.build();
        this.typeIdStructType = typeIdStruct;
    }

    void emitTypeIdTable(LoadedTypeDefinition jlo) {
        LiteralFactory lf = this.ctxt.getLiteralFactory();
        ArrayList<IntegerLiteral> primitivesInterfaceBits = new ArrayList<IntegerLiteral>();
        IntegerLiteral zero = lf.literalOf(0);
        ArrayType interfaceBitsType = (ArrayType)this.typeIdStructType.getMember("interfaceBits").getType();
        int i = 0;
        while ((long)i < interfaceBitsType.getElementCount()) {
            primitivesInterfaceBits.add(zero);
            ++i;
        }
        List members = this.typeIdStructType.getMembers();
        Literal[] typeIdTable = new Literal[this.get_number_of_typeids()];
        for (int i2 = 0; i2 < 10; ++i2) {
            typeIdTable[i2] = lf.literalOf(this.typeIdStructType, Map.of((CompoundType.Member)members.get(0), lf.literalOf((IntegerType)((UnsignedIntegerType)((CompoundType.Member)members.get(0)).getType()), (long)i2), (CompoundType.Member)members.get(1), lf.literalOf((IntegerType)((UnsignedIntegerType)((CompoundType.Member)members.get(1)).getType()), (long)i2), (CompoundType.Member)members.get(2), lf.literalOf((IntegerType)((UnsignedIntegerType)((CompoundType.Member)members.get(2)).getType()), 0L), (CompoundType.Member)members.get(3), lf.literalOf(interfaceBitsType, primitivesInterfaceBits), (CompoundType.Member)members.get(4), lf.literalOf((IntegerType)((UnsignedIntegerType)((CompoundType.Member)members.get(4)).getType()), 0L)));
        }
        for (Map.Entry<LoadedTypeDefinition, IdAndRange> e : this.typeids.entrySet()) {
            LoadedTypeDefinition vtd = e.getKey();
            IdAndRange idRange = e.getValue();
            int superTypeId = 0;
            if (vtd.hasSuperClass()) {
                IdAndRange superRange = this.typeids.get(vtd.getSuperClass());
                superTypeId = superRange.typeid;
            }
            typeIdTable[vtd.getTypeId()] = lf.literalOf(this.typeIdStructType, Map.of((CompoundType.Member)members.get(0), lf.literalOf((IntegerType)((UnsignedIntegerType)((CompoundType.Member)members.get(0)).getType()), (long)idRange.typeid), (CompoundType.Member)members.get(1), lf.literalOf((IntegerType)((UnsignedIntegerType)((CompoundType.Member)members.get(1)).getType()), (long)idRange.maximumSubtypeId), (CompoundType.Member)members.get(2), lf.literalOf((IntegerType)((UnsignedIntegerType)((CompoundType.Member)members.get(2)).getType()), (long)superTypeId), (CompoundType.Member)members.get(3), lf.literalOf(interfaceBitsType, this.convertByteArrayToValuesList(lf, this.getImplementedInterfaceBits(vtd))), (CompoundType.Member)members.get(4), this.calculateTypeIdFlags((UnsignedIntegerType)((CompoundType.Member)members.get(4)).getType(), vtd)));
        }
        Literal typeIdsValue = this.ctxt.getLiteralFactory().literalOf((ArrayType)this.typeIdArrayGlobal.getType(), List.of(typeIdTable));
        Section section = this.ctxt.getImplicitSection((DefinedTypeDefinition)jlo);
        section.addData(null, GLOBAL_TYPEID_ARRAY, (Value)typeIdsValue);
    }

    public GlobalVariableElement getAndRegisterGlobalTypeIdArray(ExecutableElement originalElement) {
        Assert.assertNotNull((Object)this.typeIdArrayGlobal);
        if (!this.typeIdArrayGlobal.getEnclosingType().equals(originalElement.getEnclosingType())) {
            Section section = this.ctxt.getImplicitSection(originalElement.getEnclosingType());
            section.declareData(null, this.typeIdArrayGlobal.getName(), this.typeIdArrayGlobal.getType());
        }
        return this.typeIdArrayGlobal;
    }

    public CompoundType getGlobalTypeIdStructType() {
        Assert.assertNotNull((Object)this.typeIdStructType);
        return this.typeIdStructType;
    }

    public int get_number_of_typeids() {
        Assert.assertTrue((this.idAndRange.typeid_index == this.typeids.size() + 10 ? 1 : 0) != 0);
        supersLog.debug((Object)("get_highest_typeid == " + (this.typeids.size() + 10)));
        return this.typeids.size() + 10;
    }

    public GlobalVariableElement getAndRegisterGlobalClinitStateStruct(ExecutableElement originalElement) {
        Assert.assertNotNull((Object)this.clinitStatesGlobal);
        if (!this.clinitStatesGlobal.getEnclosingType().equals(originalElement.getEnclosingType())) {
            Section section = this.ctxt.getImplicitSection(originalElement.getEnclosingType());
            section.declareData(null, this.clinitStatesGlobal.getName(), this.clinitStatesGlobal.getType());
        }
        return this.clinitStatesGlobal;
    }

    public void defineClinitStatesGlobal(LoadedTypeDefinition jlo) {
        TypeSystem ts = this.ctxt.getTypeSystem();
        int numElements = this.get_number_of_typeids();
        FunctionType clinit_function_type = null;
        for (LoadedTypeDefinition ltd : this.typeids.keySet()) {
            InitializerElement ie = ltd.getInitializer();
            if (ie == null) continue;
            clinit_function_type = this.ctxt.getFunctionTypeForElement((ExecutableElement)ie);
            break;
        }
        ArrayType init_state_t = ts.getArrayType((ValueType)ts.getUnsignedInteger8Type(), (long)numElements);
        ArrayType class_initializers_t = ts.getArrayType((ValueType)clinit_function_type.getPointer(), (long)numElements);
        CompoundType clinit_state_t = CompoundType.builder((TypeSystem)ts).setTag(CompoundType.Tag.STRUCT).setName("qbicc_clinit_state").setOverallAlignment(ts.getPointerAlignment()).addNextMember("init_state", (ValueType)init_state_t).addNextMember("class_initializers", (ValueType)class_initializers_t).build();
        GlobalVariableElement.Builder builder = GlobalVariableElement.builder((String)GLOBAL_CLINIT_STATES_STRUCT, (TypeDescriptor)BaseTypeDescriptor.V);
        builder.setType((ValueType)clinit_state_t);
        builder.setEnclosingType((DefinedTypeDefinition)jlo);
        builder.setSignature((TypeSignature)BaseTypeSignature.V);
        this.clinitStatesGlobal = builder.build();
    }

    public void emitClinitStateTable(LoadedTypeDefinition jlo) {
        int numElements = this.get_number_of_typeids();
        CompoundType clinit_state_t = (CompoundType)this.clinitStatesGlobal.getType();
        Section section = this.ctxt.getImplicitSection((DefinedTypeDefinition)jlo);
        LiteralFactory lf = this.ctxt.getLiteralFactory();
        ArrayList<IntegerLiteral> init_state_literals = new ArrayList<IntegerLiteral>();
        ArrayList<Literal> class_initializers_literals = new ArrayList<Literal>();
        IntegerLiteral uninitialized = lf.literalOf(0);
        IntegerLiteral initialized = lf.literalOf(1);
        Literal nullInitializer = lf.zeroInitializerLiteralOfType(clinit_state_t.getMember("class_initializers").getType());
        ReachabilityInfo info = ReachabilityInfo.get((CompilationContext)this.ctxt);
        init_state_literals.add(uninitialized);
        class_initializers_literals.add(nullInitializer);
        for (int i = 1; i < 10; ++i) {
            init_state_literals.add(initialized);
            class_initializers_literals.add(nullInitializer);
        }
        this.typeids.entrySet().stream().sorted((a, b) -> ((IdAndRange)a.getValue()).typeid - ((IdAndRange)b.getValue()).typeid).forEach(arg_0 -> this.lambda$emitClinitStateTable$13((Literal)initialized, nullInitializer, (Literal)uninitialized, info, jlo, section, init_state_literals, class_initializers_literals, arg_0));
        Assert.assertTrue((init_state_literals.size() == numElements ? 1 : 0) != 0);
        ArrayType init_states = (ArrayType)clinit_state_t.getMember("init_state").getType();
        ArrayType class_initializers = (ArrayType)clinit_state_t.getMember("class_initializers").getType();
        Literal clinit_states = lf.literalOf(clinit_state_t, Map.of(clinit_state_t.getMember(0), lf.literalOf(init_states, init_state_literals), clinit_state_t.getMember(1), lf.literalOf(class_initializers, class_initializers_literals)));
        section.addData(null, GLOBAL_CLINIT_STATES_STRUCT, (Value)clinit_states);
    }

    boolean isAlreadyInitialized(LoadedTypeDefinition ltd) {
        if (ltd.internalNameEquals("org/qbicc/runtime/main/VMHelpers$ClinitState")) {
            return true;
        }
        return ltd.internalNameEquals("org/qbicc/runtime/main/ObjectModel");
    }

    private /* synthetic */ void lambda$emitClinitStateTable$13(Literal initialized, Literal nullInitializer, Literal uninitialized, ReachabilityInfo info, LoadedTypeDefinition jlo, Section section, List init_state_literals, List class_initializers_literals, Map.Entry es) {
        LoadedTypeDefinition ltd = (LoadedTypeDefinition)es.getKey();
        Literal init_state = initialized;
        Literal initializer = nullInitializer;
        if (!this.isAlreadyInitialized(ltd)) {
            InitializerElement ie;
            init_state = uninitialized;
            if (info.isInitializedType(ltd) && (ie = ltd.getInitializer()) != null && ie.hasMethodBody() && this.ctxt.wasEnqueued((ExecutableElement)ie)) {
                FunctionType funType = this.ctxt.getFunctionTypeForElement((ExecutableElement)ie);
                Function impl = this.ctxt.getExactFunction((ExecutableElement)ie);
                if (!ie.getEnclosingType().load().equals(jlo)) {
                    section.declareFunction((ExecutableElement)ie, impl.getName(), funType);
                }
                initializer = this.ctxt.getLiteralFactory().literalOf((ProgramObject)impl);
            }
        }
        init_state_literals.add(init_state);
        class_initializers_literals.add(initializer);
    }

    private static /* synthetic */ LoadedTypeDefinition[] lambda$getSupersDisplay$1(LoadedTypeDefinition theCls) {
        return new LoadedTypeDefinition[]{theCls};
    }

    static class IdAndRange {
        private final Factory constants;
        int typeid;
        int maximumSubtypeId;

        IdAndRange(int id, Factory factory) {
            this.typeid = id;
            this.maximumSubtypeId = id;
            this.constants = factory;
        }

        public void setMaximumSubtypeId(int id) {
            this.maximumSubtypeId = Math.max(this.maximumSubtypeId, id);
        }

        public String toString() {
            String s = "ID[" + this.typeid + "] Range[" + this.typeid + ", " + this.maximumSubtypeId + "]";
            if (this.typeid >= this.constants.first_interface_typeid) {
                int bit = this.typeid - this.constants.first_interface_typeid;
                s = s + " indexBit[" + bit + "]";
                s = s + " byte[" + this.implementedInterfaceByteIndex() + "]";
                s = s + " mask[" + Integer.toBinaryString(1 << (bit & 7)) + "]";
            }
            return s;
        }

        int implementedInterfaceByteIndex() {
            if (this.typeid >= this.constants.first_interface_typeid) {
                int bit = this.typeid - this.constants.first_interface_typeid;
                return bit >> 3;
            }
            return -1;
        }

        int implementedInterfaceBitMask() {
            if (this.typeid >= this.constants.first_interface_typeid) {
                int bit = this.typeid - this.constants.first_interface_typeid;
                return 1 << (bit & 7);
            }
            return 0;
        }

        static class Factory {
            static final int interfaces_per_byte = 8;
            private int typeid_index = 0;
            private int first_interface_typeid = 0;

            Factory() {
            }

            public IdAndRange nextID() {
                return new IdAndRange(this.typeid_index++, this);
            }

            public IdAndRange nextInterfaceID() {
                if (this.first_interface_typeid == 0) {
                    this.first_interface_typeid = this.typeid_index;
                }
                return new IdAndRange(this.typeid_index++, this);
            }
        }
    }
}

