/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.initializationcontrol;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import org.qbicc.context.CompilationContext;
import org.qbicc.plugin.initializationcontrol.InitAtRuntimeRegistry;
import org.qbicc.plugin.initializationcontrol.QbiccFeature;
import org.qbicc.plugin.initializationcontrol.RuntimeResourceManager;
import org.qbicc.plugin.reflection.ReflectiveElementRegistry;

public class QbiccFeatureProcessor {
    public static void process(CompilationContext ctxt, List<URL> yamlFeatures, List<QbiccFeature> features) {
        if (yamlFeatures.isEmpty() && features.isEmpty()) {
            return;
        }
        InitAtRuntimeRegistry fp = InitAtRuntimeRegistry.get(ctxt);
        RuntimeResourceManager rm = RuntimeResourceManager.get(ctxt);
        ReflectiveElementRegistry re = ReflectiveElementRegistry.get((CompilationContext)ctxt);
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        mapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        for (URL feature : yamlFeatures) {
            try {
                InputStream fs = feature.openStream();
                try {
                    QbiccFeature yf = (QbiccFeature)mapper.readValue(fs, QbiccFeature.class);
                    QbiccFeatureProcessor.processFeature(yf, fp, rm, re);
                }
                finally {
                    if (fs == null) continue;
                    fs.close();
                }
            }
            catch (IOException e) {
                ctxt.error((Throwable)e, "Failed to read qbicc-feature %s ", new Object[]{feature});
            }
        }
        for (QbiccFeature f : features) {
            QbiccFeatureProcessor.processFeature(f, fp, rm, re);
        }
    }

    private static void processFeature(QbiccFeature qf, InitAtRuntimeRegistry fp, RuntimeResourceManager rm, ReflectiveElementRegistry re) {
        if (qf.initializeAtRuntime != null) {
            for (String string : qf.initializeAtRuntime) {
                String internalName = string.replace('.', '/');
                fp.addRuntimeInitializedClass(internalName);
            }
        }
        if (qf.runtimeResource != null) {
            for (String string : qf.runtimeResource) {
                rm.addResource(string);
            }
        }
        if (qf.runtimeResources != null) {
            for (String string : qf.runtimeResources) {
                rm.addResources(string);
            }
        }
        if (qf.reflectiveClasses != null) {
            for (QbiccFeature.ReflectiveClass reflectiveClass : qf.reflectiveClasses) {
                re.addReflectiveClass(reflectiveClass.name.replace('.', '/'), reflectiveClass.fields, reflectiveClass.methods, reflectiveClass.constructors);
            }
        }
        if (qf.reflectiveConstructors != null) {
            for (QbiccFeature.Constructor constructor : qf.reflectiveConstructors) {
                re.addReflectiveConstructor(constructor.declaringClass.replace('.', '/'), constructor.arguments);
            }
        }
        if (qf.reflectiveFields != null) {
            for (QbiccFeature.Field field : qf.reflectiveFields) {
                re.addReflectiveField(field.declaringClass.replace('.', '/'), field.name);
            }
        }
        if (qf.reflectiveMethods != null) {
            for (QbiccFeature.Method method : qf.reflectiveMethods) {
                re.addReflectiveMethod(method.declaringClass.replace('.', '/'), method.name, method.arguments);
            }
        }
    }
}

