/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.initializationcontrol;

import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.qbicc.context.AttachmentKey;
import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.interpreter.Vm;
import org.qbicc.interpreter.VmClassLoader;
import org.qbicc.plugin.apploader.AppClassLoader;
import org.qbicc.type.definition.LoadedTypeDefinition;
import org.qbicc.type.definition.element.MethodElement;

public class RuntimeResourceManager {
    private static final AttachmentKey<RuntimeResourceManager> KEY = new AttachmentKey();
    private final CompilationContext ctxt;
    private final Set<String> runtimeResource = ConcurrentHashMap.newKeySet();
    private final Set<String> runtimeResources = ConcurrentHashMap.newKeySet();

    RuntimeResourceManager(CompilationContext ctxt) {
        this.ctxt = ctxt;
    }

    public static RuntimeResourceManager get(CompilationContext ctxt) {
        RuntimeResourceManager appearing;
        RuntimeResourceManager patcher = (RuntimeResourceManager)ctxt.getAttachment(KEY);
        if (patcher == null && (appearing = (RuntimeResourceManager)ctxt.putAttachmentIfAbsent(KEY, (Object)(patcher = new RuntimeResourceManager(ctxt)))) != null) {
            patcher = appearing;
        }
        return patcher;
    }

    public void addResource(String name) {
        this.runtimeResource.add(name);
    }

    public void addResources(String name) {
        this.runtimeResources.add(name);
    }

    public void findAndSerializeResources() {
        Object bytes;
        if (this.runtimeResource.isEmpty() && this.runtimeResources.isEmpty()) {
            return;
        }
        VmClassLoader appCl = AppClassLoader.get((CompilationContext)this.ctxt).getAppClassLoader();
        ClassContext appContext = appCl.getClassContext();
        LoadedTypeDefinition nir = appContext.findDefinedType("jdk/internal/loader/NativeImageResources").load();
        MethodElement addResource = nir.requireSingleMethod("addResource");
        Vm vm = appContext.getCompilationContext().getVm();
        for (String name : this.runtimeResource) {
            bytes = appContext.getResource(name);
            if (bytes == null) continue;
            vm.invokeExact(addResource, null, List.of(appCl, name, vm.newByteArray(bytes)));
        }
        for (String name : this.runtimeResources) {
            bytes = appContext.getResources(name);
            for (byte[] byArray : bytes) {
                vm.invokeExact(addResource, null, List.of(appCl, name, vm.newByteArray(byArray)));
            }
        }
    }
}

