/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.initializationcontrol;

import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.plugin.initializationcontrol.FeaturePatcher;
import org.qbicc.plugin.patcher.OnceRunTimeInitializerResolver;
import org.qbicc.plugin.reachability.ReachabilityRoots;
import org.qbicc.type.definition.ConstructorResolver;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.FieldResolver;
import org.qbicc.type.definition.InitializerResolver;
import org.qbicc.type.definition.MethodResolver;
import org.qbicc.type.definition.element.ConstructorElement;
import org.qbicc.type.definition.element.FieldElement;
import org.qbicc.type.definition.element.InitializerElement;
import org.qbicc.type.definition.element.MethodElement;
import org.qbicc.type.descriptor.MethodDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;

public class QbiccFeatureTypeBuilder
implements DefinedTypeDefinition.Builder.Delegating {
    private final DefinedTypeDefinition.Builder delegate;
    private final ClassContext classContext;
    private boolean runtimeInitialized;
    private boolean reflectiveFields;
    private boolean reflectiveConstructors;
    private boolean reflectiveMethods;
    private InitializerResolver initResolver;
    private int initIndex;

    public QbiccFeatureTypeBuilder(ClassContext classCtxt, DefinedTypeDefinition.Builder delegate) {
        this.delegate = delegate;
        this.classContext = classCtxt;
    }

    public DefinedTypeDefinition.Builder getDelegate() {
        return this.delegate;
    }

    public void setName(String internalName) {
        FeaturePatcher fp = FeaturePatcher.get(this.classContext.getCompilationContext());
        if (fp.isRuntimeInitializedClass(internalName)) {
            this.runtimeInitialized = true;
        }
        if (fp.hasReflectiveConstructors(internalName)) {
            this.reflectiveConstructors = true;
        }
        if (fp.hasReflectiveFields(internalName)) {
            this.reflectiveFields = true;
        }
        if (fp.hasReflectiveMethods(internalName)) {
            this.reflectiveMethods = true;
        }
        this.delegate.setName(internalName);
    }

    public void setInitializer(InitializerResolver resolver, int index) {
        if (this.runtimeInitialized) {
            this.initResolver = new OnceRunTimeInitializerResolver(resolver);
            this.initIndex = index;
            this.delegate.setInitializer(resolver, -1);
        } else {
            this.delegate.setInitializer(resolver, index);
        }
    }

    public void addConstructor(final ConstructorResolver resolver, int index, MethodDescriptor descriptor) {
        if (this.reflectiveConstructors) {
            super.addConstructor(new ConstructorResolver(){

                public ConstructorElement resolveConstructor(int index, DefinedTypeDefinition enclosing, ConstructorElement.Builder builder) {
                    String className;
                    ConstructorElement constructorElement = resolver.resolveConstructor(index, enclosing, builder);
                    FeaturePatcher fp = FeaturePatcher.get(QbiccFeatureTypeBuilder.this.classContext.getCompilationContext());
                    if (fp.isReflectiveConstructor(className = constructorElement.getEnclosingType().getInternalName(), constructorElement.getDescriptor())) {
                        ReachabilityRoots.get((CompilationContext)QbiccFeatureTypeBuilder.this.classContext.getCompilationContext()).registerReflectiveConstructor(constructorElement);
                    }
                    return constructorElement;
                }
            }, index, descriptor);
        } else {
            this.delegate.addConstructor(resolver, index, descriptor);
        }
    }

    public void addMethod(final MethodResolver resolver, int index, String name, MethodDescriptor descriptor) {
        if (this.reflectiveMethods) {
            super.addMethod(new MethodResolver(){

                public MethodElement resolveMethod(int index, DefinedTypeDefinition enclosing, MethodElement.Builder builder) {
                    String className;
                    MethodElement methodElement = resolver.resolveMethod(index, enclosing, builder);
                    FeaturePatcher fp = FeaturePatcher.get(QbiccFeatureTypeBuilder.this.classContext.getCompilationContext());
                    if (fp.isReflectiveMethod(className = methodElement.getEnclosingType().getInternalName(), methodElement.getName(), methodElement.getDescriptor())) {
                        ReachabilityRoots.get((CompilationContext)QbiccFeatureTypeBuilder.this.classContext.getCompilationContext()).registerReflectiveMethod(methodElement);
                    }
                    return methodElement;
                }
            }, index, name, descriptor);
        } else {
            this.delegate.addMethod(resolver, index, name, descriptor);
        }
    }

    public void addField(FieldResolver resolver, int index, String name, TypeDescriptor descriptor) {
        if (this.runtimeInitialized) {
            resolver = new RuntimeInitFieldResolver(this.initResolver, this.initIndex, resolver);
        }
        if (this.reflectiveFields) {
            final FieldResolver fr = resolver;
            super.addField(new FieldResolver(){

                public FieldElement resolveField(int index, DefinedTypeDefinition enclosing, FieldElement.Builder builder) {
                    String className;
                    FieldElement fieldElement = fr.resolveField(index, enclosing, builder);
                    FeaturePatcher fp = FeaturePatcher.get(QbiccFeatureTypeBuilder.this.classContext.getCompilationContext());
                    if (fp.isReflectiveField(className = fieldElement.getEnclosingType().getInternalName(), fieldElement.getName())) {
                        ReachabilityRoots.get((CompilationContext)QbiccFeatureTypeBuilder.this.classContext.getCompilationContext()).registerReflectiveField(fieldElement);
                    }
                    return fieldElement;
                }
            }, index, name, descriptor);
        } else {
            this.delegate.addField(resolver, index, name, descriptor);
        }
    }

    static class RuntimeInitFieldResolver
    implements FieldResolver {
        private final InitializerResolver initResolver;
        private final int initIndex;
        private final FieldResolver fieldResolver;

        RuntimeInitFieldResolver(InitializerResolver initResolver, int initIndex, FieldResolver fieldResolver) {
            this.initResolver = initResolver;
            this.initIndex = initIndex;
            this.fieldResolver = fieldResolver;
        }

        public FieldElement resolveField(int index, DefinedTypeDefinition enclosing, FieldElement.Builder builder) {
            InitializerElement rtInit = this.initResolver.resolveInitializer(this.initIndex, enclosing, InitializerElement.builder());
            builder.setRunTimeInitializer(rtInit);
            FieldElement fieldElement = this.fieldResolver.resolveField(index, enclosing, builder);
            if (fieldElement.isStatic()) {
                fieldElement.setModifierFlags(0x10000000);
            }
            return fieldElement;
        }
    }
}

