/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.initializationcontrol;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import org.qbicc.context.CompilationContext;
import org.qbicc.plugin.initializationcontrol.FeaturePatcher;
import org.qbicc.plugin.initializationcontrol.QbiccFeature;
import org.qbicc.plugin.initializationcontrol.RuntimeResourceManager;

public class QbiccFeatureProcessor {
    public static void process(CompilationContext ctxt, List<Path> features) {
        if (features.isEmpty()) {
            return;
        }
        FeaturePatcher fp = FeaturePatcher.get(ctxt);
        RuntimeResourceManager rm = RuntimeResourceManager.get(ctxt);
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        mapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        for (Path feature : features) {
            QbiccFeature qf;
            try {
                FileInputStream fs = new FileInputStream(feature.toFile());
                qf = (QbiccFeature)mapper.readValue((InputStream)fs, QbiccFeature.class);
            }
            catch (FileNotFoundException e) {
                ctxt.error("Failed to open qbicc-feature %s", new Object[]{feature});
                continue;
            }
            catch (IOException e) {
                ctxt.error((Throwable)e, "Failed to parse qbicc-feature %s ", new Object[]{feature});
                continue;
            }
            ctxt.info("Processing build feature %s", new Object[]{feature});
            if (qf.initializeAtRuntime != null) {
                for (String string : qf.initializeAtRuntime) {
                    String internalName = string.replace('.', '/');
                    fp.addRuntimeInitializedClass(internalName);
                }
            }
            if (qf.runtimeResource != null) {
                for (String string : qf.runtimeResource) {
                    rm.addResource(string);
                }
            }
            if (qf.runtimeResources != null) {
                for (String string : qf.runtimeResources) {
                    rm.addResources(string);
                }
            }
            if (qf.reflectiveConstructors != null) {
                for (QbiccFeature.Constructor constructor : qf.reflectiveConstructors) {
                    fp.addReflectiveConstructor(constructor.declaringClass, constructor.descriptor);
                }
            }
            if (qf.reflectiveFields != null) {
                for (QbiccFeature.Field field : qf.reflectiveFields) {
                    fp.addReflectiveField(field.declaringClass, field.name);
                }
            }
            if (qf.reflectiveMethods == null) continue;
            for (QbiccFeature.Method method : qf.reflectiveMethods) {
                fp.addReflectiveMethod(method.declaringClass, method.name, method.descriptor);
            }
        }
    }
}

