/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.initializationcontrol;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.qbicc.context.AttachmentKey;
import org.qbicc.context.CompilationContext;
import org.qbicc.type.descriptor.MethodDescriptor;

public class FeaturePatcher {
    private static final AttachmentKey<FeaturePatcher> KEY = new AttachmentKey();
    private final CompilationContext ctxt;
    private final Set<String> runtimeInitializedClasses = ConcurrentHashMap.newKeySet();
    private final Map<String, Set<String>> reflectiveConstructors = new ConcurrentHashMap<String, Set<String>>();
    private final Map<String, Set<String>> reflectiveFields = new ConcurrentHashMap<String, Set<String>>();
    private final Map<String, Set<String>> reflectiveMethods = new ConcurrentHashMap<String, Set<String>>();

    private FeaturePatcher(CompilationContext ctxt) {
        this.ctxt = ctxt;
    }

    public static FeaturePatcher get(CompilationContext ctxt) {
        FeaturePatcher appearing;
        FeaturePatcher patcher = (FeaturePatcher)ctxt.getAttachment(KEY);
        if (patcher == null && (appearing = (FeaturePatcher)ctxt.putAttachmentIfAbsent(KEY, (Object)(patcher = new FeaturePatcher(ctxt)))) != null) {
            patcher = appearing;
        }
        return patcher;
    }

    public void addRuntimeInitializedClass(String internalName) {
        this.runtimeInitializedClasses.add(internalName);
    }

    public boolean isRuntimeInitializedClass(String internalName) {
        return this.runtimeInitializedClasses.contains(internalName);
    }

    public void addReflectiveConstructor(String className, String descriptor) {
        this.reflectiveConstructors.computeIfAbsent(className, k -> ConcurrentHashMap.newKeySet()).add(descriptor);
    }

    public boolean hasReflectiveConstructors(String className) {
        return this.reflectiveConstructors.containsKey(className);
    }

    public boolean isReflectiveConstructor(String className, MethodDescriptor descriptor) {
        Set<String> constructors = this.reflectiveConstructors.get(className);
        return constructors != null && constructors.contains(descriptor.toString());
    }

    public void addReflectiveField(String className, String fieldName) {
        this.reflectiveFields.computeIfAbsent(className, k -> ConcurrentHashMap.newKeySet()).add(fieldName);
    }

    public boolean hasReflectiveFields(String className) {
        return this.reflectiveFields.containsKey(className);
    }

    public boolean isReflectiveField(String className, String fieldName) {
        Set<String> fields = this.reflectiveFields.get(className);
        return fields != null && fields.contains(fieldName);
    }

    public void addReflectiveMethod(String className, String methodName, String descriptor) {
        String encodedMethod = methodName + ":" + descriptor;
        this.reflectiveMethods.computeIfAbsent(className, k -> ConcurrentHashMap.newKeySet()).add(encodedMethod);
    }

    public boolean hasReflectiveMethods(String className) {
        return this.reflectiveMethods.containsKey(className);
    }

    public boolean isReflectiveMethod(String className, String methodName, MethodDescriptor descriptor) {
        Set<String> encodedMethods = this.reflectiveMethods.get(className);
        return encodedMethods != null && encodedMethods.contains(methodName + ":" + descriptor);
    }
}

