/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.initializationcontrol;

import org.qbicc.context.ClassContext;
import org.qbicc.plugin.initializationcontrol.FeaturePatcher;
import org.qbicc.plugin.patcher.OnceRunTimeInitializerResolver;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.FieldResolver;
import org.qbicc.type.definition.InitializerResolver;
import org.qbicc.type.definition.element.FieldElement;
import org.qbicc.type.definition.element.InitializerElement;
import org.qbicc.type.descriptor.TypeDescriptor;

public class RuntimeInitializingTypeBuilder
implements DefinedTypeDefinition.Builder.Delegating {
    private final DefinedTypeDefinition.Builder delegate;
    private final ClassContext classContext;
    private boolean runtimeInitialized;
    private InitializerResolver initResolver;
    private int initIndex;

    public RuntimeInitializingTypeBuilder(ClassContext classCtxt, DefinedTypeDefinition.Builder delegate) {
        this.delegate = delegate;
        this.classContext = classCtxt;
    }

    public DefinedTypeDefinition.Builder getDelegate() {
        return this.delegate;
    }

    public void setName(String internalName) {
        FeaturePatcher fp = FeaturePatcher.get(this.classContext.getCompilationContext());
        if (fp.isRuntimeInitializedClass(internalName)) {
            this.runtimeInitialized = true;
        }
        this.delegate.setName(internalName);
    }

    public void setInitializer(InitializerResolver resolver, int index) {
        if (this.runtimeInitialized) {
            this.initResolver = new OnceRunTimeInitializerResolver(resolver);
            this.initIndex = index;
            this.delegate.setInitializer(resolver, -1);
        } else {
            this.delegate.setInitializer(resolver, index);
        }
    }

    public void addField(FieldResolver resolver, int index, String name, TypeDescriptor descriptor) {
        if (this.runtimeInitialized) {
            resolver = new RuntimeInitFieldResolver(this.initResolver, this.initIndex, resolver);
        }
        this.delegate.addField(resolver, index, name, descriptor);
    }

    static class RuntimeInitFieldResolver
    implements FieldResolver {
        private final InitializerResolver initResolver;
        private final int initIndex;
        private final FieldResolver fieldResolver;

        RuntimeInitFieldResolver(InitializerResolver initResolver, int initIndex, FieldResolver fieldResolver) {
            this.initResolver = initResolver;
            this.initIndex = initIndex;
            this.fieldResolver = fieldResolver;
        }

        public FieldElement resolveField(int index, DefinedTypeDefinition enclosing, FieldElement.Builder builder) {
            InitializerElement rtInit = this.initResolver.resolveInitializer(this.initIndex, enclosing, InitializerElement.builder());
            builder.setRunTimeInitializer(rtInit);
            FieldElement fieldElement = this.fieldResolver.resolveField(index, enclosing, builder);
            if (fieldElement.isStatic()) {
                fieldElement.setModifierFlags(0x10000000);
            }
            return fieldElement;
        }
    }
}

