/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.initializationcontrol;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.qbicc.context.AttachmentKey;
import org.qbicc.context.CompilationContext;

public class FeaturePatcher {
    private static final AttachmentKey<FeaturePatcher> KEY = new AttachmentKey();
    private final CompilationContext ctxt;
    private final Set<String> runtimeInitializedClasses = ConcurrentHashMap.newKeySet();

    private FeaturePatcher(CompilationContext ctxt) {
        this.ctxt = ctxt;
    }

    public static FeaturePatcher get(CompilationContext ctxt) {
        FeaturePatcher appearing;
        FeaturePatcher patcher = (FeaturePatcher)ctxt.getAttachment(KEY);
        if (patcher == null && (appearing = (FeaturePatcher)ctxt.putAttachmentIfAbsent(KEY, (Object)(patcher = new FeaturePatcher(ctxt)))) != null) {
            patcher = appearing;
        }
        return patcher;
    }

    public void addRuntimeInitializedClass(String internalName) {
        this.runtimeInitializedClasses.add(internalName);
    }

    public boolean isRuntimeInitializedClass(String internalName) {
        return this.runtimeInitializedClasses.contains(internalName);
    }
}

