/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.tool.emscripten;

import io.smallrye.common.constraint.Assert;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.qbicc.machine.tool.CCompilerInvoker;
import org.qbicc.machine.tool.emscripten.AbstractEmscriptenInvoker;
import org.qbicc.machine.tool.emscripten.EmscriptenCCompilerInvoker;
import org.qbicc.machine.tool.emscripten.EmscriptenToolChainImpl;
import org.qbicc.machine.tool.process.InputSource;

final class EmscriptenCCompilerInvokerImpl
extends AbstractEmscriptenInvoker
implements EmscriptenCCompilerInvoker {
    private final List<Path> includePaths = new ArrayList<Path>(1);
    private final List<String> definedSymbols = new ArrayList<String>(2);
    private InputSource inputSource = InputSource.empty();
    private Path outputPath = TMP.resolve("qbicc-output." + this.getTool().getPlatform().objectType().objectSuffix());
    private CCompilerInvoker.SourceLanguage sourceLanguage = CCompilerInvoker.SourceLanguage.C;

    EmscriptenCCompilerInvokerImpl(EmscriptenToolChainImpl tool) {
        super(tool);
    }

    public void addIncludePath(Path path) {
        this.includePaths.add((Path)Assert.checkNotNullParam((String)"path", (Object)path));
    }

    public int getIncludePathCount() {
        return this.includePaths.size();
    }

    public Path getIncludePath(int index) throws IndexOutOfBoundsException {
        return this.includePaths.get(index);
    }

    public void addDefinedSymbol(String name, String value) {
        Assert.checkNotNullParam((String)"name", (Object)name);
        Assert.checkNotNullParam((String)"value", (Object)value);
        this.definedSymbols.add(name);
        this.definedSymbols.add(value);
    }

    public int getDefinedSymbolCount() {
        return this.definedSymbols.size() >>> 1;
    }

    public String getDefinedSymbol(int index) throws IndexOutOfBoundsException {
        return this.definedSymbols.get(index << 1);
    }

    public String getDefinedSymbolValue(int index) throws IndexOutOfBoundsException {
        return this.definedSymbols.get((index << 1) + 1);
    }

    public void setSource(InputSource source) {
        this.inputSource = (InputSource)Assert.checkNotNullParam((String)"source", (Object)source);
    }

    @Override
    public InputSource getSource() {
        return this.inputSource;
    }

    public void setOutputPath(Path path) {
        this.outputPath = (Path)Assert.checkNotNullParam((String)"path", (Object)path);
    }

    public CCompilerInvoker.SourceLanguage getSourceLanguage() {
        return this.sourceLanguage;
    }

    public void setSourceLanguage(CCompilerInvoker.SourceLanguage sourceLanguage) {
        this.sourceLanguage = (CCompilerInvoker.SourceLanguage)Assert.checkNotNullParam((String)"sourceLanguage", (Object)sourceLanguage);
    }

    public Path getOutputPath() throws IllegalArgumentException {
        return this.outputPath;
    }

    @Override
    void addArguments(List<String> cmd) {
        if (this.sourceLanguage == CCompilerInvoker.SourceLanguage.C) {
            Collections.addAll(cmd, "-std=gnu11", "-finput-charset=UTF-8");
            cmd.add("-pthread");
        }
        cmd.add("-pipe");
        for (Path includePath : this.includePaths) {
            cmd.add("-I" + includePath.toString());
        }
        for (int i = 0; i < this.definedSymbols.size(); i += 2) {
            String key = this.definedSymbols.get(i);
            String val = this.definedSymbols.get(i + 1);
            if (val.equals("1")) {
                cmd.add("-D" + key);
                continue;
            }
            cmd.add("-D" + key + "=" + val);
        }
        this.appendEmscriptenPorts(cmd);
        this.enableExceptions(cmd);
        Collections.addAll(cmd, "-Wno-override-module", "-mbulk-memory", "-g", "-c", "-x", this.sourceLanguageArg(), "-o", this.getOutputPath().toString(), "-");
    }

    private void appendEmscriptenPorts(List<String> cmd) {
        Collections.addAll(cmd, "-sUSE_ZLIB");
    }

    private void enableExceptions(List<String> cmd) {
        Collections.addAll(cmd, "-fexceptions");
    }

    private String sourceLanguageArg() {
        return switch (this.sourceLanguage) {
            case CCompilerInvoker.SourceLanguage.ASM -> "assembler";
            case CCompilerInvoker.SourceLanguage.LLVM_IR -> "ir";
            default -> "c";
        };
    }
}

