/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.tool.emscripten;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.qbicc.machine.arch.Platform;
import org.qbicc.machine.tool.Tool;
import org.qbicc.machine.tool.ToolProvider;
import org.qbicc.machine.tool.emscripten.EmscriptenToolChainImpl;
import org.qbicc.machine.tool.process.InputSource;
import org.qbicc.machine.tool.process.OutputDestination;

public class EmscriptenToolProvider
implements ToolProvider {
    static final Pattern VERSION_PATTERN = Pattern.compile("^emcc \\(Emscripten .+\\) (.+)$");

    public <T extends Tool> Iterable<T> findTools(Class<T> type, Platform platform, Path path) {
        ArrayList list = new ArrayList();
        if (type.isAssignableFrom(EmscriptenToolChainImpl.class)) {
            this.tryOne(type, platform, list, path);
        }
        return list;
    }

    private <T extends Tool> void tryOne(Class<T> type, Platform platform, ArrayList<T> list, Path path) {
        if (path != null && Files.isExecutable(path)) {
            class Result {
                String version;
                boolean match;

                Result() {
                }
            }
            Result res = new Result();
            OutputDestination dest = OutputDestination.of(r -> {
                try (BufferedReader br = new BufferedReader((Reader)r);){
                    String line;
                    while ((line = br.readLine()) != null) {
                        Matcher matcher = VERSION_PATTERN.matcher(line);
                        if (!matcher.find()) continue;
                        res.version = matcher.group(1);
                        res.match = true;
                    }
                }
            }, (Charset)StandardCharsets.UTF_8);
            ProcessBuilder pb = new ProcessBuilder(path.toString(), "-v");
            try {
                InputSource.empty().transferTo(OutputDestination.of((ProcessBuilder)pb, (OutputDestination)dest, (OutputDestination)OutputDestination.discarding()));
            }
            catch (IOException e) {
                return;
            }
            if (res.match) {
                EmscriptenToolChainImpl cc = new EmscriptenToolChainImpl(path, platform, res.version);
                list.add((Tool)type.cast(cc));
            }
        }
    }
}

