/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.tool.emscripten;

import io.smallrye.common.constraint.Assert;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.logging.Logger;
import org.qbicc.machine.tool.CompilationFailureException;
import org.qbicc.machine.tool.MessagingToolInvoker;
import org.qbicc.machine.tool.ToolInvoker;
import org.qbicc.machine.tool.ToolMessageHandler;
import org.qbicc.machine.tool.emscripten.EmscriptenToolChainImpl;
import org.qbicc.machine.tool.process.InputSource;
import org.qbicc.machine.tool.process.OutputDestination;

abstract class AbstractEmscriptenInvoker
implements MessagingToolInvoker {
    static final Path TMP = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
    private static final Logger LOGGER = Logger.getLogger((String)"org.qbicc.machine.tool.emscripten");
    private final EmscriptenToolChainImpl tool;
    private ToolMessageHandler messageHandler = ToolMessageHandler.DISCARDING;
    static final Pattern DIAG_PATTERN = Pattern.compile("([^ :]+):(?:(\\d+):(?:(\\d+):)?)? (?i:(?<levelStr>error|warning|note): )?(?<msg>.*)(?: \\[-[^]]+])?");

    AbstractEmscriptenInvoker(EmscriptenToolChainImpl tool) {
        this.tool = tool;
    }

    public void setMessageHandler(ToolMessageHandler messageHandler) {
        this.messageHandler = (ToolMessageHandler)Assert.checkNotNullParam((String)"messageHandler", (Object)messageHandler);
    }

    public ToolMessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public EmscriptenToolChainImpl getTool() {
        return this.tool;
    }

    public Path getPath() {
        return this.tool.getExecutablePath();
    }

    void collectError(Reader reader) throws IOException {
        ToolMessageHandler handler = this.getMessageHandler();
        try (BufferedReader br = new BufferedReader(reader);){
            String line;
            while ((line = br.readLine()) != null) {
                Matcher matcher = DIAG_PATTERN.matcher(line.trim());
                ToolMessageHandler.Level level = ToolMessageHandler.Level.ERROR;
                String fileOrExecutable = "";
                String msg = line;
                int lnum = -1;
                if (matcher.matches()) {
                    fileOrExecutable = matcher.group(1);
                    try {
                        lnum = Integer.parseInt(matcher.group(2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    String levelStr = matcher.group("levelStr");
                    msg = matcher.group("msg");
                    if (levelStr != null) {
                        switch (levelStr) {
                            case "note": {
                                level = ToolMessageHandler.Level.INFO;
                                break;
                            }
                            case "warning": {
                                level = ToolMessageHandler.Level.WARNING;
                                break;
                            }
                            case "error": {
                                level = ToolMessageHandler.Level.ERROR;
                            }
                        }
                    }
                }
                handler.handleMessage((ToolInvoker)this, level, fileOrExecutable, lnum, -1, msg);
            }
        }
    }

    void addArguments(List<String> cmd) {
    }

    InputSource getSource() {
        return InputSource.empty();
    }

    public void invoke() throws IOException {
        OutputDestination errorHandler = OutputDestination.of(AbstractEmscriptenInvoker::collectError, (Object)this, (Charset)StandardCharsets.UTF_8);
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(this.getTool().getExecutablePath().toString());
        this.addArguments(cmd);
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.command(cmd);
        pb.environment().put("LC_ALL", "C");
        pb.environment().put("LANG", "C");
        LOGGER.info((Object)String.join((CharSequence)" ", cmd));
        this.getSource().transferTo(OutputDestination.of((ProcessBuilder)pb, (OutputDestination)errorHandler, (OutputDestination)OutputDestination.discarding(), p -> {
            int ev = p.exitValue();
            if (ev != 0) {
                throw new CompilationFailureException("Compiler terminated with exit code " + ev);
            }
        }));
    }
}

