/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.tool.process;

import java.io.IOException;

public final class LimitedAppendable
implements Appendable {
    final Appendable delegate;
    final int limit;
    int size;

    public LimitedAppendable(Appendable delegate, int limit) {
        this.delegate = delegate;
        this.limit = limit;
    }

    @Override
    public Appendable append(CharSequence csq) throws IOException {
        return this.append(csq, 0, csq.length());
    }

    @Override
    public Appendable append(CharSequence csq, int start, int end) throws IOException {
        if (start > end || start < 0) {
            throw new IllegalArgumentException();
        }
        int amt = end - start;
        if (amt > 0) {
            int rem = this.limit - this.size;
            if (amt < rem) {
                this.size += amt;
                this.delegate.append(csq, start, end);
            } else if (rem > 0) {
                this.size += rem;
                this.delegate.append(csq, start, start + rem);
            }
        }
        return this;
    }

    @Override
    public Appendable append(char c) throws IOException {
        if (this.size < this.limit) {
            this.delegate.append(c);
        }
        return this;
    }
}

