/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.tool.process;

import io.smallrye.common.function.ExceptionConsumer;
import io.smallrye.common.function.ExceptionRunnable;
import java.io.Closeable;
import java.io.IOException;
import org.qbicc.machine.tool.ToolExecutionFailureException;
import org.qbicc.machine.tool.process.CloseableThread;

final class Closeables {
    static final Closeable BLANK_CLOSEABLE = new Closeable(){

        @Override
        public void close() {
        }
    };

    private Closeables() {
    }

    static Closeable start(final CloseableThread thread) throws IOException {
        try {
            thread.start();
        }
        catch (Throwable t) {
            throw new IOException("Problem starting thread", t);
        }
        return new Closeable(){

            @Override
            public void close() throws IOException {
                boolean intr = false;
                while (true) {
                    try {
                        thread.join();
                        Throwable problem = thread.problem;
                        if (problem != null) {
                            try {
                                throw problem;
                            }
                            catch (Error | RuntimeException | ToolExecutionFailureException e) {
                                throw e;
                            }
                            catch (Throwable t) {
                                throw new ToolExecutionFailureException("Tool output collection failed", t);
                            }
                        }
                        return;
                    }
                    catch (InterruptedException ignored) {
                        thread.interrupt();
                        intr = true;
                        continue;
                    }
                    break;
                }
                finally {
                    if (intr) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        };
    }

    static Closeable start(String name, ExceptionRunnable<IOException> body) throws IOException {
        return Closeables.start(new CloseableThread(name, body));
    }

    static Closeable cleanup(final Closeable closeable, final ExceptionConsumer<IOException, IOException> action) {
        return new Closeable(){

            @Override
            public void close() throws IOException {
                try {
                    closeable.close();
                    action.accept(null);
                }
                catch (IOException e) {
                    action.accept((Object)e);
                }
            }
        };
    }
}

