/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.tool;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public final class ToolUtil {
    public static final List<Path> OS_PATH;

    private ToolUtil() {
    }

    public static Path findExecutable(String name) {
        return ToolUtil.findExecutableOnPath(name, OS_PATH);
    }

    public static Path findExecutable(String name, List<Path> extraPaths) {
        Path found = ToolUtil.findExecutableOnPath(name, OS_PATH);
        if (found == null) {
            found = ToolUtil.findExecutableOnPath(name, extraPaths);
        }
        return found;
    }

    public static Path findExecutableOnPath(String name, List<Path> paths) {
        for (Path path : paths) {
            Path exec = path.resolve(name);
            if (!Files.isRegularFile(exec, new LinkOption[0]) || !Files.isReadable(exec) || !Files.isExecutable(exec)) continue;
            return exec;
        }
        return null;
    }

    static {
        List<Object> osPath;
        String pathValue = System.getenv("PATH");
        if (pathValue == null) {
            osPath = Collections.emptyList();
        } else {
            String[] elements = pathValue.split(Pattern.quote(File.pathSeparator));
            Path[] pathItems = new Path[elements.length];
            int j = 0;
            for (String element : elements) {
                Path path;
                if (element.isEmpty() || !Files.isDirectory(path = Path.of(element, new String[0]), new LinkOption[0])) continue;
                pathItems[j++] = path;
            }
            osPath = List.of(Arrays.copyOf(pathItems, j));
        }
        OS_PATH = osPath;
    }
}

