/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.tool.process;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.List;
import org.qbicc.machine.tool.process.Closeables;
import org.qbicc.machine.tool.process.InputSource;
import org.qbicc.machine.tool.process.OutputDestination;

final class PathOutputDestination
extends OutputDestination {
    private final Path path;

    PathOutputDestination(Path path) {
        this.path = path;
    }

    @Override
    void transferFrom(InputSource source) throws IOException {
        source.writeTo(this.path);
    }

    @Override
    void transferFrom(InputStream stream) throws IOException {
        Files.copy(stream, this.path, StandardCopyOption.REPLACE_EXISTING);
    }

    @Override
    void transferFrom(Reader reader, Charset charset) throws IOException {
        try (BufferedWriter w = Files.newBufferedWriter(this.path, charset, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            reader.transferTo(w);
        }
    }

    @Override
    Closeable transferFromErrorOf(Process process, ProcessBuilder.Redirect redirect) throws IOException {
        if (redirect == ProcessBuilder.Redirect.PIPE) {
            return super.transferFromErrorOf(process, redirect);
        }
        return Closeables.BLANK_CLOSEABLE;
    }

    @Override
    void chain(List<Process> processes, List<ProcessBuilder> processBuilders, int index) throws IOException {
        ProcessBuilder processBuilder = processBuilders.get(index - 1);
        Process process = processes.get(index - 1);
        if (processBuilder.redirectOutput() == ProcessBuilder.Redirect.PIPE) {
            this.transferFrom(process.getInputStream());
        }
    }

    @Override
    ProcessBuilder.Redirect getOutputRedirect() {
        if (this.path.getFileSystem() == FileSystems.getDefault()) {
            return ProcessBuilder.Redirect.to(this.path.toFile());
        }
        return ProcessBuilder.Redirect.PIPE;
    }
}

