/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.tool.process;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.qbicc.machine.tool.process.Closeables;
import org.qbicc.machine.tool.process.InputSource;
import org.qbicc.machine.tool.process.OutputDestination;

final class PathInputSource
extends InputSource {
    private final Path path;

    PathInputSource(Path path) {
        this.path = path;
    }

    @Override
    public void transferTo(OutputDestination destination) throws IOException {
        destination.transferFrom(this);
    }

    @Override
    ProcessBuilder.Redirect getInputRedirect() {
        if (this.path.getFileSystem() == FileSystems.getDefault()) {
            return ProcessBuilder.Redirect.from(this.path.toFile());
        }
        return ProcessBuilder.Redirect.PIPE;
    }

    @Override
    Closeable provideProcessInput(Process process, ProcessBuilder.Redirect inputRedirect) throws IOException {
        if (inputRedirect == ProcessBuilder.Redirect.PIPE) {
            return super.provideProcessInput(process, inputRedirect);
        }
        return Closeables.BLANK_CLOSEABLE;
    }

    @Override
    void transferTo(OutputStream os) throws IOException {
        Files.copy(this.path, os);
    }

    @Override
    InputStream openStream() throws IOException {
        return Files.newInputStream(this.path, new OpenOption[0]);
    }

    @Override
    void writeTo(Path path) throws IOException {
        Files.copy(this.path, path, StandardCopyOption.REPLACE_EXISTING);
    }

    Path getPath() {
        return this.path;
    }

    @Override
    public String toString() {
        return this.path.toString();
    }
}

