/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.tool.process;

import io.smallrye.common.function.ExceptionBiConsumer;
import io.smallrye.common.function.ExceptionRunnable;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import org.qbicc.machine.tool.process.Closeables;
import org.qbicc.machine.tool.process.OutputDestination;
import org.qbicc.machine.tool.process.OutputStreamConsumerInputSource;
import org.qbicc.machine.tool.process.WriterConsumerInputSource;

final class InputStreamConsumerOutputDestination<T>
extends OutputDestination {
    private final ExceptionBiConsumer<T, InputStream, IOException> consumer;
    private final T param;

    InputStreamConsumerOutputDestination(ExceptionBiConsumer<T, InputStream, IOException> consumer, T param) {
        this.consumer = consumer;
        this.param = param;
    }

    @Override
    void transferFrom(InputStream stream) throws IOException {
        this.consumer.accept(this.param, (Object)stream);
    }

    @Override
    void transferFrom(Reader reader, Charset charset) throws IOException {
        try (PipedInputStream inputStream = new PipedInputStream();
             PipedOutputStream outputStream = new PipedOutputStream(inputStream);
             Closeable thr1 = Closeables.start("Transfer thread", (ExceptionRunnable<IOException>)((ExceptionRunnable)() -> this.transferFrom(inputStream)));
             OutputStreamWriter osw = new OutputStreamWriter((OutputStream)outputStream, charset);){
            reader.transferTo(osw);
        }
    }

    @Override
    void transferFrom(OutputStreamConsumerInputSource<?> source) throws IOException {
        try (PipedInputStream inputStream = new PipedInputStream();
             PipedOutputStream outputStream = new PipedOutputStream(inputStream);
             Closeable thr1 = Closeables.start("Transfer thread", (ExceptionRunnable<IOException>)((ExceptionRunnable)() -> this.transferFrom(inputStream)));){
            source.transferTo(outputStream);
        }
    }

    @Override
    void transferFrom(WriterConsumerInputSource<?> source) throws IOException {
        try (PipedInputStream inputStream = new PipedInputStream();
             PipedOutputStream outputStream = new PipedOutputStream(inputStream);
             Closeable thr1 = Closeables.start("Transfer thread", (ExceptionRunnable<IOException>)((ExceptionRunnable)() -> this.transferFrom(inputStream)));){
            source.transferTo(outputStream);
        }
    }

    @Override
    ProcessBuilder.Redirect getOutputRedirect() {
        return ProcessBuilder.Redirect.PIPE;
    }
}

