/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.tool.process;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.qbicc.machine.tool.process.CharBufferInputStream;
import org.qbicc.machine.tool.process.CharSequenceReader;
import org.qbicc.machine.tool.process.InputSource;
import org.qbicc.machine.tool.process.OutputDestination;

final class CharSequenceInputSource
extends InputSource {
    private final CharSequence charSequence;
    private final Charset charset;

    CharSequenceInputSource(CharSequence charSequence, Charset charset) {
        this.charSequence = charSequence;
        this.charset = charset;
    }

    @Override
    public void transferTo(OutputDestination destination) throws IOException {
        CharSequence charSequence = this.charSequence;
        if (charSequence instanceof String) {
            destination.transferFrom(new StringReader((String)charSequence), this.charset);
        } else {
            destination.transferFrom(new CharSequenceReader(charSequence), this.charset);
        }
    }

    @Override
    ProcessBuilder.Redirect getInputRedirect() {
        return ProcessBuilder.Redirect.PIPE;
    }

    @Override
    void transferTo(OutputStream os) throws IOException {
        try (OutputStreamWriter osw = new OutputStreamWriter(os, this.charset);){
            osw.append(this.charSequence);
        }
    }

    void transferTo(Appendable destination) throws IOException {
        destination.append(this.charSequence);
    }

    @Override
    InputStream openStream() {
        return new CharBufferInputStream(CharBuffer.wrap(this.charSequence), this.charset.newEncoder());
    }

    @Override
    void writeTo(Path path) throws IOException {
        Files.writeString(path, this.charSequence, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    @Override
    public String toString() {
        return "<string>";
    }
}

