/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.tool.process;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;

final class CharBufferInputStream
extends InputStream {
    final ByteBuffer bb;
    private final CharBuffer buf;
    private final CharsetEncoder e;

    CharBufferInputStream(CharBuffer buf, CharsetEncoder e) {
        this.buf = buf;
        this.e = e;
        this.bb = ByteBuffer.allocate(256).limit(0);
    }

    @Override
    public void close() {
        this.bb.limit(0);
        this.buf.limit(0);
    }

    @Override
    public int available() {
        return this.bb.remaining();
    }

    @Override
    public long transferTo(OutputStream out) throws IOException {
        while (!this.bb.hasRemaining()) {
            if (!this.buf.hasRemaining()) {
                return 0L;
            }
            this.fill();
        }
        int cnt = this.bb.remaining();
        out.write(this.bb.array(), this.bb.arrayOffset() + this.bb.position(), cnt);
        this.bb.limit(0);
        return cnt;
    }

    @Override
    public int read() {
        while (!this.bb.hasRemaining()) {
            if (!this.buf.hasRemaining()) {
                return -1;
            }
            this.fill();
        }
        return this.bb.get() & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        while (!this.bb.hasRemaining()) {
            if (!this.buf.hasRemaining()) {
                return -1;
            }
            this.fill();
        }
        int cnt = Math.min(len, this.bb.remaining());
        this.bb.get(b, off, cnt);
        return cnt;
    }

    private void fill() {
        this.bb.clear();
        try {
            this.e.encode(this.buf, this.bb, true);
        }
        finally {
            this.bb.flip();
        }
    }

    @Override
    public long skip(long n) {
        long c = 0L;
        long diff = n - c;
        while (diff > 0L) {
            if ((long)this.bb.remaining() < diff) {
                this.bb.position(0);
                this.bb.limit(0);
                if (this.read() == -1) {
                    return diff;
                }
                diff = n - ++c;
                continue;
            }
            this.bb.position((int)((long)this.bb.position() + diff));
            return n;
        }
        return diff;
    }
}

