/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.tool.process;

import java.io.IOException;
import java.io.Writer;
import java.nio.CharBuffer;

final class AppendableWriter
extends Writer {
    private final Appendable appendable;

    AppendableWriter(Appendable appendable) {
        this.appendable = appendable;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.appendable instanceof StringBuilder) {
            ((StringBuilder)this.appendable).append(cbuf, off, len);
        } else if (this.appendable instanceof CharBuffer) {
            ((CharBuffer)this.appendable).put(cbuf, off, len);
        } else {
            this.appendable.append(new String(cbuf, off, len));
        }
    }

    @Override
    public void write(int c) throws IOException {
        this.appendable.append((char)c);
    }

    @Override
    public void write(String str) throws IOException {
        this.appendable.append(str);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.appendable.append(str, off, len);
    }

    @Override
    public Writer append(CharSequence csq) throws IOException {
        this.appendable.append(csq);
        return this;
    }

    @Override
    public Writer append(CharSequence csq, int start, int end) throws IOException {
        this.appendable.append(csq, start, end);
        return this;
    }

    @Override
    public Writer append(char c) throws IOException {
        this.appendable.append(c);
        return this;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }
}

