/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.tool;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.qbicc.machine.arch.Cpu;
import org.qbicc.machine.arch.OS;
import org.qbicc.machine.arch.Platform;
import org.qbicc.machine.tool.CCompilerInvoker;
import org.qbicc.machine.tool.LinkerInvoker;
import org.qbicc.machine.tool.Tool;
import org.qbicc.machine.tool.ToolMessageHandler;
import org.qbicc.machine.tool.ToolProvider;
import org.qbicc.machine.tool.ToolUtil;
import org.qbicc.machine.tool.process.InputSource;

public interface CToolChain
extends Tool {
    @Override
    default public String getToolName() {
        return "C Tool Chain";
    }

    public CCompilerInvoker newCompilerInvoker();

    public LinkerInvoker newLinkerInvoker();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iterable<CToolChain> findAllCToolChains(Platform platform, Predicate<? super CToolChain> filter, ClassLoader classLoader) {
        ArrayList<Path> paths = new ArrayList<Path>();
        ArrayList<Object> names = new ArrayList<Object>(16);
        Cpu cpu = platform.getCpu();
        String cpuName = cpu.getSimpleName();
        OS os = platform.getOs();
        String osName = os.getName();
        String cc = System.getenv("CC");
        if (cc != null) {
            names.add(cc);
        } else {
            if (os == OS.LINUX && (os != Platform.HOST_PLATFORM.getOs() || cpu != Platform.HOST_PLATFORM.getCpu())) {
                names.add(cpuName + "-" + osName + "-gnu-gcc");
            }
            names.addAll(List.of("cc", "gcc", "clang"));
        }
        for (String string : names) {
            Path path = ToolUtil.findExecutable(string);
            if (path == null) continue;
            paths.add(path);
        }
        Iterable<? super CToolChain> iterable = ToolProvider.findAllTools(CToolChain.class, platform, filter, classLoader, paths);
        ArrayList<CToolChain> arrayList = new ArrayList<CToolChain>();
        for (CToolChain cToolChain : iterable) {
            Path tempFile;
            CCompilerInvoker compilerInvoker = cToolChain.newCompilerInvoker();
            compilerInvoker.setSource(InputSource.from("int main() { return 0; }"));
            try {
                tempFile = Files.createTempFile(null, ".out", new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot create temporary file", e);
            }
            try {
                compilerInvoker.setOutputPath(tempFile);
                compilerInvoker.setMessageHandler(ToolMessageHandler.DISCARDING);
                compilerInvoker.invoke();
            }
            catch (IOException e) {}
            continue;
            finally {
                try {
                    Files.delete(tempFile);
                }
                catch (IOException e) {}
                continue;
            }
            arrayList.add(cToolChain);
        }
        return arrayList;
    }
}

