/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.tool.process;

import io.smallrye.common.constraint.Assert;
import io.smallrye.common.function.ExceptionFunction;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import org.qbicc.machine.tool.process.InputSource;
import org.qbicc.machine.tool.process.OutputDestination;

final class ReaderSupplierInputSource<T>
extends InputSource {
    private final ExceptionFunction<T, Reader, IOException> readerFactory;
    private final T param;
    private final Charset charset;

    ReaderSupplierInputSource(ExceptionFunction<T, Reader, IOException> readerFactory, T param, Charset charset) {
        this.readerFactory = readerFactory;
        this.param = param;
        this.charset = charset;
    }

    @Override
    public void transferTo(OutputDestination destination) throws IOException {
        try (Reader reader = this.openReader();){
            destination.transferFrom(reader, this.charset);
        }
    }

    @Override
    ProcessBuilder.Redirect getInputRedirect() {
        return ProcessBuilder.Redirect.PIPE;
    }

    @Override
    void transferTo(OutputStream os) throws IOException {
        try (Reader reader = this.openReader();
             OutputStreamWriter writer = new OutputStreamWriter(os, this.charset);){
            reader.transferTo(writer);
        }
    }

    Reader openReader() throws IOException {
        return (Reader)this.readerFactory.apply(this.param);
    }

    @Override
    InputStream openStream() {
        throw Assert.unsupported();
    }

    @Override
    public String toString() {
        return "<stream>";
    }
}

