/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.tool.process;

import io.smallrye.common.function.ExceptionConsumer;
import io.smallrye.common.function.ExceptionFunction;
import io.smallrye.common.function.ExceptionRunnable;
import io.smallrye.common.function.ExceptionUnaryOperator;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.List;
import java.util.function.Function;
import org.qbicc.machine.tool.process.Closeables;
import org.qbicc.machine.tool.process.InputSource;
import org.qbicc.machine.tool.process.InputStreamSupplierInputSource;
import org.qbicc.machine.tool.process.OutputDestination;
import org.qbicc.machine.tool.process.ReaderSupplierInputSource;

final class ProcessOutputDestination<T>
extends OutputDestination {
    static final Function<Process, InputSource> DEFAULT_CHAIN_SOURCE = process -> new InputStreamSupplierInputSource<InputStream>((ExceptionFunction<InputStream, InputStream, IOException>)ExceptionUnaryOperator.identity(), process.getInputStream());
    static final ExceptionConsumer<Process, IOException> DEFAULT_CHECKER = p -> {
        if (p.exitValue() != 0) {
            throw new IOException("Process returned exit code " + p.exitValue());
        }
    };
    private final OutputDestination output;
    private final OutputDestination error;
    private final Function<Process, InputSource> chainSource = DEFAULT_CHAIN_SOURCE;
    private final ExceptionConsumer<Process, IOException> checker;
    private final boolean breakChain = false;
    private final ExceptionFunction<T, ProcessBuilder, IOException> supplier;
    private final T param;

    ProcessOutputDestination(ExceptionFunction<T, ProcessBuilder, IOException> supplier, T param, OutputDestination errorDest, OutputDestination outputDest, ExceptionConsumer<Process, IOException> checker) {
        this.supplier = supplier;
        this.param = param;
        this.output = outputDest;
        this.error = errorDest;
        this.checker = checker;
    }

    @Override
    List<ProcessBuilder> getBuilderPipeline(ProcessBuilder.Redirect inputRedirect, int index) throws IOException {
        ProcessBuilder pb = (ProcessBuilder)this.supplier.apply(this.param);
        pb.redirectInput(inputRedirect);
        pb.redirectError(this.error.getOutputRedirect());
        pb.redirectOutput(this.output.getOutputRedirect());
        List<ProcessBuilder> pipeline = this.output.getBuilderPipeline(ProcessBuilder.Redirect.PIPE, index + 1);
        pipeline.set(index, pb);
        return pipeline;
    }

    @Override
    void chain(List<Process> processes, List<ProcessBuilder> processBuilders, int index) throws IOException {
        if (index == processes.size()) {
            super.chain(processes, processBuilders, index);
            return;
        }
        Process process = processes.get(index);
        String name = "Waiter thread for process " + InputSource.nameOf(process);
        try (Closeable c1 = Closeables.start(name, (ExceptionRunnable<IOException>)((ExceptionRunnable)() -> {
            while (true) {
                try {
                    process.waitFor();
                    this.checker.accept((Object)process);
                    return;
                }
                catch (InterruptedException e) {
                    process.destroy();
                    continue;
                }
                break;
            }
        }));
             InputStream errorStream = process.getErrorStream();
             Closeable c2 = this.error.transferFromErrorOf(process, processBuilders.get(index).redirectError());){
            this.output.chain(processes, processBuilders, index + 1);
        }
    }

    @Override
    void transferFrom(InputSource source) throws IOException {
        ProcessBuilder.Redirect inputRedirect = source.getInputRedirect();
        List<ProcessBuilder> processBuilders = this.getBuilderPipeline(inputRedirect, 0);
        List<Process> processes = ProcessBuilder.startPipeline(processBuilders);
        try (Closeable c = source.provideProcessInput(processes.get(0), inputRedirect);){
            this.chain(processes, processBuilders, 0);
        }
    }

    @Override
    void transferFrom(InputStream stream) throws IOException {
        this.transferFrom(new InputStreamSupplierInputSource<InputStream>((ExceptionFunction<InputStream, InputStream, IOException>)ExceptionUnaryOperator.identity(), stream));
    }

    @Override
    void transferFrom(Reader reader, Charset charset) throws IOException {
        this.transferFrom(new ReaderSupplierInputSource<Reader>((ExceptionFunction<Reader, Reader, IOException>)ExceptionUnaryOperator.identity(), reader, charset));
    }

    @Override
    ProcessBuilder.Redirect getOutputRedirect() {
        return ProcessBuilder.Redirect.PIPE;
    }
}

