/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.tool.process;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.CharBuffer;

class CharSequenceReader
extends Reader {
    private final CharSequence charSequence;
    private int mark;
    private int pos;

    CharSequenceReader(CharSequence charSequence) {
        this.charSequence = charSequence;
    }

    @Override
    public int read(char[] cbuf, int off, int len) {
        CharSequence charSequence = this.charSequence;
        int length = charSequence.length();
        if (this.pos == length) {
            return -1;
        }
        int cnt = Math.min(len, length - this.pos);
        if (charSequence instanceof StringBuilder) {
            ((StringBuilder)charSequence).getChars(this.pos, this.pos + cnt, cbuf, off);
        } else {
            for (int i = 0; i < cnt; ++i) {
                cbuf[i + off] = charSequence.charAt(this.pos++);
            }
        }
        return cnt;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public long skip(long n) {
        int length = this.charSequence.length();
        int cnt = (int)Math.min(n, (long)(length - this.pos));
        this.pos += cnt;
        return cnt;
    }

    @Override
    public boolean ready() {
        return true;
    }

    @Override
    public void mark(int readAheadLimit) {
        this.mark = this.pos;
    }

    @Override
    public void reset() {
        this.pos = this.mark;
    }

    @Override
    public int read() {
        int pos = this.pos;
        if (pos == this.charSequence.length()) {
            return -1;
        }
        this.pos = pos + 1;
        return this.charSequence.charAt(pos);
    }

    @Override
    public long transferTo(Writer out) throws IOException {
        int length = this.charSequence.length();
        int pos = this.pos;
        out.append(this.charSequence, pos, length);
        this.pos = length;
        return length - pos;
    }

    @Override
    public int read(CharBuffer target) {
        int length = this.charSequence.length();
        int pos = this.pos;
        int cnt = Math.min(target.remaining(), length - pos);
        target.append(this.charSequence, pos, pos + cnt);
        return cnt;
    }

    @Override
    public void close() {
        this.pos = this.charSequence.length();
    }
}

