/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.tool;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.function.Predicate;
import org.qbicc.machine.arch.Platform;
import org.qbicc.machine.tool.Tool;

public interface ToolProvider {
    public <T extends Tool> Iterable<T> findTools(Class<T> var1, Platform var2, Path var3);

    public static <T extends Tool> Iterable<T> findAllTools(Class<T> type, Platform platform, Predicate<? super T> filter, ClassLoader classLoader, List<Path> paths) {
        ArrayList<Tool> list = new ArrayList<Tool>();
        ServiceLoader<ToolProvider> loader = ServiceLoader.load(ToolProvider.class, classLoader);
        block2: for (Path path : paths) {
            Iterator<ToolProvider> iterator = loader.iterator();
            while (true) {
                try {
                    while (iterator.hasNext()) {
                        ToolProvider item = iterator.next();
                        for (Tool t : item.findTools(type, platform, path)) {
                            if (!filter.test(t)) continue;
                            list.add(t);
                        }
                    }
                    continue block2;
                }
                catch (ServiceConfigurationError serviceConfigurationError) {
                    continue;
                }
                break;
            }
        }
        return list;
    }
}

