/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.widget.text;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingWidget;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceImageCreator;

public class CapsLockPasswordBorderWidget
extends RadianceThemingWidget<JPasswordField> {
    private PropertyChangeListener propertyChangeListener;
    private KeyAdapter keyAdapter;
    private boolean isUninstalling = false;
    private static final String ORIGINAL_BORDER = "radiance.theming.internal.capsLockBorder.original";

    @Override
    public void installListeners() {
        this.propertyChangeListener = propertyChangeEvent -> {
            if ("border".equals(propertyChangeEvent.getPropertyName())) {
                return;
            }
            if (ORIGINAL_BORDER.equals(propertyChangeEvent.getPropertyName())) {
                return;
            }
            SwingUtilities.invokeLater(() -> {
                if (this.isUninstalling) {
                    return;
                }
                boolean hasCapsLockIcon = CapsLockPasswordBorderWidget.hasCapsLockIcon(this.jcomp);
                if (hasCapsLockIcon) {
                    this.installCapsLockBorder();
                } else {
                    this.restoreOriginalBorder();
                }
            });
        };
        ((JPasswordField)this.jcomp).addPropertyChangeListener(this.propertyChangeListener);
        this.keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                ((JPasswordField)CapsLockPasswordBorderWidget.this.jcomp).repaint();
            }

            @Override
            public void keyReleased(KeyEvent e) {
                ((JPasswordField)CapsLockPasswordBorderWidget.this.jcomp).repaint();
            }
        };
        ((JPasswordField)this.jcomp).addKeyListener(this.keyAdapter);
    }

    @Override
    public void uninstallListeners() {
        ((JPasswordField)this.jcomp).removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
        ((JPasswordField)this.jcomp).removeKeyListener(this.keyAdapter);
        this.keyAdapter = null;
    }

    @Override
    public void uninstallUI() {
        this.isUninstalling = true;
        Border original = (Border)((JPasswordField)this.jcomp).getClientProperty(ORIGINAL_BORDER);
        if (original != null) {
            ((JPasswordField)this.jcomp).setBorder(original);
        }
    }

    @Override
    public void installDefaults() {
        super.installDefaults();
        if (CapsLockPasswordBorderWidget.hasCapsLockIcon(this.jcomp)) {
            Border currBorder = ((JPasswordField)this.jcomp).getBorder();
            ((JPasswordField)this.jcomp).putClientProperty(ORIGINAL_BORDER, currBorder);
            ((JPasswordField)this.jcomp).setBorder(new CapsLockBorder(currBorder));
        }
    }

    @Override
    public void uninstallDefaults() {
        this.isUninstalling = true;
        ((JPasswordField)this.jcomp).putClientProperty(ORIGINAL_BORDER, null);
    }

    private void installCapsLockBorder() {
        if (((JPasswordField)this.jcomp).getClientProperty(ORIGINAL_BORDER) instanceof Border) {
            return;
        }
        Border currBorder = ((JPasswordField)this.jcomp).getBorder();
        if (currBorder != null) {
            ((JPasswordField)this.jcomp).putClientProperty(ORIGINAL_BORDER, currBorder);
            ((JPasswordField)this.jcomp).setBorder(new CapsLockBorder(currBorder));
        }
    }

    private void restoreOriginalBorder() {
        if (((JPasswordField)this.jcomp).getClientProperty(ORIGINAL_BORDER) instanceof Border) {
            Border originalBorder = (Border)((JPasswordField)this.jcomp).getClientProperty(ORIGINAL_BORDER);
            ((JPasswordField)this.jcomp).setBorder(originalBorder);
            ((JPasswordField)this.jcomp).putClientProperty(ORIGINAL_BORDER, null);
        }
    }

    private static boolean hasCapsLockIcon(Component comp) {
        if (!RadianceCoreUtilities.toShowExtraWidgets(comp)) {
            return false;
        }
        if (comp instanceof JComponent) {
            if (Boolean.TRUE.equals(((JComponent)comp).getClientProperty("radiance.theming.internal.widget.hasCapsLockIcon"))) {
                return true;
            }
            if (Boolean.FALSE.equals(((JComponent)comp).getClientProperty("radiance.theming.internal.widget.hasCapsLockIcon"))) {
                return false;
            }
        }
        return Boolean.TRUE.equals(UIManager.get("radiance.theming.internal.widget.hasCapsLockIcon"));
    }

    private static class CapsLockBorder
    implements Border,
    UIResource {
        private Border originalBorder;

        public CapsLockBorder(Border originalBorder) {
            this.originalBorder = originalBorder != null ? originalBorder : new EmptyBorder(0, 0, 0, 0);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            Icon capsLockIcon = RadianceImageCreator.getCapsLockIcon(RadianceColorSchemeUtilities.getColorScheme(c, ComponentState.ENABLED), c);
            Insets origInsets = this.originalBorder.getBorderInsets(c);
            if (c.getComponentOrientation().isLeftToRight()) {
                return new Insets(origInsets.top, origInsets.left, origInsets.bottom, Math.max(origInsets.right, capsLockIcon.getIconWidth() + 6));
            }
            return new Insets(origInsets.top, Math.max(origInsets.left, capsLockIcon.getIconWidth() + 6), origInsets.bottom, origInsets.right);
        }

        @Override
        public boolean isBorderOpaque() {
            return this.originalBorder.isBorderOpaque();
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            this.originalBorder.paintBorder(c, g, x, y, width, height);
            if (!c.isFocusOwner()) {
                return;
            }
            try {
                if (!Toolkit.getDefaultToolkit().getLockingKeyState(20)) {
                    return;
                }
            }
            catch (UnsupportedOperationException e) {
                return;
            }
            Icon capsLockIcon = RadianceImageCreator.getCapsLockIcon(RadianceColorSchemeUtilities.getColorScheme(c, ComponentState.ENABLED), c);
            int iconY = y + (height - capsLockIcon.getIconHeight()) / 2;
            if (c.getComponentOrientation().isLeftToRight()) {
                capsLockIcon.paintIcon(c, g, x + width - capsLockIcon.getIconWidth() - 4, iconY);
            } else {
                capsLockIcon.paintIcon(c, g, x + 4, iconY);
            }
        }
    }
}

